/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty.websocket;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.BoundExecutable;
import io.micronaut.core.bind.DefaultExecutableBinder;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.netty.websocket.AbstractNettyWebSocketHandler;
import io.micronaut.http.netty.websocket.NettyWebSocketSession;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.websocket.CloseReason;
import io.micronaut.websocket.WebSocketPongMessage;
import io.micronaut.websocket.WebSocketSession;
import io.micronaut.websocket.annotation.ClientWebSocket;
import io.micronaut.websocket.bind.WebSocketState;
import io.micronaut.websocket.context.WebSocketBean;
import io.micronaut.websocket.exceptions.WebSocketClientException;
import io.micronaut.websocket.exceptions.WebSocketSessionException;
import io.micronaut.websocket.interceptor.WebSocketSessionAware;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

@Internal
public class NettyWebSocketClientHandler<T>
extends AbstractNettyWebSocketHandler {
    private final WebSocketClientHandshaker handshaker;
    private final WebSocketBean<T> genericWebSocketBean;
    private final Sinks.One<T> completion = Sinks.one();
    private final UriMatchInfo matchInfo;
    private final MediaTypeCodecRegistry codecRegistry;
    private NettyWebSocketSession clientSession;
    private FullHttpResponse handshakeResponse;
    private Argument<?> clientBodyArgument;
    private Argument<?> clientPongArgument;

    public NettyWebSocketClientHandler(MutableHttpRequest<?> request, WebSocketBean<T> webSocketBean, WebSocketClientHandshaker handshaker, RequestBinderRegistry requestBinderRegistry, MediaTypeCodecRegistry mediaTypeCodecRegistry, ConversionService conversionService) {
        super(null, requestBinderRegistry, mediaTypeCodecRegistry, webSocketBean, request, Collections.emptyMap(), handshaker.version(), handshaker.actualSubprotocol(), null, conversionService);
        this.codecRegistry = mediaTypeCodecRegistry;
        this.handshaker = handshaker;
        this.genericWebSocketBean = webSocketBean;
        String clientPath = webSocketBean.getBeanDefinition().stringValue(ClientWebSocket.class).orElse("");
        UriMatchTemplate matchTemplate = UriMatchTemplate.of((String)clientPath);
        this.matchInfo = matchTemplate.tryMatch(request.getPath());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
            if (idleStateEvent.state() == IdleState.ALL_IDLE && this.clientSession != null && this.clientSession.isOpen()) {
                this.clientSession.close(CloseReason.NORMAL);
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public Argument<?> getBodyArgument() {
        return this.clientBodyArgument;
    }

    public Argument<?> getPongArgument() {
        return this.clientPongArgument;
    }

    public NettyWebSocketSession getSession() {
        return this.clientSession;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel()).addListener(future -> {
            if (future.isSuccess()) {
                ctx.channel().config().setAutoRead(true);
                ctx.read();
            } else {
                this.completion.tryEmitError(future.cause());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            DefaultExecutableBinder binder;
            BoundExecutable bound;
            List unboundArguments;
            FullHttpResponse res;
            this.handshakeResponse = res = (FullHttpResponse)msg;
            try {
                this.handshaker.finishHandshake(ch, res);
            }
            catch (Exception e) {
                try {
                    this.completion.tryEmitError((Throwable)new WebSocketClientException("Error finishing WebSocket handshake: " + e.getMessage(), (Throwable)e));
                }
                finally {
                    ch.writeAndFlush((Object)new CloseWebSocketFrame(CloseReason.INTERNAL_ERROR.getCode(), CloseReason.INTERNAL_ERROR.getReason()));
                    ch.close();
                }
                return;
            }
            this.clientSession = this.createWebSocketSession(ctx);
            Object targetBean = this.genericWebSocketBean.getTarget();
            if (targetBean instanceof WebSocketSessionAware) {
                ((WebSocketSessionAware)targetBean).setWebSocketSession((WebSocketSession)this.clientSession);
            }
            if ((unboundArguments = (bound = (binder = new DefaultExecutableBinder()).tryBind((Executable)this.messageHandler.getExecutableMethod(), this.webSocketBinder, (Object)new WebSocketState((WebSocketSession)this.clientSession, this.originatingRequest))).getUnboundArguments()).size() != 1) {
                this.clientBodyArgument = null;
                try {
                    this.completion.tryEmitError((Throwable)new WebSocketClientException("WebSocket @OnMessage method " + targetBean.getClass().getSimpleName() + "." + this.messageHandler.getExecutableMethod() + " should define exactly 1 message parameter, but found 2 possible candidates: " + unboundArguments));
                }
                finally {
                    if (this.getSession().isOpen()) {
                        this.getSession().close(CloseReason.INTERNAL_ERROR);
                    }
                }
                return;
            }
            this.clientBodyArgument = (Argument)unboundArguments.iterator().next();
            if (this.pongHandler != null) {
                BoundExecutable boundPong = binder.tryBind((Executable)this.pongHandler.getExecutableMethod(), this.webSocketBinder, (Object)new WebSocketState((WebSocketSession)this.clientSession, this.originatingRequest));
                List unboundPongArguments = boundPong.getUnboundArguments();
                if (unboundPongArguments.size() == 1 && ((Argument)unboundPongArguments.get(0)).isAssignableFrom(WebSocketPongMessage.class)) {
                    this.clientPongArgument = (Argument)unboundPongArguments.get(0);
                } else {
                    this.clientPongArgument = null;
                    try {
                        this.completion.tryEmitError((Throwable)new WebSocketClientException("WebSocket @OnMessage pong handler method " + targetBean.getClass().getSimpleName() + "." + this.messageHandler.getExecutableMethod() + " should define exactly 1 pong message parameter, but found: " + unboundArguments));
                    }
                    finally {
                        if (this.getSession().isOpen()) {
                            this.getSession().close(CloseReason.INTERNAL_ERROR);
                        }
                    }
                    return;
                }
            }
            Flux.from((Publisher)this.callOpenMethod(ctx)).subscribe(o -> {}, error -> this.completion.tryEmitError((Throwable)new WebSocketSessionException("Error opening WebSocket client session: " + error.getMessage(), error)), () -> this.completion.tryEmitValue(targetBean));
            return;
        }
        if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    protected NettyWebSocketSession createWebSocketSession(ChannelHandlerContext ctx) {
        if (ctx != null) {
            return new NettyWebSocketSession(this.handshakeResponse.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT), ctx.channel(), this.originatingRequest, this.codecRegistry, this.handshaker.version().toHttpHeaderValue(), ctx.pipeline().get(SslHandler.class) != null){

                public ConvertibleValues<Object> getUriVariables() {
                    if (NettyWebSocketClientHandler.this.matchInfo != null) {
                        return ConvertibleValues.of((Map)NettyWebSocketClientHandler.this.matchInfo.getVariableValues(), (ConversionService)NettyWebSocketClientHandler.this.conversionService);
                    }
                    return ConvertibleValues.empty();
                }
            };
        }
        return null;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.completion.tryEmitError(cause);
        super.exceptionCaught(ctx, cause);
    }

    public final Mono<T> getHandshakeCompletedMono() {
        return this.completion.asMono();
    }

    protected void handleCloseReason(ChannelHandlerContext ctx, CloseReason cr, boolean writeCloseReason) {
        if (!this.handshaker.isHandshakeComplete()) {
            this.completion.tryEmitError((Throwable)new WebSocketClientException("Error opening WebSocket client session: " + cr.getReason()));
            return;
        }
        super.handleCloseReason(ctx, cr, writeCloseReason);
    }
}

