/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.netty.channel.EventLoop;

@Internal
record BlockHint(Thread blockedThread, @Nullable BlockHint next) {
    public static BlockHint willBlockThisThread() {
        return new BlockHint(Thread.currentThread(), null);
    }

    @Nullable
    public static BlockHint combine(@Nullable BlockHint a, @Nullable BlockHint b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.next == null) {
            return new BlockHint(a.blockedThread, b);
        }
        if (b.next == null) {
            return new BlockHint(b.blockedThread, a);
        }
        throw new UnsupportedOperationException("would need to build a new linked list here, but we never need this");
    }

    void checkIsNotBlocked(EventLoop eventLoop) {
        if (this.blocks(eventLoop)) {
            throw BlockHint.createException();
        }
    }

    @NonNull
    static HttpClientException createException() {
        return new HttpClientException("Failed to perform blocking request on the event loop because request execution would be dispatched on the same event loop. This would lead to a deadlock. Either configure the HTTP client to use a different event loop, or use the reactive HTTP client. https://docs.micronaut.io/latest/guide/index.html#clientConfiguration");
    }

    boolean blocks(EventLoop eventLoop) {
        BlockHint bh = this;
        while (bh != null) {
            if (eventLoop.inEventLoop(bh.blockedThread)) {
                return true;
            }
            bh = bh.next;
        }
        return false;
    }
}

