/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.exceptions.HttpClientExceptionUtils;
import io.micronaut.http.client.netty.BlockHint;
import io.micronaut.http.client.netty.CancellableMonoSink;
import io.micronaut.http.client.netty.DefaultHttpClient;
import io.micronaut.http.client.netty.Http2PingSender;
import io.micronaut.http.client.netty.InitialConnectionErrorHandler;
import io.micronaut.http.client.netty.NettyClientCustomizer;
import io.micronaut.http.client.netty.PoolResizer;
import io.micronaut.http.client.netty.PoolSink;
import io.micronaut.http.client.netty.ssl.ClientSslBuilder;
import io.micronaut.http.netty.channel.NettyThreadFactory;
import io.micronaut.websocket.exceptions.WebSocketSessionException;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2MultiplexActiveStreamsException;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.incubator.codec.http3.Http3;
import io.netty.incubator.codec.http3.Http3ClientConnectionHandler;
import io.netty.incubator.codec.http3.Http3FrameToHttpObjectCodec;
import io.netty.incubator.codec.http3.Http3HeadersFrame;
import io.netty.incubator.codec.http3.Http3RequestStreamInitializer;
import io.netty.incubator.codec.http3.Http3SettingsFrame;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicClientCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.DefaultNameResolver;
import io.netty.resolver.InetSocketAddressResolver;
import io.netty.resolver.NameResolver;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.resolver.RoundRobinInetAddressResolver;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

@Internal
public class ConnectionManager {
    private final HttpVersionSelection httpVersion;
    private final Logger log;
    private final Map<DefaultHttpClient.RequestKey, Pool> pools = new ConcurrentHashMap<DefaultHttpClient.RequestKey, Pool>();
    private final ClientSslBuilder nettyClientSslBuilder;
    private EventLoopGroup group;
    private final boolean shutdownGroup;
    private final AddressResolverGroup<?> resolverGroup;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ThreadFactory threadFactory;
    private final ChannelFactory<? extends Channel> socketChannelFactory;
    private final ChannelFactory<? extends Channel> udpChannelFactory;
    private Bootstrap bootstrap;
    private Bootstrap udpBootstrap;
    private final HttpClientConfiguration configuration;
    private volatile SslContext sslContext;
    private volatile Object http3SslContext;
    private volatile SslContext websocketSslContext;
    private final NettyClientCustomizer clientCustomizer;
    private final String informationalServiceId;

    ConnectionManager(ConnectionManager from) {
        this.httpVersion = from.httpVersion;
        this.log = from.log;
        this.group = from.group;
        this.shutdownGroup = from.shutdownGroup;
        this.resolverGroup = from.resolverGroup;
        this.threadFactory = from.threadFactory;
        this.socketChannelFactory = from.socketChannelFactory;
        this.udpChannelFactory = from.udpChannelFactory;
        this.bootstrap = from.bootstrap;
        this.udpBootstrap = from.udpBootstrap;
        this.configuration = from.configuration;
        this.sslContext = from.sslContext;
        this.http3SslContext = from.http3SslContext;
        this.websocketSslContext = from.websocketSslContext;
        this.clientCustomizer = from.clientCustomizer;
        this.informationalServiceId = from.informationalServiceId;
        this.nettyClientSslBuilder = from.nettyClientSslBuilder;
    }

    ConnectionManager(Logger log, @Nullable EventLoopGroup eventLoopGroup, @Nullable ThreadFactory threadFactory, HttpClientConfiguration configuration, @Nullable HttpVersionSelection httpVersion, ChannelFactory<? extends Channel> socketChannelFactory, ChannelFactory<? extends Channel> udpChannelFactory, ClientSslBuilder nettyClientSslBuilder, NettyClientCustomizer clientCustomizer, String informationalServiceId, @Nullable AddressResolverGroup<?> resolverGroup) {
        if (httpVersion == null) {
            httpVersion = HttpVersionSelection.forClientConfiguration((HttpClientConfiguration)configuration);
        }
        this.log = log;
        this.httpVersion = httpVersion;
        this.threadFactory = threadFactory;
        this.socketChannelFactory = socketChannelFactory;
        this.udpChannelFactory = udpChannelFactory;
        this.configuration = configuration;
        this.clientCustomizer = clientCustomizer;
        this.informationalServiceId = informationalServiceId;
        this.nettyClientSslBuilder = nettyClientSslBuilder;
        if (eventLoopGroup != null) {
            this.group = eventLoopGroup;
            this.shutdownGroup = false;
        } else {
            this.group = ConnectionManager.createEventLoopGroup(configuration, threadFactory);
            this.shutdownGroup = true;
        }
        this.resolverGroup = resolverGroup == null ? ConnectionManager.getResolver(configuration.getDnsResolutionMode()) : resolverGroup;
        this.refresh();
    }

    final void refresh() {
        SslContext oldSslContext = this.sslContext;
        SslContext oldWebsocketSslContext = this.websocketSslContext;
        this.websocketSslContext = null;
        this.sslContext = this.configuration.getSslConfiguration().isEnabled() ? this.nettyClientSslBuilder.build(this.configuration.getSslConfiguration(), this.httpVersion) : null;
        this.http3SslContext = this.httpVersion.isHttp3() ? this.nettyClientSslBuilder.buildHttp3(this.configuration.getSslConfiguration()) : null;
        this.initBootstrap();
        this.running.set(true);
        for (Pool pool : this.pools.values()) {
            pool.forEachConnection(c -> ((Pool.ConnectionHolder)c).windDownConnection());
        }
        ReferenceCountUtil.release((Object)oldSslContext);
        ReferenceCountUtil.release((Object)oldWebsocketSslContext);
    }

    private static NioEventLoopGroup createEventLoopGroup(HttpClientConfiguration configuration, ThreadFactory threadFactory) {
        OptionalInt numOfThreads = configuration.getNumOfThreads();
        Optional threadFactoryType = configuration.getThreadFactory();
        boolean hasThreads = numOfThreads.isPresent();
        boolean hasFactory = threadFactoryType.isPresent();
        NioEventLoopGroup group = hasThreads && hasFactory ? new NioEventLoopGroup(numOfThreads.getAsInt(), (ThreadFactory)InstantiationUtils.instantiate((Class)((Class)threadFactoryType.get()))) : (hasThreads ? (threadFactory != null ? new NioEventLoopGroup(numOfThreads.getAsInt(), threadFactory) : new NioEventLoopGroup(numOfThreads.getAsInt())) : (threadFactory != null ? new NioEventLoopGroup(NettyThreadFactory.getDefaultEventLoopThreads(), threadFactory) : new NioEventLoopGroup()));
        return group;
    }

    public final ByteBufAllocator alloc() {
        return this.bootstrap.config().options().getOrDefault(ChannelOption.ALLOCATOR, ByteBufAllocator.DEFAULT);
    }

    @NonNull
    final List<Channel> getChannels() {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (Pool pool : this.pools.values()) {
            pool.forEachConnection(c -> channels.add(((Pool.ConnectionHolder)c).channel));
        }
        return channels;
    }

    final int liveRequestCount() {
        AtomicInteger count = new AtomicInteger();
        for (Pool pool : this.pools.values()) {
            pool.forEachConnection(c -> {
                if (c instanceof Pool.Http1ConnectionHolder) {
                    Pool.Http1ConnectionHolder holder = (Pool.Http1ConnectionHolder)c;
                    if (holder.hasLiveRequests()) {
                        count.incrementAndGet();
                    }
                } else {
                    count.addAndGet(((Pool.Http2ConnectionHolder)c).liveRequests.get());
                }
            });
        }
        return count.get();
    }

    public final void start() {
        if (this.running.compareAndSet(false, true) && this.shutdownGroup) {
            this.group = ConnectionManager.createEventLoopGroup(this.configuration, this.threadFactory);
            this.initBootstrap();
        }
    }

    private void initBootstrap() {
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channelFactory(this.socketChannelFactory)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        if (this.httpVersion.isHttp3()) {
            this.udpBootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channelFactory(this.udpChannelFactory);
        }
        Optional connectTimeout = this.configuration.getConnectTimeout();
        connectTimeout.ifPresent(duration -> this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)duration.toMillis())));
        for (Map.Entry entry : this.configuration.getChannelOptions().entrySet()) {
            Object v = entry.getValue();
            if (v == null) continue;
            String channelOption = (String)entry.getKey();
            this.bootstrap.option(ChannelOption.valueOf((String)NameUtils.underscoreSeparate((String)channelOption).toUpperCase(Locale.ENGLISH)), v);
        }
        this.bootstrap.resolver(this.resolverGroup);
    }

    @NonNull
    static AddressResolverGroup<? extends SocketAddress> getResolver(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull HttpClientConfiguration.DnsResolutionMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case HttpClientConfiguration.DnsResolutionMode.DEFAULT -> DefaultAddressResolverGroup.INSTANCE;
            case HttpClientConfiguration.DnsResolutionMode.NOOP -> NoopAddressResolverGroup.INSTANCE;
            case HttpClientConfiguration.DnsResolutionMode.ROUND_ROBIN -> new AddressResolverGroup<InetSocketAddress>(){

                protected AddressResolver<InetSocketAddress> newResolver(EventExecutor executor) {
                    return new InetSocketAddressResolver(executor, (NameResolver)new RoundRobinInetAddressResolver(executor, (NameResolver)new DefaultNameResolver(executor)));
                }
            };
        };
    }

    public final void shutdown() {
        if (this.running.compareAndSet(true, false)) {
            for (Pool pool : this.pools.values()) {
                pool.shutdown();
            }
            if (this.shutdownGroup) {
                Duration shutdownTimeout = this.configuration.getShutdownTimeout().orElse(Duration.ofMillis(100L));
                Duration shutdownQuietPeriod = this.configuration.getShutdownQuietPeriod().orElse(Duration.ofMillis(1L));
                Future future = this.group.shutdownGracefully(shutdownQuietPeriod.toMillis(), shutdownTimeout.toMillis(), TimeUnit.MILLISECONDS);
                try {
                    future.await(shutdownTimeout.toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            ReferenceCountUtil.release((Object)this.sslContext);
            ReferenceCountUtil.release((Object)this.websocketSslContext);
            this.resolverGroup.close();
            this.sslContext = null;
            this.websocketSslContext = null;
        }
    }

    public final boolean isRunning() {
        return this.running.get() && !this.group.isShutdown();
    }

    ChannelFuture doConnect(DefaultHttpClient.RequestKey requestKey, ChannelInitializer<?> channelInitializer) {
        String host = requestKey.getHost();
        int port = requestKey.getPort();
        Bootstrap localBootstrap = this.bootstrap.clone();
        Proxy proxy = this.configuration.resolveProxy(requestKey.isSecure(), host, port);
        if (proxy.type() != Proxy.Type.DIRECT) {
            localBootstrap.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
        }
        localBootstrap.handler(channelInitializer);
        return localBootstrap.connect(host, port);
    }

    @Nullable
    private SslContext buildSslContext(DefaultHttpClient.RequestKey requestKey) {
        SslContext sslCtx;
        if (requestKey.isSecure()) {
            sslCtx = this.sslContext;
            if (sslCtx == null && !this.configuration.getProxyAddress().isPresent()) {
                throw this.decorate(new HttpClientException("Cannot send HTTPS request. SSL is disabled"));
            }
        } else {
            sslCtx = null;
        }
        return sslCtx;
    }

    public final Mono<PoolHandle> connect(DefaultHttpClient.RequestKey requestKey, @Nullable BlockHint blockHint) {
        return this.pools.computeIfAbsent(requestKey, x$0 -> new Pool((DefaultHttpClient.RequestKey)x$0)).acquire(blockHint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private SslContext buildWebsocketSslContext(DefaultHttpClient.RequestKey requestKey) {
        SslContext sslCtx = this.websocketSslContext;
        if (requestKey.isSecure()) {
            if (this.configuration.getSslConfiguration().isEnabled()) {
                if (sslCtx == null) {
                    ConnectionManager connectionManager = this;
                    synchronized (connectionManager) {
                        sslCtx = this.websocketSslContext;
                        if (sslCtx == null) {
                            this.websocketSslContext = sslCtx = this.nettyClientSslBuilder.build(this.configuration.getSslConfiguration(), HttpVersionSelection.forWebsocket());
                        }
                    }
                }
            } else if (this.configuration.getProxyAddress().isEmpty()) {
                throw this.decorate(new HttpClientException("Cannot send WSS request. SSL is disabled"));
            }
        }
        return sslCtx;
    }

    final Mono<?> connectForWebsocket(final DefaultHttpClient.RequestKey requestKey, final ChannelHandler handler) {
        final CancellableMonoSink initial = new CancellableMonoSink(null);
        ChannelFuture connectFuture = this.doConnect(requestKey, new ChannelInitializer<Channel>(){

            protected void initChannel(@NonNull Channel ch) {
                Duration duration;
                ConnectionManager.this.addLogHandler(ch);
                SslContext sslContext = ConnectionManager.this.buildWebsocketSslContext(requestKey);
                if (sslContext != null) {
                    ch.pipeline().addLast(new ChannelHandler[]{ConnectionManager.this.configureSslHandler(sslContext.newHandler(ch.alloc(), requestKey.getHost(), requestKey.getPort()))});
                }
                ch.pipeline().addLast("http-client-codec", (ChannelHandler)new HttpClientCodec()).addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(ConnectionManager.this.configuration.getMaxContentLength()));
                Optional readIdleTime = ConnectionManager.this.configuration.getReadIdleTimeout();
                if (readIdleTime.isPresent() && !(duration = (Duration)readIdleTime.get()).isNegative()) {
                    ch.pipeline().addLast("idle-state", (ChannelHandler)new IdleStateHandler(duration.toMillis(), duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS));
                }
                try {
                    if (ConnectionManager.this.configuration.getWebSocketCompressionConfiguration() != null && ConnectionManager.this.configuration.getWebSocketCompressionConfiguration().isEnabled()) {
                        ch.pipeline().addLast(new ChannelHandler[]{WebSocketClientCompressionHandler.INSTANCE});
                    }
                    ch.pipeline().addLast("micronaut-websocket-client", handler);
                    ConnectionManager.this.clientCustomizer.specializeForChannel(ch, NettyClientCustomizer.ChannelRole.CONNECTION).onInitialPipelineBuilt();
                    if (initial.tryEmitEmpty().isSuccess()) {
                        return;
                    }
                }
                catch (Throwable e) {
                    initial.tryEmitError((Throwable)new WebSocketSessionException("Error opening WebSocket client session: " + e.getMessage(), e));
                }
                ch.close();
            }
        });
        this.withPropagation((Future)connectFuture, (GenericFutureListener)future -> {
            if (!future.isSuccess()) {
                initial.tryEmitError(future.cause());
            }
        });
        return initial.asMono();
    }

    private void configureProxy(ChannelPipeline pipeline, boolean secure, String host, int port) {
        InetSocketAddress isa;
        Proxy proxy = this.configuration.resolveProxy(secure, host, port);
        if (Proxy.NO_PROXY.equals(proxy)) {
            return;
        }
        Proxy.Type proxyType = proxy.type();
        SocketAddress proxyAddress = proxy.address();
        String username = this.configuration.getProxyUsername().orElse(null);
        String password = this.configuration.getProxyPassword().orElse(null);
        if (proxyAddress instanceof InetSocketAddress && (isa = (InetSocketAddress)proxyAddress).isUnresolved()) {
            proxyAddress = new InetSocketAddress(isa.getHostString(), isa.getPort());
        }
        if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
            switch (proxyType) {
                case HTTP: {
                    pipeline.addLast("http-proxy", (ChannelHandler)new HttpProxyHandler(proxyAddress, username, password));
                    break;
                }
                case SOCKS: {
                    pipeline.addLast("socks5-proxy", (ChannelHandler)new Socks5ProxyHandler(proxyAddress, username, password));
                    break;
                }
            }
        } else {
            switch (proxyType) {
                case HTTP: {
                    pipeline.addLast("http-proxy", (ChannelHandler)new HttpProxyHandler(proxyAddress));
                    break;
                }
                case SOCKS: {
                    pipeline.addLast("socks5-proxy", (ChannelHandler)new Socks5ProxyHandler(proxyAddress));
                    break;
                }
            }
        }
    }

    final <V, C extends Future<V>> void withPropagation(Future<? extends V> channelFuture, GenericFutureListener<C> listener) {
        PropagatedContext propagatedContext = PropagatedContext.getOrEmpty();
        channelFuture.addListener(f -> {
            try (PropagatedContext.Scope ignored = propagatedContext.propagate();){
                listener.operationComplete(f);
            }
        });
    }

    private Http2FrameCodec makeFrameCodec() {
        Http2FrameCodecBuilder builder = Http2FrameCodecBuilder.forClient();
        this.configuration.getLogLevel().ifPresent(logLevel -> {
            try {
                LogLevel nettyLevel = LogLevel.valueOf((String)logLevel.name());
                builder.frameLogger(new Http2FrameLogger(nettyLevel, DefaultHttpClient.class));
            }
            catch (IllegalArgumentException e) {
                throw this.decorate(new HttpClientException("Unsupported log level: " + logLevel));
            }
        });
        return builder.build();
    }

    private SslHandler configureSslHandler(SslHandler sslHandler) {
        sslHandler.setHandshakeTimeoutMillis(this.configuration.getSslConfiguration().getHandshakeTimeout().toMillis());
        SSLEngine engine = sslHandler.engine();
        SSLParameters params = engine.getSSLParameters();
        params.setEndpointIdentificationAlgorithm("HTTPS");
        engine.setSSLParameters(params);
        return sslHandler;
    }

    private void initHttp1(Channel ch) {
        this.addLogHandler(ch);
        ch.pipeline().addLast("http-client-codec", (ChannelHandler)new HttpClientCodec()).addLast("http-decoder", (ChannelHandler)new HttpContentDecompressor());
    }

    private void addLogHandler(Channel ch) {
        this.configuration.getLogLevel().ifPresent(logLevel -> {
            try {
                LogLevel nettyLevel = LogLevel.valueOf((String)logLevel.name());
                ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(DefaultHttpClient.class, nettyLevel)});
            }
            catch (IllegalArgumentException e) {
                throw this.decorate(new HttpClientException("Unsupported log level: " + logLevel));
            }
        });
    }

    private void initHttp2(Pool pool, Channel ch, NettyClientCustomizer connectionCustomizer) {
        Http2MultiplexHandler multiplexHandler = new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Http2StreamChannel>(){

            protected void initChannel(@NonNull Http2StreamChannel ch) throws Exception {
                ConnectionManager.this.log.warn("Server opened HTTP2 stream {}, closing immediately", (Object)ch.stream().id());
                ch.close();
            }
        }, (ChannelHandler)new ChannelInitializer<Http2StreamChannel>(){

            protected void initChannel(@NonNull Http2StreamChannel ch) throws Exception {
                ch.close();
            }
        });
        Pool pool2 = pool;
        Objects.requireNonNull(pool2);
        final Pool.Http2ConnectionHolder connectionHolder = pool2.new Pool.Http2ConnectionHolder(ch, connectionCustomizer);
        ch.pipeline().addLast(new ChannelHandler[]{multiplexHandler});
        ch.pipeline().addLast("http2-settings", (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelRead(@NonNull ChannelHandlerContext ctx, @NonNull Object msg) throws Exception {
                if (msg instanceof Http2SettingsFrame) {
                    ctx.pipeline().remove("http2-settings");
                    ctx.pipeline().remove("initial-error");
                    connectionHolder.init();
                    return;
                }
                ConnectionManager.this.log.warn("Premature frame: {}", msg.getClass());
                super.channelRead(ctx, msg);
            }
        });
        ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                ctx.read();
            }

            public void channelRead(@NonNull ChannelHandlerContext ctx, @NonNull Object msg) throws Exception {
                if (msg instanceof Http2SettingsAckFrame) {
                    return;
                }
                if (msg instanceof Http2GoAwayFrame) {
                    Http2GoAwayFrame goAway = (Http2GoAwayFrame)msg;
                    connectionHolder.windDownConnection();
                    if (ConnectionManager.this.log.isDebugEnabled()) {
                        byte[] debug = new byte[Math.min(64, goAway.content().readableBytes())];
                        goAway.content().readBytes(debug);
                        ConnectionManager.this.log.debug("Server sent GOAWAY frame. errorCode={} base64(content)={}", (Object)goAway.errorCode(), (Object)Base64.getEncoder().encodeToString(debug));
                    }
                    goAway.release();
                    return;
                }
                ConnectionManager.this.log.warn("Unexpected message on HTTP2 connection channel: {}", msg);
                ReferenceCountUtil.release((Object)msg);
                ctx.read();
            }
        }});
    }

    private <E extends HttpClientException> E decorate(E exc) {
        return (E)HttpClientExceptionUtils.populateServiceId(exc, (String)this.informationalServiceId, (HttpClientConfiguration)this.configuration);
    }

    private final class Pool
    extends PoolResizer {
        private final DefaultHttpClient.RequestKey requestKey;
        private final InitialConnectionErrorHandler initialErrorHandler;

        Pool(DefaultHttpClient.RequestKey requestKey) {
            super(ConnectionManager.this.log, ConnectionManager.this.configuration.getConnectionPoolConfiguration());
            this.initialErrorHandler = new InitialConnectionErrorHandler(){

                @Override
                protected void onNewConnectionFailure(@Nullable Throwable cause) throws Exception {
                    Pool.this.onNewConnectionFailure(cause);
                }
            };
            this.requestKey = requestKey;
        }

        Mono<PoolHandle> acquire(@Nullable BlockHint blockHint) {
            CancellableMonoSink<PoolHandle> sink = new CancellableMonoSink<PoolHandle>(blockHint);
            this.addPendingRequest(sink);
            Optional acquireTimeout = ConnectionManager.this.configuration.getConnectionPoolConfiguration().getAcquireTimeout();
            if (acquireTimeout.isPresent()) {
                return sink.asMono().timeout((Duration)acquireTimeout.get(), Schedulers.fromExecutor((Executor)ConnectionManager.this.group));
            }
            return sink.asMono();
        }

        @Override
        void onNewConnectionFailure(@Nullable Throwable error) throws Exception {
            HttpClientException wrapped;
            super.onNewConnectionFailure(error);
            Sinks.One<PoolHandle> pending = this.pollPendingRequest();
            if (pending != null && pending.tryEmitError((Throwable)ConnectionManager.this.decorate(wrapped = error == null ? new HttpClientException("Unknown connect error") : new HttpClientException("Connect Error: " + error.getMessage(), error))) == Sinks.EmitResult.OK) {
                return;
            }
            ConnectionManager.this.log.error("Failed to connect to remote", error);
        }

        @Override
        void openNewConnection(@Nullable BlockHint blockHint) throws Exception {
            ChannelFuture channelFuture = this.openConnectionFuture();
            if (blockHint != null && blockHint.blocks(channelFuture.channel().eventLoop())) {
                channelFuture.channel().close();
                this.onNewConnectionFailure((Throwable)BlockHint.createException());
                return;
            }
            ConnectionManager.this.withPropagation(channelFuture, future -> {
                if (!future.isSuccess()) {
                    this.onNewConnectionFailure(future.cause());
                }
            });
        }

        private ChannelFuture openConnectionFuture() {
            ChannelInitializer initializer;
            if (this.requestKey.isSecure()) {
                if (ConnectionManager.this.httpVersion.isHttp3()) {
                    return ((Bootstrap)ConnectionManager.this.udpBootstrap.clone().handler((ChannelHandler)new Http3ChannelInitializer(this, this.requestKey.getHost(), this.requestKey.getPort()))).bind(0);
                }
                initializer = new AdaptiveAlpnChannelInitializer(this, ConnectionManager.this.buildSslContext(this.requestKey), this.requestKey.getHost(), this.requestKey.getPort());
            } else {
                initializer = switch (ConnectionManager.this.httpVersion.getPlaintextMode()) {
                    default -> throw new IncompatibleClassChangeError();
                    case HttpVersionSelection.PlaintextMode.HTTP_1 -> new ChannelInitializer<Channel>(){

                        protected void initChannel(final @NonNull Channel ch) throws Exception {
                            ConnectionManager.this.configureProxy(ch.pipeline(), false, Pool.this.requestKey.getHost(), Pool.this.requestKey.getPort());
                            ConnectionManager.this.initHttp1(ch);
                            ch.pipeline().addLast("activity-listener", (ChannelHandler)new ChannelInboundHandlerAdapter(){

                                public void channelActive(@NonNull ChannelHandlerContext ctx) throws Exception {
                                    super.channelActive(ctx);
                                    ctx.pipeline().remove((ChannelHandler)this);
                                    NettyClientCustomizer channelCustomizer = ConnectionManager.this.clientCustomizer.specializeForChannel(ch, NettyClientCustomizer.ChannelRole.CONNECTION);
                                    new Http1ConnectionHolder(ch, channelCustomizer).init(true);
                                }
                            });
                        }
                    };
                    case HttpVersionSelection.PlaintextMode.H2C -> new Http2UpgradeInitializer(this);
                };
            }
            return ConnectionManager.this.doConnect(this.requestKey, initializer);
        }

        public void shutdown() {
            this.forEachConnection(c -> ((ConnectionHolder)c).channel.close());
        }

        abstract class ConnectionHolder
        extends PoolResizer.ResizerConnection {
            final Channel channel;
            final NettyClientCustomizer connectionCustomizer;
            @Nullable
            ScheduledFuture<?> ttlFuture;
            volatile boolean windDownConnection = false;
            private ReadTimeoutHandler readTimeoutHandler;

            ConnectionHolder(Channel channel, NettyClientCustomizer connectionCustomizer) {
                this.channel = channel;
                this.connectionCustomizer = connectionCustomizer;
            }

            private void resetReadTimeout() {
                if (this.readTimeoutHandler != null) {
                    this.readTimeoutHandler.resetReadTimeout();
                }
            }

            final void addTimeoutHandlers(String before) {
                ConnectionManager.this.configuration.getReadTimeout().ifPresent(dur -> {
                    ReadTimeoutHandler readTimeoutHandler;
                    this.readTimeoutHandler = readTimeoutHandler = new ReadTimeoutHandler(dur.toNanos(), TimeUnit.NANOSECONDS){

                        protected void readTimedOut(ChannelHandlerContext ctx) {
                            if (ConnectionHolder.this.hasLiveRequests()) {
                                ConnectionHolder.this.windDownConnection = true;
                                ConnectionHolder.this.fireReadTimeout(ctx);
                                ctx.close();
                            }
                        }
                    };
                    this.channel.pipeline().addBefore(before, "read-timeout", (ChannelHandler)readTimeoutHandler);
                });
                ConnectionManager.this.configuration.getConnectionPoolIdleTimeout().ifPresent(dur -> this.channel.pipeline().addBefore(before, "idle-state", (ChannelHandler)new ReadTimeoutHandler(dur.toNanos(), TimeUnit.NANOSECONDS){

                    protected void readTimedOut(ChannelHandlerContext ctx) {
                        if (!ConnectionHolder.this.hasLiveRequests()) {
                            ConnectionHolder.this.windDownConnection = true;
                            ctx.close();
                        }
                    }
                }));
                ConnectionManager.this.configuration.getConnectTtl().ifPresent(ttl -> {
                    this.ttlFuture = this.channel.eventLoop().schedule(this::windDownConnection, ttl.toNanos(), TimeUnit.NANOSECONDS);
                });
                this.channel.pipeline().addBefore(before, "connection-cleaner", (ChannelHandler)new ChannelInboundHandlerAdapter(){
                    boolean inactiveCalled = false;

                    public void channelInactive(@NonNull ChannelHandlerContext ctx) throws Exception {
                        super.channelInactive(ctx);
                        if (!this.inactiveCalled) {
                            this.inactiveCalled = true;
                            ConnectionHolder.this.onInactive();
                        }
                    }

                    public void handlerRemoved(ChannelHandlerContext ctx) {
                        if (!this.inactiveCalled) {
                            this.inactiveCalled = true;
                            ConnectionHolder.this.onInactive();
                        }
                    }
                });
            }

            void windDownConnection() {
                this.windDownConnection = true;
            }

            final void emitPoolHandle(Sinks.One<PoolHandle> sink, PoolHandle ph) {
                Sinks.EmitResult emitResult = sink.tryEmitValue((Object)ph);
                if (emitResult.isFailure()) {
                    ph.release();
                } else if (!ConnectionManager.this.configuration.getConnectionPoolConfiguration().isEnabled()) {
                    this.windDownConnection();
                }
            }

            @Override
            public boolean dispatch(PoolSink<PoolHandle> sink) {
                if (!this.tryEarmarkForRequest()) {
                    return false;
                }
                BlockHint blockHint = sink.getBlockHint();
                if (blockHint != null && blockHint.blocks(this.channel.eventLoop())) {
                    sink.tryEmitError((Throwable)BlockHint.createException());
                    return true;
                }
                if (this.channel.eventLoop().inEventLoop()) {
                    this.resetReadTimeout();
                    this.dispatch0(sink);
                } else {
                    this.channel.eventLoop().execute(() -> {
                        this.resetReadTimeout();
                        this.dispatch0(sink);
                    });
                }
                return true;
            }

            abstract void dispatch0(PoolSink<PoolHandle> var1);

            abstract boolean tryEarmarkForRequest();

            abstract boolean hasLiveRequests();

            abstract void fireReadTimeout(ChannelHandlerContext var1);

            void onInactive() {
                if (this.ttlFuture != null) {
                    this.ttlFuture.cancel(false);
                }
                this.windDownConnection = true;
            }
        }

        final class Http3ConnectionHolder
        extends Http2ConnectionHolder {
            private final Channel udpChannel;
            private final QuicChannel quicChannel;

            Http3ConnectionHolder(Channel channel, QuicChannel quicChannel, NettyClientCustomizer customizer) {
                super((Channel)quicChannel, customizer);
                this.udpChannel = channel;
                this.quicChannel = quicChannel;
            }

            @Override
            void adaptHeaders(Object msg) {
                if (msg instanceof Http3HeadersFrame) {
                    Http3HeadersFrame hf = (Http3HeadersFrame)msg;
                    if (Pool.this.requestKey.isSecure()) {
                        hf.headers().scheme((CharSequence)HttpScheme.HTTPS.name());
                    } else {
                        hf.headers().scheme((CharSequence)HttpScheme.HTTP.name());
                    }
                }
            }

            @Override
            void addTimeoutHandlers() {
                this.addTimeoutHandlers("http2-connection");
            }

            @Override
            ChannelHandler createFrameToHttpObjectCodec() {
                return new Http3FrameToHttpObjectCodec(false);
            }

            @Override
            Future<? extends Channel> openStreamChannel() {
                return Http3.newRequestStream((QuicChannel)this.quicChannel, (ChannelHandler)new Http3RequestStreamInitializer(){

                    protected void initRequestStream(QuicStreamChannel ch) {
                    }
                });
            }

            @Override
            void onInactive() {
                super.onInactive();
                this.udpChannel.close();
            }
        }

        class Http2ConnectionHolder
        extends ConnectionHolder {
            private final AtomicInteger earmarkedOrLiveRequests;
            private final AtomicInteger liveRequests;

            Http2ConnectionHolder(Channel channel, NettyClientCustomizer customizer) {
                super(channel, customizer);
                this.earmarkedOrLiveRequests = new AtomicInteger(0);
                this.liveRequests = new AtomicInteger(0);
            }

            void init() {
                this.addTimeoutHandlers();
                this.connectionCustomizer.onStreamPipelineBuilt();
                Pool.this.onNewConnectionEstablished2(this);
            }

            void addTimeoutHandlers() {
                this.addTimeoutHandlers(Pool.this.requestKey.isSecure() ? "ssl" : "http2-connection");
                HttpClientConfiguration.Http2ClientConfiguration http2Configuration = ConnectionManager.this.configuration.getHttp2Configuration();
                if (http2Configuration != null) {
                    long read = Http2ConnectionHolder.toNanos(http2Configuration.getPingIntervalRead());
                    long write = Http2ConnectionHolder.toNanos(http2Configuration.getPingIntervalWrite());
                    long idle = Http2ConnectionHolder.toNanos(http2Configuration.getPingIntervalIdle());
                    if (read > 0L || write > 0L || idle > 0L) {
                        this.channel.pipeline().addAfter("http2-connection", "http2-ping-sender", (ChannelHandler)new Http2PingSender(read, write, idle, TimeUnit.NANOSECONDS));
                    }
                }
            }

            private static long toNanos(@Nullable Duration timeout) {
                if (timeout == null) {
                    return 0L;
                }
                long nanos = timeout.toNanos();
                return nanos < 0L ? 0L : nanos;
            }

            @Override
            boolean tryEarmarkForRequest() {
                return !this.windDownConnection && PoolResizer.incrementWithLimit(this.earmarkedOrLiveRequests, ConnectionManager.this.configuration.getConnectionPoolConfiguration().getMaxConcurrentRequestsPerHttp2Connection());
            }

            @Override
            boolean hasLiveRequests() {
                return this.liveRequests.get() > 0;
            }

            @Override
            void fireReadTimeout(ChannelHandlerContext ctx) {
                this.channel.pipeline().fireExceptionCaught((Throwable)new Http2MultiplexActiveStreamsException((Throwable)ReadTimeoutException.INSTANCE));
            }

            @Override
            void dispatch0(PoolSink<PoolHandle> sink) {
                if (!this.channel.isActive() || this.windDownConnection) {
                    this.windDownConnection();
                    this.returnPendingRequest(sink);
                    return;
                }
                this.liveRequests.incrementAndGet();
                ConnectionManager.this.withPropagation(this.openStreamChannel(), future -> {
                    if (future.isSuccess()) {
                        final Channel streamChannel = (Channel)future.get();
                        streamChannel.pipeline().addLast(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

                            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                                Http2ConnectionHolder.this.adaptHeaders(msg);
                                super.write(ctx, msg, promise);
                            }
                        }}).addLast(new ChannelHandler[]{this.createFrameToHttpObjectCodec()}).addLast("http-decompressor", (ChannelHandler)new HttpContentDecompressor());
                        final NettyClientCustomizer streamCustomizer = this.connectionCustomizer.specializeForChannel(streamChannel, NettyClientCustomizer.ChannelRole.HTTP2_STREAM);
                        PoolHandle ph = new PoolHandle(true, streamChannel){

                            @Override
                            public void taint() {
                            }

                            @Override
                            public void release() {
                                super.release();
                                streamChannel.close();
                                int newCount = Http2ConnectionHolder.this.liveRequests.decrementAndGet();
                                Http2ConnectionHolder.this.earmarkedOrLiveRequests.decrementAndGet();
                                if (Http2ConnectionHolder.this.windDownConnection && newCount <= 0) {
                                    Http2ConnectionHolder.this.channel.close();
                                } else {
                                    Pool.this.markConnectionAvailable();
                                }
                            }

                            @Override
                            public boolean canReturn() {
                                return true;
                            }

                            @Override
                            public void notifyRequestPipelineBuilt() {
                                streamCustomizer.onRequestPipelineBuilt();
                            }
                        };
                        this.emitPoolHandle(sink, ph);
                    } else {
                        ConnectionManager.this.log.debug("Failed to open http2 stream", future.cause());
                        this.liveRequests.decrementAndGet();
                        this.returnPendingRequest(sink);
                    }
                });
            }

            @NonNull
            ChannelHandler createFrameToHttpObjectCodec() {
                return new Http2StreamFrameToHttpObjectCodec(false);
            }

            Future<? extends Channel> openStreamChannel() {
                return new Http2StreamChannelBootstrap(this.channel).open();
            }

            void adaptHeaders(Object msg) {
                if (msg instanceof Http2HeadersFrame) {
                    Http2HeadersFrame hf = (Http2HeadersFrame)msg;
                    if (Pool.this.requestKey.isSecure()) {
                        hf.headers().scheme((CharSequence)HttpScheme.HTTPS.name());
                    } else {
                        hf.headers().scheme((CharSequence)HttpScheme.HTTP.name());
                    }
                }
            }

            private void returnPendingRequest(PoolSink<PoolHandle> sink) {
                Pool.this.addPendingRequest(sink);
                this.earmarkedOrLiveRequests.decrementAndGet();
            }

            @Override
            void windDownConnection() {
                super.windDownConnection();
                if (this.liveRequests.get() == 0) {
                    this.channel.close();
                }
            }

            @Override
            void onInactive() {
                super.onInactive();
                Pool.this.onConnectionInactive2(this);
            }
        }

        final class Http1ConnectionHolder
        extends ConnectionHolder {
            private final AtomicBoolean earmarkedOrLive;
            private volatile boolean hasLiveRequest;

            Http1ConnectionHolder(Channel channel, NettyClientCustomizer connectionCustomizer) {
                super(channel, connectionCustomizer);
                this.earmarkedOrLive = new AtomicBoolean(false);
                this.hasLiveRequest = false;
            }

            void init(boolean fireInitialPipelineBuilt) {
                this.addTimeoutHandlers(Pool.this.requestKey.isSecure() ? "ssl" : "http-client-codec");
                if (fireInitialPipelineBuilt) {
                    this.connectionCustomizer.onInitialPipelineBuilt();
                }
                this.connectionCustomizer.onStreamPipelineBuilt();
                Pool.this.onNewConnectionEstablished1(this);
            }

            @Override
            boolean tryEarmarkForRequest() {
                return !this.windDownConnection && this.earmarkedOrLive.compareAndSet(false, true);
            }

            @Override
            boolean hasLiveRequests() {
                return this.hasLiveRequest;
            }

            @Override
            void fireReadTimeout(ChannelHandlerContext ctx) {
                ctx.fireExceptionCaught((Throwable)ReadTimeoutException.INSTANCE);
            }

            @Override
            void dispatch0(PoolSink<PoolHandle> sink) {
                if (!this.channel.isActive()) {
                    this.windDownConnection();
                    this.returnPendingRequest(sink);
                    return;
                }
                this.hasLiveRequest = true;
                PoolHandle ph = new PoolHandle(false, this.channel){
                    final ChannelHandlerContext lastContext;
                    {
                        this.lastContext = this.channel.pipeline().lastContext();
                    }

                    @Override
                    public void taint() {
                        Http1ConnectionHolder.this.windDownConnection = true;
                    }

                    @Override
                    public void release() {
                        ChannelHandlerContext newLast;
                        super.release();
                        if (!Http1ConnectionHolder.this.windDownConnection && this.lastContext != (newLast = this.channel.pipeline().lastContext())) {
                            ConnectionManager.this.log.warn("BUG - Handler not removed: {}", (Object)newLast);
                            this.taint();
                        }
                        if (!Http1ConnectionHolder.this.windDownConnection) {
                            Http1ConnectionHolder.this.hasLiveRequest = false;
                            Http1ConnectionHolder.this.earmarkedOrLive.set(false);
                            Pool.this.markConnectionAvailable();
                        } else {
                            this.channel.close();
                        }
                    }

                    @Override
                    public boolean canReturn() {
                        return !Http1ConnectionHolder.this.windDownConnection;
                    }

                    @Override
                    public void notifyRequestPipelineBuilt() {
                        Http1ConnectionHolder.this.connectionCustomizer.onRequestPipelineBuilt();
                    }
                };
                this.emitPoolHandle(sink, ph);
            }

            private void returnPendingRequest(PoolSink<PoolHandle> sink) {
                Pool.this.addPendingRequest(sink);
                this.hasLiveRequest = false;
                this.earmarkedOrLive.set(false);
            }

            @Override
            void windDownConnection() {
                super.windDownConnection();
                if (!this.hasLiveRequest) {
                    this.channel.close();
                }
            }

            @Override
            void onInactive() {
                super.onInactive();
                Pool.this.onConnectionInactive1(this);
            }
        }
    }

    public static abstract class PoolHandle {
        private static final Supplier<ResourceLeakDetector<PoolHandle>> LEAK_DETECTOR = SupplierUtil.memoized(() -> ResourceLeakDetectorFactory.instance().newResourceLeakDetector(PoolHandle.class));
        final boolean http2;
        final Channel channel;
        boolean released = false;
        private final ResourceLeakTracker<PoolHandle> tracker = LEAK_DETECTOR.get().track((Object)this);

        private PoolHandle(boolean http2, Channel channel) {
            this.http2 = http2;
            this.channel = channel;
        }

        public final Channel channel() {
            return this.channel;
        }

        public final boolean http2() {
            return this.http2;
        }

        public abstract void taint();

        public void release() {
            if (this.released) {
                throw new IllegalStateException("Already released");
            }
            this.released = true;
            if (this.tracker != null) {
                this.tracker.close((Object)this);
            }
        }

        public abstract boolean canReturn();

        public abstract void notifyRequestPipelineBuilt();
    }

    private final class Http3ChannelInitializer
    extends ChannelOutboundHandlerAdapter {
        private final Pool pool;
        private final String host;
        private final int port;

        Http3ChannelInitializer(Pool pool, String host, int port) {
            this.pool = pool;
            this.host = host;
            this.port = port;
        }

        public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            ChannelPromise downstreamPromise = ctx.newPromise();
            super.bind(ctx, localAddress, downstreamPromise);
            downstreamPromise.addListener(future -> {
                if (future.isSuccess()) {
                    try {
                        this.initChannel(promise.channel());
                        ctx.pipeline().remove((ChannelHandler)this);
                        promise.setSuccess();
                    }
                    catch (Exception e) {
                        promise.setFailure((Throwable)e);
                    }
                } else {
                    promise.setFailure(future.cause());
                }
            });
        }

        private void initChannel(final Channel ch) {
            final NettyClientCustomizer channelCustomizer = ConnectionManager.this.clientCustomizer.specializeForChannel(ch, NettyClientCustomizer.ChannelRole.CONNECTION);
            ch.pipeline().addLast(new ChannelHandler[]{((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)Http3.newQuicClientCodecBuilder().sslEngineProvider(c -> ((QuicSslContext)ConnectionManager.this.http3SslContext).newEngine(c.alloc(), this.host, this.port))).initialMaxData(10000000L)).initialMaxStreamDataBidirectionalLocal(1000000L)).build()}).addLast("initial-error", (ChannelHandler)this.pool.initialErrorHandler);
            channelCustomizer.onInitialPipelineBuilt();
            QuicChannel.newBootstrap((Channel)ch).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    final QuicChannel quicChannel = (QuicChannel)ctx.channel();
                    ctx.pipeline().addLast("http2-connection", (ChannelHandler)new Http3ClientConnectionHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            if (msg instanceof Http3SettingsFrame) {
                                ch.pipeline().remove("initial-error");
                                Pool pool = Http3ChannelInitializer.this.pool;
                                Objects.requireNonNull(pool);
                                pool.new Pool.Http3ConnectionHolder(ch, quicChannel, channelCustomizer).init();
                            }
                            super.channelRead(ctx, msg);
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                            ch.pipeline().remove("initial-error");
                            ch.close();
                            Http3ChannelInitializer.this.pool.onNewConnectionFailure(cause);
                        }
                    }, null, null, null, false));
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }).remoteAddress((SocketAddress)new InetSocketAddress(this.host, this.port)).localAddress(ch.localAddress()).connect().addListener(future -> {
                if (!future.isSuccess()) {
                    this.pool.onNewConnectionFailure(future.cause());
                }
            });
        }
    }

    private final class Http2UpgradeInitializer
    extends ChannelInitializer<Channel> {
        private final Pool pool;

        Http2UpgradeInitializer(Pool pool) {
            this.pool = pool;
        }

        protected void initChannel(@NonNull Channel ch) throws Exception {
            final NettyClientCustomizer connectionCustomizer = ConnectionManager.this.clientCustomizer.specializeForChannel(ch, NettyClientCustomizer.ChannelRole.CONNECTION);
            final Http2FrameCodec frameCodec = ConnectionManager.this.makeFrameCodec();
            HttpClientCodec sourceCodec = new HttpClientCodec();
            Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec(frameCodec, (ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(@NonNull Channel ch) throws Exception {
                    ch.pipeline().addLast("http2-connection", (ChannelHandler)frameCodec);
                    ConnectionManager.this.initHttp2(Http2UpgradeInitializer.this.pool, ch, connectionCustomizer);
                }
            });
            HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 65536);
            ch.pipeline().addLast("http-client-codec", (ChannelHandler)sourceCodec);
            ch.pipeline().addLast(new ChannelHandler[]{upgradeHandler});
            ch.pipeline().addLast("http2-upgrade-request", (ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelActive(@NonNull ChannelHandlerContext ctx) throws Exception {
                    DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/", Unpooled.EMPTY_BUFFER);
                    upgradeRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)(Http2UpgradeInitializer.this.pool.requestKey.getHost() + ":" + Http2UpgradeInitializer.this.pool.requestKey.getPort()));
                    ctx.writeAndFlush((Object)upgradeRequest);
                    ctx.pipeline().remove("http2-upgrade-request");
                    ctx.read();
                    super.channelActive(ctx);
                }
            });
            ch.pipeline().addLast("initial-error", (ChannelHandler)this.pool.initialErrorHandler);
            connectionCustomizer.onInitialPipelineBuilt();
        }
    }

    private final class AdaptiveAlpnChannelInitializer
    extends ChannelInitializer<Channel> {
        private final Pool pool;
        private final SslContext sslContext;
        private final String host;
        private final int port;

        AdaptiveAlpnChannelInitializer(Pool pool, SslContext sslContext, String host, int port) {
            this.pool = pool;
            this.sslContext = sslContext;
            this.host = host;
            this.port = port;
        }

        protected void initChannel(final @NonNull Channel ch) {
            final NettyClientCustomizer channelCustomizer = ConnectionManager.this.clientCustomizer.specializeForChannel(ch, NettyClientCustomizer.ChannelRole.CONNECTION);
            ConnectionManager.this.configureProxy(ch.pipeline(), true, this.host, this.port);
            ch.pipeline().addLast("ssl", (ChannelHandler)ConnectionManager.this.configureSslHandler(this.sslContext.newHandler(ch.alloc(), this.host, this.port))).addLast("http2-protocol-negotiator", (ChannelHandler)new ApplicationProtocolNegotiationHandler("http/1.1"){

                protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                    if ("h2".equals(protocol)) {
                        ctx.pipeline().addLast("http2-connection", (ChannelHandler)ConnectionManager.this.makeFrameCodec());
                        ConnectionManager.this.initHttp2(AdaptiveAlpnChannelInitializer.this.pool, ctx.channel(), channelCustomizer);
                    } else if ("http/1.1".equals(protocol)) {
                        ConnectionManager.this.initHttp1(ctx.channel());
                        Pool pool = AdaptiveAlpnChannelInitializer.this.pool;
                        Objects.requireNonNull(pool);
                        pool.new Pool.Http1ConnectionHolder(ch, channelCustomizer).init(false);
                        ctx.pipeline().remove("initial-error");
                    } else {
                        ctx.close();
                        throw ConnectionManager.this.decorate(new HttpClientException("Unknown Protocol: " + protocol));
                    }
                }

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    SslHandshakeCompletionEvent event;
                    if (evt instanceof SslHandshakeCompletionEvent && !(event = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                        InitialConnectionErrorHandler.setFailureCause(ctx.channel(), event.cause());
                    }
                    super.userEventTriggered(ctx, evt);
                }

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    if (cause instanceof DecoderException && cause.getCause() instanceof SSLException) {
                        cause = cause.getCause();
                    }
                    ctx.fireExceptionCaught(cause);
                }
            }).addLast("initial-error", (ChannelHandler)this.pool.initialErrorHandler);
            channelCustomizer.onInitialPipelineBuilt();
        }
    }
}

