/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.attr.MutableAttributeHolder;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.util.HttpUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface HttpMessage<B>
extends MutableAttributeHolder {
    @Nonnull
    public HttpHeaders getHeaders();

    @Nonnull
    public MutableConvertibleValues<Object> getAttributes();

    @Nonnull
    public Optional<B> getBody();

    @Nonnull
    default public Charset getCharacterEncoding() {
        return HttpUtil.resolveCharset(this).orElse(StandardCharsets.UTF_8);
    }

    @Nonnull
    default public HttpMessage<B> setAttribute(@Nonnull CharSequence name, Object value) {
        return (HttpMessage)super.setAttribute(name, value);
    }

    @Nonnull
    default public <T> Optional<T> getBody(@Nonnull Argument<T> type) {
        ArgumentUtils.requireNonNull((String)"type", type);
        return this.getBody().flatMap(b -> ConversionService.SHARED.convert(b, ConversionContext.of((Argument)type)));
    }

    @Nonnull
    default public <T> Optional<T> getBody(@Nonnull Class<T> type) {
        ArgumentUtils.requireNonNull((String)"type", type);
        return this.getBody(Argument.of(type));
    }

    @Nonnull
    default public Optional<Locale> getLocale() {
        return this.getHeaders().findFirst("Content-Language").map(Locale::new);
    }

    default public long getContentLength() {
        return this.getHeaders().contentLength().orElse(-1L);
    }

    @Nonnull
    default public Optional<MediaType> getContentType() {
        return this.getHeaders().contentType();
    }
}

