/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.resource;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.env.Environment;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.io.Readable;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.file.DefaultFileSystemResourceLoader;
import io.micronaut.core.io.file.FileSystemResourceLoader;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.io.scan.DefaultClassPathResourceLoader;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Factory
@BootstrapContextCompatible
public class ResourceLoaderFactory {
    private final ClassLoader classLoader;

    @Deprecated
    public ResourceLoaderFactory() {
        this.classLoader = ResourceLoaderFactory.class.getClassLoader();
    }

    @Inject
    public ResourceLoaderFactory(Environment environment) {
        this.classLoader = environment.getClassLoader();
    }

    @Singleton
    @Bean
    @BootstrapContextCompatible
    @Nonnull
    protected ClassPathResourceLoader getClassPathResourceLoader() {
        return new DefaultClassPathResourceLoader(this.classLoader);
    }

    @Singleton
    @BootstrapContextCompatible
    @Nonnull
    protected FileSystemResourceLoader fileSystemResourceLoader() {
        return new DefaultFileSystemResourceLoader();
    }

    @Singleton
    @BootstrapContextCompatible
    @Nonnull
    protected ResourceResolver resourceResolver(@Nonnull List<ResourceLoader> resourceLoaders) {
        return new ResourceResolver(resourceLoaders);
    }

    @Singleton
    @Nonnull
    protected TypeConverter<CharSequence, Readable> readableTypeConverter(ResourceResolver resourceResolver) {
        return (object, targetType, context) -> {
            String pathStr = object.toString();
            Optional supportingLoader = resourceResolver.getSupportingLoader(pathStr);
            if (!supportingLoader.isPresent()) {
                context.reject((Object)pathStr, (Exception)new ConfigurationException("No supported resource loader for path [" + pathStr + "]. Prefix the path with a supported prefix such as 'classpath:' or 'file:'"));
                return Optional.empty();
            }
            Optional resource = resourceResolver.getResource(pathStr);
            if (resource.isPresent()) {
                return Optional.of(Readable.of((URL)((URL)resource.get())));
            }
            context.reject(object, (Exception)new ConfigurationException("No resource exists for value: " + object));
            return Optional.empty();
        };
    }
}

