/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

public enum HttpMethod implements CharSequence
{
    OPTIONS,
    GET,
    HEAD,
    POST,
    PUT,
    DELETE,
    TRACE,
    CONNECT,
    PATCH;


    @Override
    public int length() {
        return this.name().length();
    }

    @Override
    public char charAt(int index) {
        return this.name().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.name().subSequence(start, end);
    }

    public static boolean requiresRequestBody(HttpMethod method) {
        return method != null && (method.equals(POST) || method.equals(PUT) || method.equals(PATCH));
    }

    public static boolean permitsRequestBody(HttpMethod method) {
        return HttpMethod.requiresRequestBody(method) || method.equals(OPTIONS) || method.equals(DELETE);
    }
}

