/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind.binders;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.AbstractAnnotatedArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.http.uri.UriMatchVariable;
import java.util.Collections;
import java.util.Optional;

public class ParameterAnnotationBinder<T>
extends AbstractAnnotatedArgumentBinder<QueryValue, T, HttpRequest<?>>
implements AnnotatedRequestArgumentBinder<QueryValue, T> {
    public ParameterAnnotationBinder(ConversionService<?> conversionService) {
        super(conversionService);
    }

    public Class<QueryValue> getAnnotationType() {
        return QueryValue.class;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        ArgumentBinder.BindingResult result;
        HttpParameters parameters = source.getParameters();
        Argument argument = context.getArgument();
        HttpMethod httpMethod = source.getMethod();
        boolean permitsRequestBody = HttpMethod.permitsRequestBody(httpMethod);
        AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
        boolean hasAnnotation = annotationMetadata.hasAnnotation(QueryValue.class);
        String parameterName = annotationMetadata.getValue(QueryValue.class, String.class).orElse(argument.getName());
        boolean bindAll = source.getAttribute(HttpAttributes.ROUTE_MATCH, UriMatchInfo.class).flatMap(umi -> umi.getVariables().stream().filter(v -> v.getName().equals(parameterName)).findFirst().map(UriMatchVariable::isExploded)).orElse(false);
        if (hasAnnotation || !permitsRequestBody) {
            if (bindAll) {
                Object value;
                if (Iterable.class.isAssignableFrom(argument.getType())) {
                    value = this.doResolve(context, (ConvertibleValues)parameters, parameterName);
                    if (value == null) {
                        value = Collections.emptyList();
                    }
                } else {
                    value = parameters.asMap();
                }
                result = this.doConvert(value, context);
            } else {
                result = this.doBind(context, (ConvertibleValues)parameters, parameterName);
            }
        } else {
            result = ArgumentBinder.BindingResult.EMPTY;
        }
        Optional val = result.getValue();
        if (!val.isPresent() && !hasAnnotation) {
            result = this.doBind((ArgumentConversionContext)context, (ConvertibleValues)source.getAttributes(), parameterName);
        }
        Class argumentType = argument.getType() == Optional.class ? argument.getFirstTypeVariable().orElse(argument).getType() : argument.getType();
        if (!result.getValue().isPresent() && !hasAnnotation && permitsRequestBody) {
            Optional<ConvertibleValues> body = source.getBody(ConvertibleValues.class);
            if (body.isPresent()) {
                result = this.doBind(context, body.get(), parameterName);
                if (!result.getValue().isPresent()) {
                    if (ClassUtils.isJavaLangType((Class)argumentType)) {
                        return Optional::empty;
                    }
                    return () -> source.getBody(argumentType);
                }
            } else {
                Optional<String> text;
                if (source.getBody().isPresent() && (text = source.getBody(String.class)).isPresent()) {
                    return this.doConvert(text.get(), context);
                }
                return ArgumentBinder.BindingResult.UNSATISFIED;
            }
        }
        return result;
    }
}

