/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.http.HttpMessage;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import java.util.Base64;
import java.util.Map;
import java.util.function.Consumer;

public interface MutableHttpMessage<B>
extends HttpMessage<B> {
    @Override
    public MutableHttpHeaders getHeaders();

    public MutableHttpMessage<B> body(B var1);

    default public MutableHttpMessage<B> headers(Consumer<MutableHttpHeaders> headers) {
        headers.accept(this.getHeaders());
        return this;
    }

    default public MutableHttpMessage<B> header(CharSequence name, CharSequence value) {
        this.getHeaders().add(name, value);
        return this;
    }

    default public MutableHttpMessage<B> basicAuth(CharSequence username, CharSequence password) {
        StringBuilder sb = new StringBuilder();
        sb.append(username);
        sb.append(":");
        sb.append(password);
        StringBuilder value = new StringBuilder();
        value.append("Basic");
        value.append(" ");
        value.append(new String(Base64.getEncoder().encode(sb.toString().getBytes())));
        this.header("Authorization", value.toString());
        return this;
    }

    default public MutableHttpMessage<B> bearerAuth(CharSequence token) {
        String sb = "Bearer " + token;
        this.header("Authorization", sb);
        return this;
    }

    default public MutableHttpMessage<B> headers(Map<CharSequence, CharSequence> namesAndValues) {
        MutableHttpHeaders headers = this.getHeaders();
        namesAndValues.forEach(headers::add);
        return this;
    }

    default public MutableHttpMessage<B> contentLength(long length) {
        this.getHeaders().add((CharSequence)"Content-Length", String.valueOf(length));
        return this;
    }

    default public MutableHttpMessage<B> contentType(CharSequence contentType) {
        this.getHeaders().add((CharSequence)"Content-Type", contentType);
        return this;
    }

    default public MutableHttpMessage<B> contentType(MediaType mediaType) {
        this.getHeaders().add((CharSequence)"Content-Type", mediaType);
        return this;
    }

    default public MutableHttpMessage<B> contentEncoding(CharSequence encoding) {
        if (encoding != null) {
            this.getHeaders().add((CharSequence)"Content-Encoding", encoding);
        }
        return this;
    }
}

