/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.http.HttpMessage;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpResponseFactory;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.exceptions.UriSyntaxException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import javax.annotation.Nullable;

public interface HttpResponse<B>
extends HttpMessage<B> {
    public HttpStatus getStatus();

    @Override
    default public HttpResponse<B> setAttribute(CharSequence name, Object value) {
        return (HttpResponse)HttpMessage.super.setAttribute(name, value);
    }

    @Nullable
    default public String header(@Nullable CharSequence name) {
        if (name == null) {
            return null;
        }
        return (String)this.getHeaders().get(name);
    }

    @Nullable
    default public B body() {
        return this.getBody().orElse(null);
    }

    default public HttpStatus status() {
        return this.getStatus();
    }

    default public int code() {
        return this.getStatus().getCode();
    }

    default public String reason() {
        return this.getStatus().getReason();
    }

    public static <T> MutableHttpResponse<T> ok() {
        return HttpResponseFactory.INSTANCE.ok();
    }

    public static <T> MutableHttpResponse<T> notFound() {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.NOT_FOUND);
    }

    public static <T> MutableHttpResponse<T> unauthorized() {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.UNAUTHORIZED);
    }

    public static <T> MutableHttpResponse<T> notFound(T body) {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.NOT_FOUND).body(body);
    }

    public static <T> MutableHttpResponse<T> badRequest() {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.BAD_REQUEST);
    }

    public static <T> MutableHttpResponse<T> badRequest(T body) {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.BAD_REQUEST, body);
    }

    public static <T> MutableHttpResponse<T> unprocessableEntity() {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    public static <T> MutableHttpResponse<T> notAllowed(HttpMethod ... allowed) {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.METHOD_NOT_ALLOWED).headers(headers -> headers.allow(allowed));
    }

    public static <T> MutableHttpResponse<T> notAllowed(Set<HttpMethod> allowed) {
        return HttpResponse.notAllowedGeneric(allowed);
    }

    public static <T> MutableHttpResponse<T> notAllowedGeneric(Set<? extends CharSequence> allowed) {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.METHOD_NOT_ALLOWED).headers(headers -> headers.allowGeneric(allowed));
    }

    public static <T> MutableHttpResponse<T> serverError() {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static <T> MutableHttpResponse<T> serverError(T body) {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.INTERNAL_SERVER_ERROR).body(body);
    }

    public static <T> MutableHttpResponse<T> accepted() {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.ACCEPTED);
    }

    public static <T> MutableHttpResponse<T> accepted(URI location) {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.ACCEPTED).headers(headers -> headers.location(location));
    }

    public static <T> MutableHttpResponse<T> noContent() {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.NO_CONTENT);
    }

    public static <T> MutableHttpResponse<T> notModified() {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.NOT_MODIFIED);
    }

    public static <T> MutableHttpResponse<T> ok(T body) {
        return HttpResponseFactory.INSTANCE.ok(body);
    }

    public static <T> MutableHttpResponse<T> created(T body) {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.CREATED).body(body);
    }

    public static <T> MutableHttpResponse<T> created(URI location) {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.CREATED).headers(headers -> headers.location(location));
    }

    public static <T> MutableHttpResponse<T> created(T body, URI location) {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.CREATED).body(body).headers(headers -> headers.location(location));
    }

    public static <T> MutableHttpResponse<T> seeOther(URI location) {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.SEE_OTHER).headers(headers -> headers.location(location));
    }

    public static <T> MutableHttpResponse<T> temporaryRedirect(URI location) {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.TEMPORARY_REDIRECT).headers(headers -> headers.location(location));
    }

    public static <T> MutableHttpResponse<T> permanentRedirect(URI location) {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.PERMANENT_REDIRECT).headers(headers -> headers.location(location));
    }

    public static <T> MutableHttpResponse<T> redirect(URI location) {
        return HttpResponseFactory.INSTANCE.status(HttpStatus.MOVED_PERMANENTLY).headers(headers -> headers.location(location));
    }

    public static <T> MutableHttpResponse<T> status(HttpStatus status) {
        return HttpResponseFactory.INSTANCE.status(status);
    }

    public static <T> MutableHttpResponse<T> status(HttpStatus status, String reason) {
        return HttpResponseFactory.INSTANCE.status(status, reason);
    }

    public static URI uri(CharSequence uri) {
        try {
            return new URI(uri.toString());
        }
        catch (URISyntaxException e) {
            throw new UriSyntaxException(e);
        }
    }
}

