/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.MediaType;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.stream.Collectors;

public interface MutableHttpHeaders
extends MutableHeaders,
HttpHeaders {
    public MutableHttpHeaders add(CharSequence var1, CharSequence var2);

    public MutableHttpHeaders remove(CharSequence var1);

    default public MutableHttpHeaders allow(HttpMethod ... methods) {
        return this.allow(Arrays.asList(methods));
    }

    default public MutableHttpHeaders date(LocalDateTime date) {
        if (date != null) {
            this.add((CharSequence)"Date", ZonedDateTime.of(date, ZoneId.systemDefault()));
        }
        return this;
    }

    default public MutableHttpHeaders expires(LocalDateTime date) {
        if (date != null) {
            this.add((CharSequence)"Expires", ZonedDateTime.of(date, ZoneId.systemDefault()));
        }
        return this;
    }

    default public MutableHttpHeaders lastModified(LocalDateTime date) {
        if (date != null) {
            this.add((CharSequence)"Last-Modified", ZonedDateTime.of(date, ZoneId.systemDefault()));
        }
        return this;
    }

    default public MutableHttpHeaders ifModifiedSince(LocalDateTime date) {
        if (date != null) {
            this.add((CharSequence)"If-Modified-Since", ZonedDateTime.of(date, ZoneId.systemDefault()));
        }
        return this;
    }

    default public MutableHttpHeaders date(long timeInMillis) {
        this.add((CharSequence)"Date", ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeInMillis), ZoneId.systemDefault()));
        return this;
    }

    default public MutableHttpHeaders expires(long timeInMillis) {
        this.add((CharSequence)"Expires", ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeInMillis), ZoneId.systemDefault()));
        return this;
    }

    default public MutableHttpHeaders lastModified(long timeInMillis) {
        this.add((CharSequence)"Last-Modified", ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeInMillis), ZoneId.systemDefault()));
        return this;
    }

    default public MutableHttpHeaders ifModifiedSince(long timeInMillis) {
        this.add((CharSequence)"If-Modified-Since", ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeInMillis), ZoneId.systemDefault()));
        return this;
    }

    default public MutableHttpHeaders auth(String username, String password) {
        StringBuilder sb = new StringBuilder();
        sb.append(username);
        sb.append(":");
        sb.append(password);
        return this.auth(sb.toString());
    }

    default public MutableHttpHeaders auth(String userInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("Basic");
        sb.append(" ");
        sb.append(Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.ISO_8859_1)));
        String token = sb.toString();
        this.add((CharSequence)"Authorization", token);
        return this;
    }

    default public MutableHttpHeaders allow(Collection<HttpMethod> methods) {
        return this.allowGeneric(methods);
    }

    default public MutableHttpHeaders allowGeneric(Collection<? extends CharSequence> methods) {
        String value = methods.stream().distinct().collect(Collectors.joining(","));
        return this.add((CharSequence)"Allow", value);
    }

    default public MutableHttpHeaders location(URI uri) {
        return this.add((CharSequence)"Location", uri.toString());
    }

    default public MutableHttpHeaders contentType(MediaType mediaType) {
        return this.add((CharSequence)"Content-Type", mediaType);
    }

    default public MutableHttpHeaders add(CharSequence header, ZonedDateTime value) {
        if (header != null && value != null) {
            this.add(header, value.withZoneSameInstant(ZoneId.of("GMT")).format(DateTimeFormatter.RFC_1123_DATE_TIME));
        }
        return this;
    }

    default public MutableHttpHeaders add(CharSequence header, Integer value) {
        if (header != null && value != null) {
            return this.add(header, value.toString());
        }
        return this;
    }
}

