/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.uri;

import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.uri.DefaultUriBuilder;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface UriBuilder {
    @Nonnull
    public UriBuilder fragment(@Nullable String var1);

    @Nonnull
    public UriBuilder scheme(@Nullable String var1);

    @Nonnull
    public UriBuilder userInfo(@Nullable String var1);

    @Nonnull
    public UriBuilder host(@Nullable String var1);

    @Nonnull
    public UriBuilder port(int var1);

    @Nonnull
    public UriBuilder path(@Nullable String var1);

    @Nonnull
    public UriBuilder replacePath(@Nullable String var1);

    @Nonnull
    public UriBuilder queryParam(String var1, Object ... var2);

    @Nonnull
    public UriBuilder replaceQueryParam(String var1, Object ... var2);

    @Nonnull
    public URI build();

    @Nonnull
    public URI expand(Map<String, ? super Object> var1);

    @Nonnull
    public static UriBuilder of(@Nonnull URI uri) {
        ArgumentUtils.requireNonNull((String)"uri", (Object)uri);
        return new DefaultUriBuilder(uri);
    }

    @Nonnull
    public static UriBuilder of(@Nonnull CharSequence uri) {
        ArgumentUtils.requireNonNull((String)"uri", (Object)uri);
        return new DefaultUriBuilder(uri);
    }
}

