/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpRequestWrapper;
import java.util.Optional;

public class FullHttpRequest<B>
extends HttpRequestWrapper<B> {
    private final Argument<B> bodyType;

    public FullHttpRequest(HttpRequest<B> delegate, Argument<B> bodyType) {
        super(delegate);
        this.bodyType = bodyType;
    }

    @Override
    public Optional<B> getBody() {
        ArgumentConversionContext conversionContext = ConversionContext.of(this.bodyType);
        Optional body = this.getBody(conversionContext);
        if (conversionContext.hasErrors()) {
            Exception cause = null;
            Optional lastError = conversionContext.getLastError();
            if (lastError.isPresent()) {
                ConversionError conversionError = (ConversionError)lastError.get();
                cause = conversionError.getCause();
            }
            if (cause instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)cause;
                throw runtimeException;
            }
            if (cause != null) {
                throw new ConversionErrorException(this.bodyType, cause);
            }
        }
        return body;
    }
}

