/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind.binders;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.bind.binders.BodyArgumentBinder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DefaultBodyAnnotationBinder<T>
implements BodyArgumentBinder<T> {
    protected final ConversionService conversionService;

    public DefaultBodyAnnotationBinder(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Class<Body> getAnnotationType() {
        return Body.class;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        Optional bodyComponent = context.getAnnotationMetadata().stringValue(Body.class);
        if (bodyComponent.isPresent()) {
            Optional<ConvertibleValues> body = source.getBody(ConvertibleValues.class);
            if (body.isPresent()) {
                String component;
                ConvertibleValues values = body.get();
                if (!values.contains(component = (String)bodyComponent.get())) {
                    component = NameUtils.hyphenate((String)component);
                }
                Optional value = values.get((CharSequence)component, context);
                return this.newResult(value.orElse(null), context);
            }
            return ArgumentBinder.BindingResult.EMPTY;
        }
        Optional body = source.getBody();
        if (body.isEmpty()) {
            return ArgumentBinder.BindingResult.EMPTY;
        }
        Object o = body.get();
        Optional converted = this.conversionService.convert(o, context);
        return this.newResult(converted.orElse(null), context);
    }

    private ArgumentBinder.BindingResult<T> newResult(T converted, ArgumentConversionContext<T> context) {
        final Optional lastError = context.getLastError();
        if (lastError.isPresent()) {
            return new ArgumentBinder.BindingResult<T>(){

                public Optional<T> getValue() {
                    return Optional.empty();
                }

                public List<ConversionError> getConversionErrors() {
                    return Collections.singletonList((ConversionError)lastError.get());
                }
            };
        }
        return () -> Optional.ofNullable(converted);
    }
}

