/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.execution.CompletableFutureExecutionFlow;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlow;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.FilterContinuation;
import io.micronaut.http.filter.FilterOrder;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.reactive.execution.ReactiveExecutionFlow;
import io.micronaut.inject.ExecutableMethod;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CorePublisher;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@Internal
public class FilterRunner {
    private static final Logger LOG = LoggerFactory.getLogger(FilterRunner.class);
    private static final Predicate<FilterMethodContext> FILTER_CONDITION_ALWAYS_TRUE = runner -> true;
    private final ConversionService conversionService;
    private final List<GenericHttpFilter> filters;
    private Context initialReactorContext = Context.empty();

    public FilterRunner(ConversionService conversionService, List<GenericHttpFilter> filters) {
        this.conversionService = conversionService;
        this.filters = Objects.requireNonNull(filters, "filters");
    }

    private static void checkOrdered(List<GenericHttpFilter> filters) {
        if (!filters.stream().allMatch(f -> f instanceof Ordered)) {
            throw new IllegalStateException("Some filters cannot be ordered: " + filters);
        }
    }

    public static void sort(@NonNull List<GenericHttpFilter> filters) {
        FilterRunner.checkOrdered(filters);
        OrderUtil.sort(filters);
    }

    public static void sortReverse(@NonNull List<GenericHttpFilter> filters) {
        FilterRunner.checkOrdered(filters);
        OrderUtil.reverseSort(filters);
    }

    protected ExecutionFlow<? extends HttpResponse<?>> processResponse(HttpRequest<?> request, HttpResponse<?> response) {
        return ExecutionFlow.just(response);
    }

    protected ExecutionFlow<? extends HttpResponse<?>> processFailure(HttpRequest<?> request, Throwable failure) {
        return ExecutionFlow.error((Throwable)failure);
    }

    public final FilterRunner reactorContext(Context reactorContext) {
        this.initialReactorContext = reactorContext;
        return this;
    }

    public final ExecutionFlow<MutableHttpResponse<?>> run(HttpRequest<?> request) {
        return this.filterRequest(new FilterContext(request, this.initialReactorContext), this.filters.listIterator(), new HashMap());
    }

    private ExecutionFlow<HttpResponse<?>> filterRequest(FilterContext context, ListIterator<GenericHttpFilter> iterator, Map<GenericHttpFilter, Map.Entry<ExecutionFlow<FilterContext>, FilterContinuationImpl<?>>> suspended) {
        return this.filterRequest0(context, iterator, suspended).flatMap(newContext -> {
            if (newContext.response != null) {
                return this.filterResponse((FilterContext)newContext, iterator, null, suspended);
            }
            return ExecutionFlow.error((Throwable)new IllegalStateException("Request filters didn't produce any response!"));
        });
    }

    private ExecutionFlow<FilterContext> filterRequest0(FilterContext context, ListIterator<GenericHttpFilter> iterator, Map<GenericHttpFilter, Map.Entry<ExecutionFlow<FilterContext>, FilterContinuationImpl<?>>> suspended) {
        if (context.response != null) {
            return ExecutionFlow.just((Object)context);
        }
        if (iterator.hasNext()) {
            GenericHttpFilter filter = iterator.next();
            return this.processRequestFilter(filter, context, suspended).flatMap(newContext -> this.filterRequest0((FilterContext)newContext, iterator, suspended)).onErrorResume(throwable -> this.filterResponse(context, iterator, (Throwable)throwable, suspended).map(context::withResponse));
        }
        return ExecutionFlow.error((Throwable)new IllegalStateException("Request filters didn't produce any response!"));
    }

    private ExecutionFlow<HttpResponse<?>> filterResponse(FilterContext context, ListIterator<GenericHttpFilter> iterator, @Nullable Throwable exception, Map<GenericHttpFilter, Map.Entry<ExecutionFlow<FilterContext>, FilterContinuationImpl<?>>> suspended) {
        if (iterator.hasPrevious()) {
            GenericHttpFilter filter = iterator.previous();
            return this.processResponseFilter(filter, context, exception, suspended).flatMap(newContext -> {
                if (context != newContext) {
                    return this.processResponse(newContext.request, newContext.response).map(context::withResponse);
                }
                return ExecutionFlow.just((Object)newContext);
            }).onErrorResume(throwable -> this.processFailure(context.request, (Throwable)throwable).map(context::withResponse)).flatMap(newContext -> this.filterResponse((FilterContext)newContext, iterator, newContext.response == null ? exception : null, suspended));
        }
        if (context.response != null) {
            return ExecutionFlow.just(context.response);
        }
        if (exception != null) {
            return ExecutionFlow.error((Throwable)exception);
        }
        return ExecutionFlow.error((Throwable)new IllegalStateException("No response after response filters completed!"));
    }

    private ExecutionFlow<FilterContext> processRequestFilter(GenericHttpFilter filter, FilterContext context, Map<GenericHttpFilter, Map.Entry<ExecutionFlow<FilterContext>, FilterContinuationImpl<?>>> suspended) {
        Executor executeOn;
        if (filter instanceof GenericHttpFilter.Async) {
            GenericHttpFilter.Async async = (GenericHttpFilter.Async)filter;
            executeOn = async.executor();
            filter = async.actual();
        } else {
            executeOn = null;
        }
        if (filter instanceof FilterMethod) {
            ExecutionFlow filterMethodFlow;
            FilterMethod before = (FilterMethod)filter;
            if (before.isResponseFilter) {
                return ExecutionFlow.just((Object)context);
            }
            FilterContinuationImpl<?> continuation = before.isSuspended() ? before.createContinuation(context) : null;
            FilterMethodContext filterMethodContext = new FilterMethodContext(context.request, context.response, null, continuation);
            if (executeOn == null) {
                filterMethodFlow = before.filter(context, filterMethodContext);
            } else {
                if (continuation != null) {
                    continuation.completeOn = executeOn;
                }
                filterMethodFlow = ExecutionFlow.async((Executor)executeOn, () -> before.filter(context, filterMethodContext));
            }
            if (before.isSuspended()) {
                if (continuation instanceof ReactiveResultAwareReactiveContinuationImpl) {
                    suspended.put(filter, Map.entry(continuation.filterProcessedFlow(), continuation));
                } else {
                    if (continuation instanceof ReactiveContinuationImpl) {
                        throw new IllegalStateException("Not supported use-case with reactive continuation and non-reactive return type");
                    }
                    suspended.put(filter, Map.entry(filterMethodFlow, continuation));
                }
                return continuation.nextFilterFlow();
            }
            return filterMethodFlow;
        }
        if (filter instanceof GenericHttpFilter.AroundLegacy) {
            GenericHttpFilter.AroundLegacy around = (GenericHttpFilter.AroundLegacy)filter;
            FilterChainImpl chainSuspensionPoint = new FilterChainImpl(this.conversionService, context);
            suspended.put(around, Map.entry(chainSuspensionPoint.filterProcessedFlow(), chainSuspensionPoint));
            chainSuspensionPoint.completeOn = executeOn;
            if (executeOn == null) {
                try {
                    around.bean().doFilter(context.request, chainSuspensionPoint).subscribe((Subscriber)chainSuspensionPoint);
                }
                catch (Throwable e) {
                    chainSuspensionPoint.triggerFilterProcessed(context, null, e);
                }
                return chainSuspensionPoint.nextFilterFlow();
            }
            return ExecutionFlow.async((Executor)executeOn, () -> {
                try {
                    around.bean().doFilter(context.request, chainSuspensionPoint).subscribe((Subscriber)chainSuspensionPoint);
                }
                catch (Throwable e) {
                    chainSuspensionPoint.triggerFilterProcessed(context, null, e);
                }
                return chainSuspensionPoint.nextFilterFlow();
            });
        }
        if (filter instanceof GenericHttpFilter.TerminalReactive || filter instanceof GenericHttpFilter.Terminal || filter instanceof GenericHttpFilter.TerminalWithReactorContext) {
            ReactiveExecutionFlow terminalFlow;
            if (executeOn != null) {
                throw new IllegalStateException("Async terminal filters not supported");
            }
            if (filter.isSuspended()) {
                throw new IllegalStateException("Terminal filters cannot be suspended");
            }
            if (filter instanceof GenericHttpFilter.TerminalWithReactorContext) {
                GenericHttpFilter.TerminalWithReactorContext t = (GenericHttpFilter.TerminalWithReactorContext)filter;
                try {
                    terminalFlow = t.execute(context.request, context.reactorContext);
                }
                catch (Throwable e) {
                    terminalFlow = ExecutionFlow.error((Throwable)e);
                }
            } else if (filter instanceof GenericHttpFilter.Terminal) {
                GenericHttpFilter.Terminal t = (GenericHttpFilter.Terminal)filter;
                try {
                    terminalFlow = t.execute(context.request);
                }
                catch (Throwable e) {
                    terminalFlow = ExecutionFlow.error((Throwable)e);
                }
            } else {
                terminalFlow = ReactiveExecutionFlow.fromPublisher(Mono.from(((GenericHttpFilter.TerminalReactive)filter).responsePublisher()).contextWrite((ContextView)context.reactorContext));
            }
            return terminalFlow.flatMap(response -> ExecutionFlow.just((Object)context.withResponse((HttpResponse<?>)response)));
        }
        throw new IllegalStateException("Unknown filter type");
    }

    private ExecutionFlow<FilterContext> processResponseFilter(GenericHttpFilter filter, FilterContext filterContext, Throwable exceptionToFilter, Map<GenericHttpFilter, Map.Entry<ExecutionFlow<FilterContext>, FilterContinuationImpl<?>>> suspended) {
        Executor executeOn;
        if (filter instanceof GenericHttpFilter.Async) {
            GenericHttpFilter.Async async = (GenericHttpFilter.Async)filter;
            executeOn = async.executor();
            filter = async.actual();
        } else {
            executeOn = null;
        }
        Map.Entry<ExecutionFlow<FilterContext>, FilterContinuationImpl<?>> suspendedFilterData = suspended.get(filter);
        if (suspendedFilterData != null) {
            ExecutionFlow<FilterContext> filterProcessedFlow = suspendedFilterData.getKey();
            FilterContinuationImpl<?> continuation = suspendedFilterData.getValue();
            continuation.resume(filterContext, exceptionToFilter);
            return filterProcessedFlow;
        }
        if (exceptionToFilter != null && !filter.isFiltersException()) {
            return ExecutionFlow.just((Object)filterContext);
        }
        if (filter instanceof FilterMethod) {
            FilterMethod after = (FilterMethod)filter;
            if (after.isResponseFilter) {
                if (after.isSuspended()) {
                    return ExecutionFlow.error((Throwable)new IllegalStateException("Response filter cannot have a continuation!"));
                }
                FilterMethodContext filterMethodContext = new FilterMethodContext(filterContext.request, filterContext.response, exceptionToFilter, null);
                if (executeOn == null) {
                    return after.filter(filterContext, filterMethodContext);
                }
                return ExecutionFlow.async((Executor)executeOn, () -> after.filter(filterContext, filterMethodContext));
            }
        }
        return ExecutionFlow.just((Object)filterContext);
    }

    @Internal
    public static <T> FilterMethod<T> prepareFilterMethod(ConversionService conversionService, T bean, ExecutableMethod<T, ?> method, boolean isResponseFilter, FilterOrder order) throws IllegalArgumentException {
        return FilterRunner.prepareFilterMethod(conversionService, bean, method, method.getArguments(), method.getReturnType().asArgument(), isResponseFilter, order);
    }

    @Internal
    public static void validateFilterMethod(Argument<?>[] arguments, Argument<?> returnType, boolean isResponseFilter) throws IllegalArgumentException {
        FilterRunner.prepareFilterMethod(ConversionService.SHARED, null, null, arguments, returnType, isResponseFilter, null);
    }

    @Internal
    public static <T> FilterMethod<T> prepareFilterMethod(ConversionService conversionService, T bean, ExecutableMethod<T, ?> method, Argument<?>[] arguments, Argument<?> returnType, boolean isResponseFilter, FilterOrder order) throws IllegalArgumentException {
        FilterArgBinder[] fulfilled = new FilterArgBinder[arguments.length];
        Predicate<FilterMethodContext> filterCondition = FILTER_CONDITION_ALWAYS_TRUE;
        boolean skipOnError = isResponseFilter;
        boolean filtersException = false;
        Function<FilterContext, FilterContinuationImpl> continuationCreator = null;
        for (int i = 0; i < arguments.length; ++i) {
            Argument<?> argument = arguments[i];
            if (argument.getType().isAssignableFrom(HttpRequest.class)) {
                fulfilled[i] = ctx -> ctx.request;
                continue;
            }
            if (argument.getType().isAssignableFrom(MutableHttpRequest.class)) {
                fulfilled[i] = ctx -> {
                    HttpRequest<?> request = ctx.request;
                    if (!(ctx.request instanceof MutableHttpRequest)) {
                        request = ctx.request.mutate();
                    }
                    return request;
                };
                continue;
            }
            if (argument.getType().isAssignableFrom(MutableHttpResponse.class)) {
                if (!isResponseFilter) {
                    throw new IllegalArgumentException("Filter is called before the response is known, can't have a response argument");
                }
                fulfilled[i] = ctx -> ctx.response;
                continue;
            }
            if (Throwable.class.isAssignableFrom(argument.getType())) {
                if (!isResponseFilter) {
                    throw new IllegalArgumentException("Request filters cannot handle exceptions");
                }
                if (!argument.isNullable()) {
                    filterCondition = filterCondition.and(ctx -> ctx.failure != null && argument.isInstance((Object)ctx.failure));
                    fulfilled[i] = ctx -> ctx.failure;
                } else {
                    fulfilled[i] = ctx -> {
                        if (ctx.failure != null && argument.isInstance((Object)ctx.failure)) {
                            return ctx.failure;
                        }
                        return null;
                    };
                }
                filtersException = true;
                skipOnError = false;
                continue;
            }
            if (argument.getType() == FilterContinuation.class) {
                if (isResponseFilter) {
                    throw new IllegalArgumentException("Response filters cannot use filter continuations");
                }
                if (continuationCreator != null) {
                    throw new IllegalArgumentException("Only one continuation per filter is allowed");
                }
                Argument continuationReturnType = (Argument)argument.getFirstTypeVariable().orElseThrow(() -> new IllegalArgumentException("Continuations must specify generic type"));
                if (FilterRunner.isReactive(continuationReturnType) && continuationReturnType.getWrappedType().isAssignableFrom(MutableHttpResponse.class)) {
                    continuationCreator = FilterRunner.isReactive(returnType) ? ctx -> new ReactiveResultAwareReactiveContinuationImpl(conversionService, (FilterContext)ctx) : ctx -> new ReactiveContinuationImpl(conversionService, (FilterContext)ctx, continuationReturnType.getType());
                    fulfilled[i] = ctx -> ctx.continuation;
                    continue;
                }
                if (continuationReturnType.getType().isAssignableFrom(MutableHttpResponse.class)) {
                    continuationCreator = BlockingContinuationImpl::new;
                    fulfilled[i] = ctx -> ctx.continuation;
                    continue;
                }
                throw new IllegalArgumentException("Unsupported continuation type: " + continuationReturnType);
            }
            throw new IllegalArgumentException("Unsupported filter argument type: " + argument);
        }
        if (skipOnError) {
            filterCondition = filterCondition.and(ctx -> ctx.failure == null);
        } else if (filterCondition == FILTER_CONDITION_ALWAYS_TRUE) {
            filterCondition = null;
        }
        FilterReturnHandler returnHandler = FilterRunner.prepareReturnHandler(conversionService, returnType, isResponseFilter, continuationCreator != null, false);
        return new FilterMethod<T>(order, bean, method, isResponseFilter, fulfilled, filterCondition, (Function<FilterContext, FilterContinuationImpl<?>>)continuationCreator, filtersException, returnHandler);
    }

    private static boolean isReactive(Argument<?> continuationReturnType) {
        return continuationReturnType.isReactive() || continuationReturnType.getType() == Publisher.class;
    }

    private static FilterReturnHandler prepareReturnHandler(ConversionService conversionService, Argument<?> type, boolean isResponseFilter, boolean hasContinuation, boolean fromOptional) throws IllegalArgumentException {
        boolean nullable;
        if (type.isOptional()) {
            FilterReturnHandler next = FilterRunner.prepareReturnHandler(conversionService, type.getWrappedType(), isResponseFilter, hasContinuation, true);
            return (r, o, c) -> next.handle(r, o == null ? null : ((Optional)o).orElse(null), c);
        }
        if (type.isVoid()) {
            if (hasContinuation) {
                return FilterReturnHandler.VOID_WITH_CONTINUATION;
            }
            return FilterReturnHandler.VOID;
        }
        boolean bl = nullable = type.isNullable() || fromOptional;
        if (!isResponseFilter) {
            if (type.getType() == HttpRequest.class || type.getType() == MutableHttpRequest.class) {
                if (hasContinuation) {
                    throw new IllegalArgumentException("Filter method that accepts a continuation cannot return an HttpRequest");
                }
                if (nullable) {
                    return FilterReturnHandler.REQUEST_NULLABLE;
                }
                return FilterReturnHandler.REQUEST;
            }
            if (type.getType() == HttpResponse.class || type.getType() == MutableHttpResponse.class) {
                if (hasContinuation) {
                    return FilterReturnHandler.FROM_REQUEST_RESPONSE_WITH_CONTINUATION;
                }
                if (nullable) {
                    return FilterReturnHandler.FROM_REQUEST_RESPONSE_NULLABLE;
                }
                return FilterReturnHandler.FROM_REQUEST_RESPONSE;
            }
        } else {
            if (hasContinuation) {
                throw new AssertionError();
            }
            if (type.getType() == HttpResponse.class || type.getType() == MutableHttpResponse.class) {
                if (nullable) {
                    return FilterReturnHandler.FROM_RESPONSE_RESPONSE_NULLABLE;
                }
                return FilterReturnHandler.FROM_RESPONSE_RESPONSE;
            }
        }
        if (FilterRunner.isReactive(type)) {
            FilterReturnHandler next = FilterRunner.prepareReturnHandler(conversionService, type.getWrappedType(), isResponseFilter, hasContinuation, false);
            return (context, returnValue, continuation) -> {
                if (returnValue == null && !nullable) {
                    return next.handle(context, null, continuation);
                }
                Mono publisher = Mono.from((Publisher)((Publisher)Publishers.convertPublisher((ConversionService)conversionService, (Object)returnValue, Publisher.class))).contextWrite((ContextView)context.reactorContext());
                if (continuation instanceof ReactiveResultAwareReactiveContinuationImpl) {
                    ReactiveResultAwareReactiveContinuationImpl reactiveContinuation = (ReactiveResultAwareReactiveContinuationImpl)continuation;
                    publisher.subscribe((CoreSubscriber)reactiveContinuation);
                    return reactiveContinuation.nextFilterFlow();
                }
                return ReactiveExecutionFlow.fromPublisher(publisher).flatMap(v -> {
                    try {
                        return next.handle(context, v, continuation);
                    }
                    catch (Throwable e) {
                        return ExecutionFlow.error((Throwable)e);
                    }
                });
            };
        }
        if (type.isAsync()) {
            FilterReturnHandler next = FilterRunner.prepareReturnHandler(conversionService, type.getWrappedType(), isResponseFilter, hasContinuation, false);
            return new DelayedFilterReturnHandler(isResponseFilter, next, nullable){

                @Override
                protected ExecutionFlow<?> toFlow(FilterContext context, Object returnValue, FilterContinuationImpl<?> continuation) {
                    return CompletableFutureExecutionFlow.just(((CompletionStage)returnValue).toCompletableFuture());
                }
            };
        }
        throw new IllegalArgumentException("Unsupported filter return type " + type.getType().getName());
    }

    private record FilterContext(HttpRequest<?> request, @Nullable HttpResponse<?> response, Context reactorContext) {
        FilterContext(HttpRequest<?> request, Context reactorContext) {
            this(request, null, reactorContext);
        }

        public FilterContext withRequest(@NonNull HttpRequest<?> request) {
            if (this.request == request) {
                return this;
            }
            if (this.response != null) {
                throw new IllegalStateException("Cannot modify the request after response is set!");
            }
            Objects.requireNonNull(request);
            return new FilterContext(request, this.response, this.reactorContext);
        }

        public FilterContext withResponse(@NonNull HttpResponse<?> response) {
            if (this.response == response) {
                return this;
            }
            Objects.requireNonNull(response);
            return new FilterContext(this.request, response, this.reactorContext);
        }

        public FilterContext withReactorContext(@NonNull Context reactorContext) {
            if (this.reactorContext == reactorContext) {
                return this;
            }
            Objects.requireNonNull(reactorContext);
            return new FilterContext(this.request, this.response, reactorContext);
        }
    }

    record FilterMethod<T>(FilterOrder order, T bean, Executable<T, ?> method, boolean isResponseFilter, FilterArgBinder[] argBinders, @Nullable Predicate<FilterMethodContext> filterCondition, Function<FilterContext, FilterContinuationImpl<?>> continuationCreator, boolean filtersException, FilterReturnHandler returnHandler) implements GenericHttpFilter,
    Ordered
    {
        @Override
        public boolean isSuspended() {
            return this.continuationCreator != null;
        }

        @Override
        public boolean isFiltersException() {
            return this.filtersException;
        }

        public int getOrder() {
            return this.order.getOrder(this.bean);
        }

        public FilterContinuationImpl<?> createContinuation(FilterContext filterContext) {
            return this.continuationCreator.apply(filterContext);
        }

        private ExecutionFlow<FilterContext> filter(FilterContext filterContext, FilterMethodContext methodContext) {
            try {
                if (this.filterCondition != null && !this.filterCondition.test(methodContext)) {
                    return ExecutionFlow.just((Object)filterContext);
                }
                Object[] args = this.bindArgs(methodContext);
                Object returnValue = this.method.invoke(this.bean, args);
                return this.returnHandler.handle(filterContext, returnValue, methodContext.continuation);
            }
            catch (Throwable e) {
                if (methodContext.continuation != null) {
                    return methodContext.continuation.afterMethodExecuted(e);
                }
                return ExecutionFlow.error((Throwable)e);
            }
        }

        private Object[] bindArgs(FilterMethodContext context) {
            Object[] args = new Object[this.argBinders.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.argBinders[i].bind(context);
            }
            return args;
        }
    }

    private static abstract class FilterContinuationImpl<R>
    implements FilterContinuation<R> {
        @Nullable
        Executor completeOn = null;
        FilterContext filterContext;
        final CompletableFuture<FilterContext> nextFilterProcessing = new CompletableFuture();
        final CompletableFuture<FilterContext> suspensionPoint = new CompletableFuture();
        final CompletableFuture<FilterContext> filterProcessed = new CompletableFuture();

        FilterContinuationImpl(FilterContext filterContext) {
            this.filterContext = filterContext;
        }

        @Override
        public FilterContinuation<R> request(HttpRequest<?> request) {
            this.filterContext = this.filterContext.withRequest(Objects.requireNonNull(request, "request"));
            return this;
        }

        protected final void proceedRequested() {
            if (this.nextFilterProcessing.isDone()) {
                throw new IllegalStateException("Already subscribed to proceed() publisher, or filter method threw an exception and was cancelled");
            }
            this.nextFilterProcessing.complete(this.filterContext);
        }

        public ExecutionFlow<FilterContext> nextFilterFlow() {
            return CompletableFutureExecutionFlow.just(this.nextFilterProcessing);
        }

        public ExecutionFlow<FilterContext> filterProcessedFlow() {
            return CompletableFutureExecutionFlow.just(this.filterProcessed);
        }

        public void resume(FilterContext filterContext, Throwable throwable) {
            if (!this.suspensionPoint.isDone()) {
                if (throwable == null) {
                    this.suspensionPoint.complete(filterContext);
                } else {
                    this.suspensionPoint.completeExceptionally(throwable);
                }
            } else if (throwable == null) {
                LOG.warn("Two outcomes for one continuation, this one is swallowed: {}", filterContext.response);
            } else {
                LOG.warn("Two outcomes for one continuation, this one is swallowed:", throwable);
            }
        }

        private ExecutionFlow<FilterContext> afterMethodExecuted() {
            return this.afterMethodExecuted(null, null);
        }

        private ExecutionFlow<FilterContext> afterMethodExecuted(@NonNull HttpResponse<?> response) {
            return this.afterMethodExecuted(response, null);
        }

        ExecutionFlow<FilterContext> afterMethodExecuted(@NonNull Throwable throwable) {
            return this.afterMethodExecuted(null, throwable);
        }

        private ExecutionFlow<FilterContext> afterMethodExecuted(@Nullable HttpResponse<?> newResponse, @Nullable Throwable newFailure) {
            FilterContext newFilterContext;
            if (this.suspensionPoint.isDone()) {
                try {
                    newFilterContext = this.suspensionPoint.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return ExecutionFlow.error((Throwable)new IllegalStateException("Failed to extract suspension point result", e));
                }
                catch (Exception e) {
                    return ExecutionFlow.error((Throwable)new IllegalStateException("Failed to extract suspension point result", e));
                }
            } else {
                newFilterContext = this.filterContext;
            }
            return this.asFilterProcessed(newFilterContext, newResponse, newFailure);
        }

        protected void triggerFilterProcessed(FilterContext filterContext, @Nullable HttpResponse<?> newResponse, @Nullable Throwable newFailure) {
            if (!this.nextFilterProcessing.isDone()) {
                if (newFailure == null) {
                    this.nextFilterProcessing.complete(newResponse == null ? filterContext : filterContext.withResponse(newResponse));
                } else {
                    this.nextFilterProcessing.completeExceptionally(newFailure);
                }
            }
            if (!this.filterProcessed.isDone()) {
                if (newFailure == null) {
                    this.filterProcessed.complete(newResponse == null ? filterContext : filterContext.withResponse(newResponse));
                } else {
                    this.filterProcessed.completeExceptionally(newFailure);
                }
            } else if (newFailure == null) {
                LOG.warn("Two outcomes for one continuation, this one is swallowed: {}", newResponse);
            } else {
                LOG.warn("Two outcomes for one continuation, this one is swallowed:", newFailure);
            }
        }

        @NonNull
        private ExecutionFlow<FilterContext> asFilterProcessed(FilterContext filterContext, @Nullable HttpResponse<?> newResponse, @Nullable Throwable newFailure) {
            this.triggerFilterProcessed(filterContext, newResponse, newFailure);
            return CompletableFutureExecutionFlow.just(this.filterProcessed);
        }
    }

    private record FilterMethodContext(HttpRequest<?> request, @Nullable HttpResponse<?> response, @Nullable Throwable failure, @Nullable FilterContinuationImpl<?> continuation) {
    }

    private static class ReactiveResultAwareReactiveContinuationImpl<T>
    extends ReactiveContinuationImpl<Publisher<T>>
    implements CoreSubscriber<HttpResponse<?>> {
        ReactiveResultAwareReactiveContinuationImpl(ConversionService conversionService, FilterContext filterContext) {
            super(conversionService, filterContext, Publisher.class);
        }

        @Override
        public Publisher<T> proceed() {
            return Mono.from((Publisher)((Publisher)super.proceed()));
        }

        public void onSubscribe(@NonNull Subscription s) {
            s.request(Long.MAX_VALUE);
        }

        public void onNext(HttpResponse<?> response) {
            this.triggerFilterProcessed(this.filterContext, response, null);
        }

        public void onError(Throwable t) {
            this.triggerFilterProcessed(this.filterContext, null, t);
        }

        public void onComplete() {
            if (!this.suspensionPoint.isDone()) {
                this.triggerFilterProcessed(this.filterContext, null, new IllegalStateException("Publisher did not return response"));
            }
        }

        @NonNull
        public Context currentContext() {
            return this.filterContext.reactorContext;
        }
    }

    private static class ReactiveContinuationImpl<R>
    extends FilterContinuationImpl<R>
    implements CorePublisher<HttpResponse<?>>,
    Subscription,
    BiConsumer<FilterContext, Throwable> {
        private final ConversionService conversionService;
        private final Class<R> reactiveType;
        private Subscriber<? super HttpResponse<?>> subscriber = null;
        private boolean addedListener = false;

        ReactiveContinuationImpl(ConversionService conversionService, FilterContext filterContext, Class<R> reactiveType) {
            super(filterContext);
            this.conversionService = conversionService;
            this.reactiveType = reactiveType;
        }

        @Override
        public R proceed() {
            return (R)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)this, this.reactiveType);
        }

        public void subscribe(@NonNull CoreSubscriber<? super HttpResponse<?>> subscriber) {
            this.subscribe((Subscriber<? super HttpResponse<?>>)subscriber);
        }

        public void subscribe(Subscriber<? super HttpResponse<?>> s) {
            if (this.subscriber != null) {
                throw new IllegalStateException("Only one subscriber allowed");
            }
            this.subscriber = s;
            if (s instanceof CoreSubscriber) {
                CoreSubscriber cs = (CoreSubscriber)s;
                this.filterContext = this.filterContext.withReactorContext(cs.currentContext());
            }
            this.proceedRequested();
            s.onSubscribe((Subscription)this);
        }

        public void request(long n) {
            if (n > 0L && !this.addedListener) {
                this.addedListener = true;
                if (this.completeOn == null) {
                    this.suspensionPoint.whenComplete((BiConsumer)this);
                } else {
                    this.suspensionPoint.whenCompleteAsync((BiConsumer)this, this.completeOn);
                }
            }
        }

        public void cancel() {
        }

        @Override
        public void accept(FilterContext filterContext, Throwable throwable) {
            try {
                if (throwable == null) {
                    this.filterContext = filterContext;
                    this.subscriber.onNext(filterContext.response);
                    this.subscriber.onComplete();
                } else {
                    this.subscriber.onError(throwable);
                }
            }
            catch (Throwable t) {
                LOG.warn("Subscriber threw exception", t);
            }
        }
    }

    private static final class FilterChainImpl
    extends ReactiveResultAwareReactiveContinuationImpl<MutableHttpResponse<?>>
    implements ClientFilterChain,
    ServerFilterChain {
        FilterChainImpl(ConversionService conversionService, FilterContext filterContext) {
            super(conversionService, filterContext);
        }

        @Override
        public Publisher<? extends HttpResponse<?>> proceed(MutableHttpRequest<?> request) {
            return this.proceed((HttpRequest<?>)request);
        }

        @Override
        public Publisher<MutableHttpResponse<?>> proceed(HttpRequest<?> request) {
            this.request(request);
            return this.proceed();
        }
    }

    private static interface FilterArgBinder {
        public Object bind(FilterMethodContext var1);
    }

    private static interface FilterReturnHandler {
        public static final FilterReturnHandler VOID_WITH_CONTINUATION = (filterContext, returnValue, continuation) -> continuation.afterMethodExecuted();
        public static final FilterReturnHandler VOID = (filterContext, returnValue, continuation) -> ExecutionFlow.just((Object)filterContext);
        public static final FilterReturnHandler FROM_REQUEST_RESPONSE_WITH_CONTINUATION = (filterContext, returnValue, continuation) -> {
            if (returnValue == null) {
                return continuation.afterMethodExecuted();
            }
            return continuation.afterMethodExecuted((HttpResponse)returnValue);
        };
        public static final FilterReturnHandler REQUEST = (filterContext, returnValue, continuation) -> ExecutionFlow.just((Object)filterContext.withRequest((HttpRequest)Objects.requireNonNull(returnValue, "Returned request must not be null, or mark the method as @Nullable")));
        public static final FilterReturnHandler REQUEST_NULLABLE = (filterContext, returnValue, continuation) -> {
            if (returnValue == null) {
                return ExecutionFlow.just((Object)filterContext);
            }
            return ExecutionFlow.just((Object)filterContext.withRequest((HttpRequest)returnValue));
        };
        public static final FilterReturnHandler FROM_REQUEST_RESPONSE = (filterContext, returnValue, continuation) -> ExecutionFlow.just((Object)filterContext.withResponse((HttpResponse)Objects.requireNonNull(returnValue, "Returned response must not be null, or mark the method as @Nullable")));
        public static final FilterReturnHandler FROM_REQUEST_RESPONSE_NULLABLE = (filterContext, returnValue, continuation) -> {
            if (returnValue == null) {
                return ExecutionFlow.just((Object)filterContext);
            }
            return ExecutionFlow.just((Object)filterContext.withResponse((HttpResponse)returnValue));
        };
        public static final FilterReturnHandler FROM_RESPONSE_RESPONSE = (filterContext, returnValue, continuation) -> ExecutionFlow.just((Object)filterContext.withResponse((HttpResponse)Objects.requireNonNull(returnValue, "Returned response must not be null, or mark the method as @Nullable")));
        public static final FilterReturnHandler FROM_RESPONSE_RESPONSE_NULLABLE = (filterContext, returnValue, continuation) -> {
            if (returnValue == null) {
                return ExecutionFlow.just((Object)filterContext);
            }
            return ExecutionFlow.just((Object)filterContext.withResponse((HttpResponse)returnValue));
        };

        public ExecutionFlow<FilterContext> handle(FilterContext var1, @Nullable Object var2, @Nullable FilterContinuationImpl<?> var3) throws Throwable;
    }

    private static final class BlockingContinuationImpl
    extends FilterContinuationImpl<HttpResponse<?>> {
        BlockingContinuationImpl(FilterContext filterContext) {
            super(filterContext);
        }

        @Override
        public HttpResponse<?> proceed() {
            this.proceedRequested();
            boolean interrupted = false;
            while (true) {
                try {
                    this.filterContext = (FilterContext)this.suspensionPoint.get();
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return this.filterContext.response;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        RuntimeException re = (RuntimeException)cause;
                        throw re;
                    }
                    throw new RuntimeException(cause);
                }
                break;
            }
        }
    }

    private static abstract class DelayedFilterReturnHandler
    implements FilterReturnHandler {
        final boolean isResponseFilter;
        final FilterReturnHandler next;
        final boolean nullable;

        private DelayedFilterReturnHandler(boolean isResponseFilter, FilterReturnHandler next, boolean nullable) {
            this.isResponseFilter = isResponseFilter;
            this.next = next;
            this.nullable = nullable;
        }

        protected abstract ExecutionFlow<?> toFlow(FilterContext var1, Object var2, @Nullable FilterContinuationImpl<?> var3);

        @Override
        public ExecutionFlow<FilterContext> handle(FilterContext context, @Nullable Object returnValue, FilterContinuationImpl<?> continuation) throws Throwable {
            if (returnValue == null && this.nullable) {
                return this.next.handle(context, null, continuation);
            }
            ExecutionFlow<?> delayedFlow = this.toFlow(context, Objects.requireNonNull(returnValue, "Returned value must not be null, or mark the method as @Nullable"), continuation);
            ImperativeExecutionFlow doneFlow = delayedFlow.tryComplete();
            if (doneFlow != null) {
                if (doneFlow.getError() != null) {
                    throw doneFlow.getError();
                }
                return this.next.handle(context, doneFlow.getValue(), continuation);
            }
            return delayedFlow.flatMap(v -> {
                try {
                    return this.next.handle(context, v, continuation);
                }
                catch (Throwable e) {
                    return ExecutionFlow.error((Throwable)e);
                }
            });
        }
    }
}

