/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ImmutableArgumentConversionContext;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.http.annotation.Produces;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeHint(value={MediaType[].class})
public class MediaType
implements CharSequence {
    public static final String EXTENSION_JSON = "json";
    public static final String EXTENSION_XML = "xml";
    public static final String EXTENSION_PDF = "pdf";
    public static final String EXTENSION_XLSX = "xlsx";
    public static final String EXTENSION_XLS = "xls";
    public static final MediaType[] EMPTY_ARRAY = new MediaType[0];
    public static final String ALL = "*/*";
    public static final MediaType ALL_TYPE = new MediaType("*/*", "all");
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final MediaType APPLICATION_FORM_URLENCODED_TYPE;
    public static final MediaType FORM;
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final MediaType MULTIPART_FORM_DATA_TYPE;
    public static final String TEXT_HTML = "text/html";
    public static final MediaType TEXT_HTML_TYPE;
    public static final String TEXT_CSV = "text/csv";
    public static final MediaType TEXT_CSV_TYPE;
    public static final String APPLICATION_XHTML = "application/xhtml+xml";
    public static final MediaType APPLICATION_XHTML_TYPE;
    public static final String APPLICATION_XML = "application/xml";
    public static final MediaType APPLICATION_XML_TYPE;
    public static final String APPLICATION_JSON = "application/json";
    public static final MediaType APPLICATION_JSON_TYPE;
    public static final String APPLICATION_YAML = "application/x-yaml";
    public static final MediaType APPLICATION_YAML_TYPE;
    public static final String MICROSOFT_EXCEL_OPEN_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final MediaType MICROSOFT_EXCEL_OPEN_XML_TYPE;
    public static final String MICROSOFT_EXCEL = "application/vnd.ms-excel";
    public static final MediaType MICROSOFT_EXCEL_TYPE;
    public static final String TEXT_XML = "text/xml";
    public static final MediaType TEXT_XML_TYPE;
    public static final String TEXT_JSON = "text/json";
    public static final MediaType TEXT_JSON_TYPE;
    public static final String TEXT_PLAIN = "text/plain";
    public static final MediaType TEXT_PLAIN_TYPE;
    public static final String APPLICATION_HAL_JSON = "application/hal+json";
    public static final MediaType APPLICATION_HAL_JSON_TYPE;
    public static final String APPLICATION_HAL_XML = "application/hal+xml";
    public static final MediaType APPLICATION_HAL_XML_TYPE;
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static final MediaType APPLICATION_ATOM_XML_TYPE;
    public static final String APPLICATION_VND_ERROR = "application/vnd.error+json";
    public static final MediaType APPLICATION_VND_ERROR_TYPE;
    public static final String TEXT_EVENT_STREAM = "text/event-stream";
    public static final MediaType TEXT_EVENT_STREAM_TYPE;
    public static final String APPLICATION_JSON_STREAM = "application/x-json-stream";
    public static final MediaType APPLICATION_JSON_STREAM_TYPE;
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final MediaType APPLICATION_OCTET_STREAM_TYPE;
    public static final String APPLICATION_GRAPHQL = "application/graphql";
    public static final MediaType APPLICATION_GRAPHQL_TYPE;
    public static final String APPLICATION_PDF = "application/pdf";
    public static final MediaType APPLICATION_PDF_TYPE;
    public static final String IMAGE_PNG = "image/png";
    public static final MediaType IMAGE_PNG_TYPE;
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final MediaType IMAGE_JPEG_TYPE;
    public static final String IMAGE_GIF = "image/gif";
    public static final MediaType IMAGE_GIF_TYPE;
    public static final String IMAGE_WEBP = "image/webp";
    public static final MediaType IMAGE_WEBP_TYPE;
    public static final String CHARSET_PARAMETER = "charset";
    public static final String Q_PARAMETER = "q";
    public static final String V_PARAMETER = "v";
    @Internal
    static final Argument<MediaType> ARGUMENT;
    @Internal
    static final ArgumentConversionContext<MediaType> CONVERSION_CONTEXT;
    private static final char SEMICOLON = ';';
    private static final String MIME_TYPES_FILE_NAME = "META-INF/http/mime.types";
    private static Map<String, String> mediaTypeFileExtensions;
    private static final List<Pattern> textTypePatterns;
    protected final String name;
    protected final String subtype;
    protected final String type;
    protected final String extension;
    protected final Map<CharSequence, String> parameters;
    private final String strRepr;
    private final String lowerName;
    private BigDecimal qualityNumberField = BigDecimal.ONE;
    private boolean valid;

    public MediaType(String name) {
        this(name, null, Collections.emptyMap());
    }

    public MediaType(String name, Map<String, String> params) {
        this(name, null, params);
    }

    public MediaType(String name, String extension) {
        this(name, extension, Collections.emptyMap());
    }

    public MediaType(String name, String extension, Map<String, String> params) {
        int j;
        String withoutArgs;
        if (name == null) {
            throw new IllegalArgumentException("Argument [name] cannot be null");
        }
        Iterator splitIt = StringUtils.splitOmitEmptyStringsIterator((CharSequence)(name = name.trim()), (char)';');
        if (splitIt.hasNext()) {
            withoutArgs = (String)splitIt.next();
            if (splitIt.hasNext()) {
                Map<String, String> parameters = null;
                while (splitIt.hasNext()) {
                    String paramExpression = (String)splitIt.next();
                    int i = paramExpression.indexOf(61);
                    if (i <= -1) continue;
                    String paramName = paramExpression.substring(0, i).trim();
                    String paramValue = paramExpression.substring(i + 1).trim();
                    if (Q_PARAMETER.equals(paramName)) {
                        this.qualityNumberField = new BigDecimal(paramValue);
                    }
                    if (parameters == null) {
                        parameters = new LinkedHashMap();
                    }
                    parameters.put(paramName, paramValue);
                }
                if (parameters == null) {
                    parameters = Collections.emptyMap();
                }
                this.parameters = parameters;
            } else {
                this.parameters = params == null ? Collections.emptyMap() : params;
            }
        } else {
            this.parameters = params == null ? Collections.emptyMap() : params;
            withoutArgs = name;
        }
        this.name = withoutArgs;
        this.lowerName = withoutArgs.toLowerCase(Locale.ROOT);
        int i = withoutArgs.indexOf(47);
        if (i <= -1) {
            throw new IllegalArgumentException("Invalid mime type: " + name);
        }
        this.type = withoutArgs.substring(0, i);
        this.subtype = withoutArgs.substring(i + 1);
        this.extension = extension != null ? extension : ((j = this.subtype.indexOf(43)) > -1 ? this.subtype.substring(j + 1) : this.subtype);
        this.strRepr = this.toString0();
    }

    public static MediaType of(String mediaType) {
        switch (mediaType) {
            case "*/*": {
                return ALL_TYPE;
            }
            case "application/x-www-form-urlencoded": {
                return APPLICATION_FORM_URLENCODED_TYPE;
            }
            case "multipart/form-data": {
                return MULTIPART_FORM_DATA_TYPE;
            }
            case "text/html": {
                return TEXT_HTML_TYPE;
            }
            case "text/csv": {
                return TEXT_CSV_TYPE;
            }
            case "application/xhtml+xml": {
                return APPLICATION_XHTML_TYPE;
            }
            case "application/xml": {
                return APPLICATION_XML_TYPE;
            }
            case "application/json": {
                return APPLICATION_JSON_TYPE;
            }
            case "application/x-yaml": {
                return APPLICATION_YAML_TYPE;
            }
            case "text/xml": {
                return TEXT_XML_TYPE;
            }
            case "text/json": {
                return TEXT_JSON_TYPE;
            }
            case "text/plain": {
                return TEXT_PLAIN_TYPE;
            }
            case "application/hal+json": {
                return APPLICATION_HAL_JSON_TYPE;
            }
            case "application/hal+xml": {
                return APPLICATION_HAL_XML_TYPE;
            }
            case "application/atom+xml": {
                return APPLICATION_ATOM_XML_TYPE;
            }
            case "application/vnd.error+json": {
                return APPLICATION_VND_ERROR_TYPE;
            }
            case "text/event-stream": {
                return TEXT_EVENT_STREAM_TYPE;
            }
            case "application/x-json-stream": {
                return APPLICATION_JSON_STREAM_TYPE;
            }
            case "application/octet-stream": {
                return APPLICATION_OCTET_STREAM_TYPE;
            }
            case "application/graphql": {
                return APPLICATION_GRAPHQL_TYPE;
            }
            case "application/pdf": {
                return APPLICATION_PDF_TYPE;
            }
            case "image/png": {
                return IMAGE_PNG_TYPE;
            }
            case "image/jpeg": {
                return IMAGE_JPEG_TYPE;
            }
            case "image/gif": {
                return IMAGE_GIF_TYPE;
            }
            case "image/webp": {
                return IMAGE_WEBP_TYPE;
            }
        }
        return new MediaType(mediaType);
    }

    public boolean matches(@NonNull MediaType expectedContentType) {
        if (expectedContentType == null) {
            return false;
        }
        if (expectedContentType == this) {
            return true;
        }
        String expectedType = expectedContentType.getType();
        String expectedSubtype = expectedContentType.getSubtype();
        boolean typeMatch = this.type.equals("*") || this.type.equalsIgnoreCase(expectedType);
        boolean subtypeMatch = this.subtype.equals("*") || this.subtype.equalsIgnoreCase(expectedSubtype);
        return typeMatch && subtypeMatch;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getExtension() {
        return this.extension;
    }

    public OptionalValues<String> getParameters() {
        return OptionalValues.of(String.class, this.parameters);
    }

    public String getQuality() {
        return this.qualityNumberField.toString();
    }

    public BigDecimal getQualityAsNumber() {
        return this.qualityNumberField;
    }

    public String getVersion() {
        return this.parameters.getOrDefault(V_PARAMETER, null);
    }

    public Optional<Charset> getCharset() {
        return this.getParameters().get((CharSequence)CHARSET_PARAMETER).map(Charset::forName);
    }

    @Override
    public int length() {
        return this.strRepr.length();
    }

    @Override
    public char charAt(int index) {
        return this.strRepr.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.strRepr.subSequence(start, end);
    }

    public boolean isTextBased() {
        boolean matches = textTypePatterns.stream().anyMatch(p -> p.matcher(this.name).matches());
        if (!matches) {
            matches = this.subtype.equalsIgnoreCase(EXTENSION_JSON) || this.subtype.equalsIgnoreCase(EXTENSION_XML) || this.subtype.equalsIgnoreCase("x-yaml");
        }
        return matches;
    }

    public static boolean isTextBased(String contentType) {
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            return false;
        }
        try {
            return MediaType.of(contentType).isTextBased();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Internal
    public void validate(Runnable r) {
        if (!this.valid) {
            r.run();
            this.valid = true;
        }
    }

    @Override
    public String toString() {
        return this.strRepr;
    }

    private String toString0() {
        if (this.parameters.isEmpty()) {
            return this.name;
        }
        StringBuilder sb = new StringBuilder(this.name);
        this.parameters.forEach((name, value) -> {
            sb.append(";");
            sb.append((CharSequence)name);
            sb.append("=");
            sb.append((String)value);
        });
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType mediaType = (MediaType)o;
        return this.lowerName.equals(mediaType.lowerName);
    }

    public int hashCode() {
        return this.lowerName.hashCode();
    }

    public static List<MediaType> orderedOf(CharSequence ... values) {
        return MediaType.orderedOf(Arrays.asList(values));
    }

    public static List<MediaType> orderedOf(List<? extends CharSequence> values) {
        String singleHeader;
        if (values == null) {
            return Collections.emptyList();
        }
        int headerCount = values.size();
        if (headerCount == 0) {
            return Collections.emptyList();
        }
        if (headerCount == 1 && (singleHeader = values.get(0).toString()).indexOf(44) == -1) {
            try {
                return List.of(MediaType.of(singleHeader));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        for (CharSequence charSequence : values) {
            for (String token : StringUtils.splitOmitEmptyStrings((CharSequence)charSequence, (char)',')) {
                try {
                    mediaTypes.add(MediaType.of(token));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        mediaTypes.sort((o1, o2) -> {
            if (o1.type.equals("*")) {
                return 1;
            }
            if (o2.type.equals("*")) {
                return -1;
            }
            if (o2.subtype.equals("*") && !o1.subtype.equals("*")) {
                return -1;
            }
            if (o1.subtype.equals("*") && !o2.subtype.equals("*")) {
                return 1;
            }
            return o2.getQualityAsNumber().compareTo(o1.getQualityAsNumber());
        });
        return Collections.unmodifiableList(mediaTypes);
    }

    public static MediaType of(CharSequence mediaType) {
        return MediaType.of(mediaType.toString());
    }

    public static MediaType[] of(CharSequence ... mediaType) {
        MediaType[] types = new MediaType[mediaType.length];
        for (int i = 0; i < mediaType.length; ++i) {
            types[i] = MediaType.of(mediaType[i].toString());
        }
        return types;
    }

    public static Optional<MediaType> fromType(Class<?> type) {
        Object[] value;
        Produces producesAnn = type.getAnnotation(Produces.class);
        if (producesAnn != null && ArrayUtils.isNotEmpty((Object[])(value = producesAnn.value()))) {
            return Optional.of(MediaType.of((String)value[0]));
        }
        return Optional.empty();
    }

    public static Optional<MediaType> forExtension(String extension) {
        String type;
        Map<String, String> extensions;
        if (StringUtils.isNotEmpty((CharSequence)extension) && (extensions = MediaType.getMediaTypeFileExtensions()) != null && (type = extensions.get(extension)) != null) {
            return Optional.of(new MediaType(type, extension));
        }
        return Optional.empty();
    }

    public static MediaType forFilename(String filename) {
        if (StringUtils.isNotEmpty((CharSequence)filename)) {
            return MediaType.forExtension(NameUtils.extension((String)filename)).orElse(TEXT_PLAIN_TYPE);
        }
        return TEXT_PLAIN_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> getMediaTypeFileExtensions() {
        Map<String, String> extensions = mediaTypeFileExtensions;
        if (extensions != null) return extensions;
        Class<MediaType> clazz = MediaType.class;
        synchronized (MediaType.class) {
            extensions = mediaTypeFileExtensions;
            if (extensions != null) return extensions;
            try {
                mediaTypeFileExtensions = extensions = MediaType.loadMimeTypes();
            }
            catch (Exception e) {
                mediaTypeFileExtensions = Collections.emptyMap();
            }
            return extensions;
        }
    }

    private static Map<String, String> loadMimeTypes() {
        LinkedHashMap<String, String> linkedHashMap;
        block11: {
            InputStream is = MediaType.class.getClassLoader().getResourceAsStream(MIME_TYPES_FILE_NAME);
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.US_ASCII));
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(100);
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty() || line.charAt(0) == '#') continue;
                    String formattedLine = line.trim().replaceAll("\\s{2,}", " ").replaceAll("\\s", "|");
                    String[] tokens = formattedLine.split("\\|");
                    for (int i = 1; i < tokens.length; ++i) {
                        String fileExtension = tokens[i].toLowerCase(Locale.ENGLISH);
                        result.put(fileExtension, tokens[0]);
                    }
                }
                linkedHashMap = result;
                if (is == null) break block11;
            }
            catch (Throwable reader) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            reader.addSuppressed(throwable);
                        }
                    }
                    throw reader;
                }
                catch (IOException ex) {
                    Logger logger = LoggerFactory.getLogger(MediaType.class);
                    if (logger.isWarnEnabled()) {
                        logger.warn("Failed to load mime types for file extension detection!");
                    }
                    return Collections.emptyMap();
                }
            }
            is.close();
        }
        return linkedHashMap;
    }

    static {
        FORM = APPLICATION_FORM_URLENCODED_TYPE = new MediaType(APPLICATION_FORM_URLENCODED);
        MULTIPART_FORM_DATA_TYPE = new MediaType(MULTIPART_FORM_DATA);
        TEXT_HTML_TYPE = new MediaType(TEXT_HTML);
        TEXT_CSV_TYPE = new MediaType(TEXT_CSV);
        APPLICATION_XHTML_TYPE = new MediaType(APPLICATION_XHTML, "html");
        APPLICATION_XML_TYPE = new MediaType(APPLICATION_XML);
        APPLICATION_JSON_TYPE = new MediaType(APPLICATION_JSON);
        APPLICATION_YAML_TYPE = new MediaType(APPLICATION_YAML);
        MICROSOFT_EXCEL_OPEN_XML_TYPE = new MediaType(MICROSOFT_EXCEL_OPEN_XML, EXTENSION_XLSX);
        MICROSOFT_EXCEL_TYPE = new MediaType(MICROSOFT_EXCEL, EXTENSION_XLS);
        TEXT_XML_TYPE = new MediaType(TEXT_XML);
        TEXT_JSON_TYPE = new MediaType(TEXT_JSON);
        TEXT_PLAIN_TYPE = new MediaType(TEXT_PLAIN);
        APPLICATION_HAL_JSON_TYPE = new MediaType(APPLICATION_HAL_JSON);
        APPLICATION_HAL_XML_TYPE = new MediaType(APPLICATION_HAL_XML);
        APPLICATION_ATOM_XML_TYPE = new MediaType(APPLICATION_ATOM_XML);
        APPLICATION_VND_ERROR_TYPE = new MediaType(APPLICATION_VND_ERROR);
        TEXT_EVENT_STREAM_TYPE = new MediaType(TEXT_EVENT_STREAM);
        APPLICATION_JSON_STREAM_TYPE = new MediaType(APPLICATION_JSON_STREAM);
        APPLICATION_OCTET_STREAM_TYPE = new MediaType(APPLICATION_OCTET_STREAM);
        APPLICATION_GRAPHQL_TYPE = new MediaType(APPLICATION_GRAPHQL);
        APPLICATION_PDF_TYPE = new MediaType(APPLICATION_PDF);
        IMAGE_PNG_TYPE = new MediaType(IMAGE_PNG);
        IMAGE_JPEG_TYPE = new MediaType(IMAGE_JPEG);
        IMAGE_GIF_TYPE = new MediaType(IMAGE_GIF);
        IMAGE_WEBP_TYPE = new MediaType(IMAGE_WEBP);
        ARGUMENT = Argument.of(MediaType.class);
        CONVERSION_CONTEXT = ImmutableArgumentConversionContext.of(ARGUMENT);
        textTypePatterns = new ArrayList<Pattern>(4);
        textTypePatterns.add(Pattern.compile("^text/.*$"));
        textTypePatterns.add(Pattern.compile("^.*\\+json$"));
        textTypePatterns.add(Pattern.compile("^.*\\+text$"));
        textTypePatterns.add(Pattern.compile("^.*\\+xml$"));
        textTypePatterns.add(Pattern.compile("^application/javascript$"));
    }
}

