/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.RawMessageBodyHandler;
import io.micronaut.http.body.RawMessageBodyHandlerRegistry;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

@Singleton
@BootstrapContextCompatible
public final class DefaultMessageBodyHandlerRegistry
extends RawMessageBodyHandlerRegistry {
    private final BeanContext beanLocator;

    DefaultMessageBodyHandlerRegistry(BeanContext beanLocator, List<RawMessageBodyHandler<?>> rawHandlers) {
        super(rawHandlers);
        this.beanLocator = beanLocator;
    }

    @Override
    protected <T> MessageBodyReader<T> findReaderImpl(Argument<T> type, List<MediaType> mediaTypes) {
        Collection beanDefinitions = this.beanLocator.getBeanDefinitions(Argument.of(MessageBodyReader.class, (Argument[])new Argument[]{type}), new MediaTypeQualifier(type, mediaTypes, Consumes.class));
        if (beanDefinitions.size() == 1) {
            return (MessageBodyReader)this.beanLocator.getBean((BeanDefinition)beanDefinitions.iterator().next());
        }
        List<BeanDefinition> exactMatch = beanDefinitions.stream().filter(d -> {
            List typeArguments = d.getTypeArguments(MessageBodyReader.class);
            if (typeArguments.isEmpty()) {
                return false;
            }
            return type.equalsType((Argument)typeArguments.get(0));
        }).toList();
        if (exactMatch.size() == 1) {
            return (MessageBodyReader)this.beanLocator.getBean(exactMatch.iterator().next());
        }
        return OrderUtil.sort(beanDefinitions.stream()).findFirst().map(arg_0 -> ((BeanContext)this.beanLocator).getBean(arg_0)).orElse(null);
    }

    @Override
    protected <T> MessageBodyWriter<T> findWriterImpl(Argument<T> type, List<MediaType> mediaTypes) {
        Collection beanDefinitions = this.beanLocator.getBeanDefinitions(Argument.of(MessageBodyWriter.class, (Argument[])new Argument[]{type}), new MediaTypeQualifier(type, mediaTypes, Produces.class));
        if (beanDefinitions.size() == 1) {
            return (MessageBodyWriter)this.beanLocator.getBean((BeanDefinition)beanDefinitions.iterator().next());
        }
        List<BeanDefinition> exactMatch = beanDefinitions.stream().filter(d -> {
            List typeArguments = d.getTypeArguments(MessageBodyWriter.class);
            if (typeArguments.isEmpty()) {
                return false;
            }
            return type.equalsType((Argument)typeArguments.get(0));
        }).toList();
        if (exactMatch.size() == 1) {
            return (MessageBodyWriter)this.beanLocator.getBean(exactMatch.iterator().next());
        }
        return OrderUtil.sort(beanDefinitions.stream()).findFirst().map(arg_0 -> ((BeanContext)this.beanLocator).getBean(arg_0)).orElse(null);
    }

    private record MediaTypeQualifier<T>(Argument<?> type, List<MediaType> mediaTypes, Class<? extends Annotation> annotationType) implements Qualifier<T>
    {
        public <B extends BeanType<T>> Stream<B> reduce(Class<T> beanType, Stream<B> candidates) {
            return candidates.filter(c -> {
                String[] applicableTypes = c.getAnnotationMetadata().stringValues(this.annotationType);
                return applicableTypes.length == 0 || Arrays.stream(applicableTypes).anyMatch(mt -> this.mediaTypes.contains(new MediaType((String)mt)));
            });
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MediaTypeQualifier that = (MediaTypeQualifier)o;
            return this.type.equalsType(that.type) && this.mediaTypes.equals(that.mediaTypes);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.type.typeHashCode(), this.mediaTypes);
        }
    }
}

