/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.util.Toggleable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.filter.FilterOrder;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.reactive.execution.ReactiveExecutionFlow;
import java.util.concurrent.Executor;
import org.reactivestreams.Publisher;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface GenericHttpFilter {
    default public boolean isSuspended() {
        return false;
    }

    default public boolean isFiltersException() {
        return false;
    }

    @Internal
    @FunctionalInterface
    public static interface Terminal
    extends GenericHttpFilter {
        public ExecutionFlow<? extends HttpResponse<?>> execute(HttpRequest<?> var1) throws Exception;
    }

    @Internal
    public static final class TerminalReactive
    implements Terminal {
        private final Publisher<? extends HttpResponse<?>> responsePublisher;

        public TerminalReactive(Publisher<? extends HttpResponse<?>> responsePublisher) {
            this.responsePublisher = responsePublisher;
        }

        @Override
        public ExecutionFlow<? extends HttpResponse<?>> execute(HttpRequest<?> request) throws Exception {
            return ReactiveExecutionFlow.fromPublisher(this.responsePublisher);
        }
    }

    @Internal
    public record AroundLegacy(HttpFilter bean, FilterOrder order) implements GenericHttpFilter,
    Ordered
    {
        @Override
        public boolean isSuspended() {
            return true;
        }

        @Override
        public boolean isFiltersException() {
            return false;
        }

        public boolean isEnabled() {
            Toggleable t;
            HttpFilter httpFilter = this.bean;
            return !(httpFilter instanceof Toggleable) || (t = (Toggleable)httpFilter).isEnabled();
        }

        public int getOrder() {
            return this.order.getOrder(this.bean);
        }
    }

    @Internal
    public record Async(GenericHttpFilter actual, Executor executor) implements GenericHttpFilter,
    Ordered
    {
        @Override
        public boolean isSuspended() {
            return this.actual.isSuspended();
        }

        @Override
        public boolean isFiltersException() {
            return this.actual.isFiltersException();
        }

        public int getOrder() {
            return ((Ordered)this.actual).getOrder();
        }
    }
}

