/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.DynamicMessageBodyWriter;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.sse.Event;
import jakarta.inject.Singleton;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;

@Internal
@Singleton
@Produces(value={"text/event-stream"})
@Consumes(value={"text/event-stream"})
final class TextStreamBodyWriter<T>
implements MessageBodyWriter<T> {
    private static final byte[] DATA_PREFIX = "data: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] EVENT_PREFIX = "event: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ID_PREFIX = "id: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] RETRY_PREFIX = "retry: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COMMENT_PREFIX = ": ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] NEWLINE = "\n".getBytes(StandardCharsets.UTF_8);
    private static final List<MediaType> JSON_TYPE_LIST = List.of(MediaType.APPLICATION_JSON_TYPE);
    private final Supplier<MessageBodyWriter<Object>> jsonWriter;

    TextStreamBodyWriter(MessageBodyHandlerRegistry registry) {
        this(SupplierUtil.memoized(() -> registry.findWriter(Argument.OBJECT_ARGUMENT, JSON_TYPE_LIST).orElse(new DynamicMessageBodyWriter(registry, JSON_TYPE_LIST))));
    }

    private TextStreamBodyWriter(Supplier<MessageBodyWriter<Object>> jsonWriter) {
        this.jsonWriter = jsonWriter;
    }

    @Override
    public MessageBodyWriter<T> createSpecific(Argument<T> type) {
        return new TextStreamBodyWriter<T>(SupplierUtil.memoized(() -> this.jsonWriter.get().createSpecific(TextStreamBodyWriter.getBodyType(type))));
    }

    @NonNull
    private static Argument<Object> getBodyType(Argument<?> type) {
        if (type.getType() == Event.class) {
            return type.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
        }
        return type;
    }

    @Override
    public ByteBuffer<?> writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
        byte[] body;
        Event e;
        Event event = object instanceof Event ? (e = (Event)object) : Event.of(object);
        Object t = event.getData();
        if (t instanceof CharSequence) {
            CharSequence s = (CharSequence)t;
            body = s.toString().getBytes(StandardCharsets.UTF_8);
        } else {
            ByteBuffer<?> buf = this.jsonWriter.get().writeTo(TextStreamBodyWriter.getBodyType(type), MediaType.APPLICATION_JSON_TYPE, event.getData(), outgoingHeaders, bufferFactory);
            body = buf.toByteArray();
            if (buf instanceof ReferenceCounted) {
                ReferenceCounted rc = (ReferenceCounted)buf;
                rc.release();
            }
        }
        ByteBuffer eventData = bufferFactory.buffer(body.length + 10);
        TextStreamBodyWriter.writeAttribute(eventData, COMMENT_PREFIX, event.getComment());
        TextStreamBodyWriter.writeAttribute(eventData, ID_PREFIX, event.getId());
        TextStreamBodyWriter.writeAttribute(eventData, EVENT_PREFIX, event.getName());
        Duration retry = event.getRetry();
        if (retry != null) {
            TextStreamBodyWriter.writeAttribute(eventData, RETRY_PREFIX, String.valueOf(retry.toMillis()));
        }
        int start = 0;
        while (start < body.length) {
            int end = TextStreamBodyWriter.indexOf(body, (byte)10, start);
            if (end == -1) {
                end = body.length - 1;
            }
            eventData.write(DATA_PREFIX).write(body, start, end - start + 1);
            start = end + 1;
        }
        eventData.write(NEWLINE).write(NEWLINE);
        return eventData;
    }

    @Override
    public void writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        throw new UnsupportedOperationException();
    }

    private static int indexOf(byte[] haystack, byte needle, int start) {
        for (int i = start; i < haystack.length; ++i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }

    private static void writeAttribute(ByteBuffer eventData, byte[] attribute, String value) {
        if (value != null) {
            eventData.write(attribute).write((CharSequence)value, StandardCharsets.UTF_8).write(NEWLINE);
        }
    }
}

