/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.io.IOUtils;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.MessageBodyHandler;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import jakarta.inject.Singleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
@Singleton
public final class TextPlainHandler
implements MessageBodyHandler<CharSequence> {
    @Override
    public boolean isReadable(Argument<CharSequence> type, MediaType mediaType) {
        return true;
    }

    @Override
    public void writeTo(Argument<CharSequence> type, MediaType mediaType, CharSequence object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        if (!outgoingHeaders.contains("Content-Type")) {
            outgoingHeaders.set((CharSequence)"Content-Type", (CharSequence)mediaType);
        }
        try {
            outputStream.write(object.toString().getBytes(MessageBodyWriter.getCharset((Headers)outgoingHeaders)));
        }
        catch (IOException e) {
            throw new CodecException("Error writing body text: " + e.getMessage(), e);
        }
    }

    @Override
    public String read(Argument<CharSequence> type, MediaType mediaType, Headers httpHeaders, InputStream inputStream) throws CodecException {
        try {
            return IOUtils.readText((BufferedReader)new BufferedReader(new InputStreamReader(inputStream, MessageBodyWriter.getCharset(httpHeaders))));
        }
        catch (IOException e) {
            throw new CodecException("Error reading body text: " + e.getMessage(), e);
        }
    }

    @Override
    public String read(Argument<CharSequence> type, MediaType mediaType, Headers httpHeaders, ByteBuffer<?> byteBuffer) throws CodecException {
        return byteBuffer.toString(MessageBodyWriter.getCharset(httpHeaders));
    }
}

