/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.order.Ordered;
import io.micronaut.http.filter.FilterContext;
import io.micronaut.http.filter.GenericHttpFilter;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
interface InternalHttpFilter
extends GenericHttpFilter,
Ordered {
    public boolean isFiltersRequest();

    public boolean isFiltersResponse();

    @NonNull
    default public ExecutionFlow<FilterContext> processRequestFilter(@NonNull FilterContext context, @NonNull Function<FilterContext, ExecutionFlow<FilterContext>> downstream) {
        if (!this.isFiltersRequest()) {
            throw new IllegalStateException("Filtering request is not supported!");
        }
        return downstream.apply(context);
    }

    @NonNull
    default public ExecutionFlow<FilterContext> processResponseFilter(@NonNull FilterContext context, @NonNull Throwable exceptionToFilter) {
        if (!this.isFiltersResponse()) {
            throw new IllegalStateException("Filtering response is not supported!");
        }
        return ExecutionFlow.just((Object)context);
    }
}

