/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.filter.FilterContext;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.filter.InternalHttpFilter;
import java.util.List;
import java.util.ListIterator;

@Internal
public class FilterRunner {
    private final List<InternalHttpFilter> filters;
    private final PropagatedContext initialPropagatedContext = PropagatedContext.getOrEmpty();

    public FilterRunner(List<GenericHttpFilter> filters) {
        this.filters = filters;
    }

    private static void checkOrdered(List<? extends GenericHttpFilter> filters) {
        if (!filters.stream().allMatch(f -> f instanceof Ordered)) {
            throw new IllegalStateException("Some filters cannot be ordered: " + filters);
        }
    }

    public static void sort(@NonNull List<GenericHttpFilter> filters) {
        FilterRunner.checkOrdered(filters);
        OrderUtil.sort(filters);
    }

    public static void sortReverse(@NonNull List<GenericHttpFilter> filters) {
        FilterRunner.checkOrdered(filters);
        OrderUtil.reverseSort(filters);
    }

    protected ExecutionFlow<? extends HttpResponse<?>> processResponse(HttpRequest<?> request, HttpResponse<?> response, PropagatedContext propagatedContext) {
        return ExecutionFlow.just(response);
    }

    protected ExecutionFlow<? extends HttpResponse<?>> processFailure(HttpRequest<?> request, Throwable failure, PropagatedContext propagatedContext) {
        return ExecutionFlow.error((Throwable)failure);
    }

    public final ExecutionFlow<MutableHttpResponse<?>> run(HttpRequest<?> request) {
        return this.filterRequest(new FilterContext(request, this.initialPropagatedContext), this.filters.listIterator());
    }

    private ExecutionFlow<HttpResponse<?>> filterRequest(FilterContext context, ListIterator<InternalHttpFilter> iterator) {
        return this.filterRequest0(context, iterator).flatMap(newContext -> {
            if (newContext.response() != null) {
                return this.filterResponse((FilterContext)newContext, iterator, null);
            }
            return ExecutionFlow.error((Throwable)new IllegalStateException("Request filters didn't produce any response!"));
        });
    }

    private ExecutionFlow<FilterContext> filterRequest0(FilterContext context, ListIterator<InternalHttpFilter> iterator) {
        if (context.response() != null) {
            return ExecutionFlow.just((Object)context);
        }
        if (iterator.hasNext()) {
            InternalHttpFilter filter = iterator.next();
            return (filter.isFiltersRequest() ? filter.processRequestFilter(context, newContext -> this.filterRequest0((FilterContext)newContext, iterator)) : this.filterRequest0(context, iterator)).onErrorResume(throwable -> this.processFailure(context.request(), (Throwable)throwable, context.propagatedContext()).map(context::withResponse).onErrorResume(throwable2 -> this.filterResponse(context, iterator, (Throwable)throwable2).map(context::withResponse)));
        }
        return ExecutionFlow.just((Object)context);
    }

    private ExecutionFlow<HttpResponse<?>> filterResponse(FilterContext context, ListIterator<InternalHttpFilter> iterator, @Nullable Throwable exception) {
        if (iterator.hasPrevious()) {
            InternalHttpFilter filter = iterator.previous();
            return (filter.isFiltersResponse() ? filter.processResponseFilter(context, exception) : ExecutionFlow.just((Object)context)).flatMap(newContext -> {
                if (context != newContext) {
                    return this.processResponse(newContext.request(), newContext.response(), newContext.propagatedContext()).map(newContext::withResponse);
                }
                return ExecutionFlow.just((Object)newContext);
            }).onErrorResume(throwable -> this.processFailure(context.request(), (Throwable)throwable, context.propagatedContext()).map(context::withResponse)).flatMap(newContext -> this.filterResponse((FilterContext)newContext, iterator, newContext.response() == null ? exception : null));
        }
        if (context.response() != null) {
            return ExecutionFlow.just(context.response());
        }
        if (exception != null) {
            return ExecutionFlow.error((Throwable)exception);
        }
        return ExecutionFlow.error((Throwable)new IllegalStateException("No response after response filters completed!"));
    }
}

