/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.context.BeanContext;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.ServerHttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ResponseFilter;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.InternalByteBody;
import io.micronaut.http.filter.AsyncFilter;
import io.micronaut.http.filter.FilterOrder;
import io.micronaut.http.filter.FilterPatternStyle;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.filter.InternalHttpFilter;
import io.micronaut.http.filter.MethodFilter;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.scheduling.annotation.ExecuteOn;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

@Internal
public abstract class BaseFilterProcessor<A extends Annotation>
implements ExecutableMethodProcessor<A> {
    private static final Set<String> PERMITTED_BINDING_ANNOTATIONS = Set.of(Body.class.getName(), Header.class.getName(), QueryValue.class.getName(), CookieValue.class.getName());
    @Nullable
    private final BeanContext beanContext;
    private final Class<A> filterAnnotation;
    private final RequestBinderRegistry argumentBinderRegistry;

    public BaseFilterProcessor(@Nullable BeanContext beanContext, Class<A> filterAnnotation) {
        this.beanContext = beanContext;
        this.filterAnnotation = filterAnnotation;
        final Optional requestBinderRegistry = beanContext != null ? beanContext.findBean(RequestBinderRegistry.class) : Optional.empty();
        this.argumentBinderRegistry = new RequestBinderRegistry(){

            public <T> Optional<ArgumentBinder<T, HttpRequest<?>>> findArgumentBinder(Argument<T> argument) {
                Class annotation = argument.getAnnotationMetadata().getAnnotationTypeByStereotype(Bindable.class).orElse(null);
                if (annotation != null && PERMITTED_BINDING_ANNOTATIONS.contains(annotation.getName())) {
                    if (annotation == Body.class) {
                        return Optional.of((context, source) -> {
                            if (source instanceof ServerHttpRequest) {
                                ServerHttpRequest fullHttpRequest = (ServerHttpRequest)source;
                                return InternalByteBody.bufferFlow(fullHttpRequest.byteBody().split(ByteBody.SplitBackpressureMode.FASTEST)).map(imm -> {
                                    Argument t = context.getArgument();
                                    if (t.isAssignableFrom(ByteBuffer.class)) {
                                        return () -> Optional.of(imm.toByteBuffer());
                                    }
                                    if (t.isAssignableFrom(byte[].class)) {
                                        byte[] bytes = imm.toByteArray();
                                        return () -> Optional.of(bytes);
                                    }
                                    if (t.isAssignableFrom(String.class)) {
                                        String str = imm.toString(StandardCharsets.UTF_8);
                                        return () -> Optional.of(str);
                                    }
                                    return ArgumentBinder.BindingResult.UNSATISFIED;
                                });
                            }
                            return ExecutionFlow.just((Object)ArgumentBinder.BindingResult.UNSATISFIED);
                        });
                    }
                    return requestBinderRegistry.flatMap(registry -> registry.findArgumentBinder(argument));
                }
                return Optional.empty();
            }
        };
    }

    public void process(BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        this.process0(beanDefinition, method);
    }

    protected abstract void addFilter(Supplier<GenericHttpFilter> var1, AnnotationMetadata var2, FilterMetadata var3);

    private <T> void process0(BeanDefinition<T> beanDefinition, ExecutableMethod<T, ?> method) {
        if (this.beanContext != null) {
            FilterMetadata combined;
            FilterMetadata methodLevel;
            FilterMetadata beanLevel = this.metadata((AnnotationMetadata)beanDefinition, (Class<? extends Annotation>)this.filterAnnotation);
            if (method.isAnnotationPresent(RequestFilter.class)) {
                methodLevel = this.metadata((AnnotationMetadata)method, (Class<? extends Annotation>)RequestFilter.class);
                combined = this.combineMetadata(beanLevel, methodLevel);
                this.addFilter(() -> this.withAsync(combined, MethodFilter.prepareFilterMethod(this.beanContext.getConversionService(), this.beanContext.getBean(beanDefinition), method, false, combined.order, this.argumentBinderRegistry)), (AnnotationMetadata)method, combined);
            }
            if (method.isAnnotationPresent(ResponseFilter.class)) {
                methodLevel = this.metadata((AnnotationMetadata)method, (Class<? extends Annotation>)ResponseFilter.class);
                combined = this.combineMetadata(beanLevel, methodLevel);
                this.addFilter(() -> this.withAsync(combined, MethodFilter.prepareFilterMethod(this.beanContext.getConversionService(), this.beanContext.getBean(beanDefinition), method, true, combined.order, this.argumentBinderRegistry)), (AnnotationMetadata)method, combined);
            }
        }
    }

    private GenericHttpFilter withAsync(FilterMetadata metadata, GenericHttpFilter filter) {
        if (metadata.executeOn != null) {
            return new AsyncFilter((InternalHttpFilter)filter, (Executor)this.beanContext.getBean(Executor.class, Qualifiers.byName((String)metadata.executeOn)));
        }
        return filter;
    }

    private FilterMetadata combineMetadata(FilterMetadata beanLevel, FilterMetadata methodLevel) {
        List<String> patterns;
        if (beanLevel.patterns == null) {
            patterns = methodLevel.patterns;
        } else if (methodLevel.patterns == null) {
            patterns = beanLevel.patterns;
        } else {
            if (beanLevel.patternStyle == FilterPatternStyle.REGEX || methodLevel.patternStyle == FilterPatternStyle.REGEX) {
                throw new UnsupportedOperationException("Concatenating regex filter patterns is not supported. Please declare the full pattern on the method instead.");
            }
            patterns = beanLevel.patterns.stream().flatMap(p1 -> methodLevel.patterns.stream().map(p2 -> BaseFilterProcessor.concatAntPatterns(p1, p2))).toList();
        }
        if (patterns != null && (beanLevel.appendContextPath == null || beanLevel.appendContextPath.booleanValue())) {
            patterns = this.prependContextPath(patterns);
        }
        FilterOrder order = methodLevel.order != null ? methodLevel.order : (beanLevel.order != null ? new FilterOrder.Dynamic(((FilterOrder.Fixed)beanLevel.order).value()) : new FilterOrder.Dynamic(Integer.MAX_VALUE));
        return new FilterMetadata(methodLevel.patterns == null ? beanLevel.patternStyle : methodLevel.patternStyle, patterns, methodLevel.methods == null ? beanLevel.methods : methodLevel.methods, order, methodLevel.executeOn == null ? beanLevel.executeOn : methodLevel.executeOn, beanLevel.serviceId, beanLevel.excludeServiceId, beanLevel.appendContextPath);
    }

    @NonNull
    protected List<String> prependContextPath(@NonNull List<String> patterns) {
        return patterns;
    }

    static String concatAntPatterns(String p1, String p2) {
        StringBuilder combined = new StringBuilder(p1.length() + p2.length() + 1);
        combined.append(p1);
        if (!p1.endsWith("/")) {
            combined.append("/");
        }
        if (p2.startsWith("/")) {
            combined.append(p2, "/".length(), p2.length());
        } else {
            combined.append(p2);
        }
        return combined.toString();
    }

    private FilterMetadata metadata(AnnotationMetadata annotationMetadata, Class<? extends Annotation> annotationType) {
        Object[] methods = (HttpMethod[])annotationMetadata.enumValues(annotationType, "methods", HttpMethod.class);
        Object[] patterns = annotationMetadata.stringValues(annotationType);
        OptionalInt order = annotationMetadata.intValue(Order.class);
        Object[] serviceId = annotationMetadata.stringValues(annotationType, "serviceId");
        Object[] excludeServiceId = annotationMetadata.stringValues(annotationType, "excludeServiceId");
        Optional appendContextPath = annotationMetadata.booleanValue(annotationType, "appendContextPath");
        return new FilterMetadata(annotationMetadata.enumValue(annotationType, "patternStyle", FilterPatternStyle.class).orElse(FilterPatternStyle.ANT), ArrayUtils.isNotEmpty((Object[])patterns) ? Arrays.asList(patterns) : null, ArrayUtils.isNotEmpty((Object[])methods) ? Arrays.asList(methods) : null, order.isPresent() ? new FilterOrder.Fixed(order.getAsInt()) : null, annotationMetadata.stringValue(ExecuteOn.class).orElse(null), ArrayUtils.isNotEmpty((Object[])serviceId) ? Arrays.asList(serviceId) : null, ArrayUtils.isNotEmpty((Object[])excludeServiceId) ? Arrays.asList(excludeServiceId) : null, appendContextPath.orElse(null));
    }

    protected record FilterMetadata(FilterPatternStyle patternStyle, @Nullable List<String> patterns, @Nullable List<HttpMethod> methods, @Nullable FilterOrder order, @Nullable String executeOn, @Nullable List<String> serviceId, @Nullable List<String> excludeServiceId, @Nullable Boolean appendContextPath) {
    }

    public static interface AsyncBodyBinder<T>
    extends ArgumentBinder<T, HttpRequest<?>> {
        default public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
            throw new UnsupportedOperationException();
        }

        public ExecutionFlow<ArgumentBinder.BindingResult<T>> bindAsync(ArgumentConversionContext<T> var1, HttpRequest<?> var2);
    }
}

