/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.aries;

import com.google.gson.Gson;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.hyperledger.aries.config.GsonConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientFactory {
    static final Logger log = LoggerFactory.getLogger(HttpClientFactory.class);

    private HttpClientFactory() {
    }

    public static OkHttpClient createHttpClient() {
        return new OkHttpClient.Builder().writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).connectTimeout(60L, TimeUnit.SECONDS).callTimeout(60L, TimeUnit.SECONDS).addInterceptor((Interceptor)HttpClientFactory.defaultLoggingInterceptor()).build();
    }

    public static HttpLoggingInterceptor defaultLoggingInterceptor() {
        Gson gson = GsonConfig.defaultConfig();
        Gson pretty = GsonConfig.prettyPrinter();
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor(msg -> {
            if (log.isTraceEnabled() && StringUtils.isNotEmpty((CharSequence)msg)) {
                if (msg.startsWith("{")) {
                    Object json = gson.fromJson(msg, Object.class);
                    log.trace("\n{}", (Object)pretty.toJson(json));
                } else {
                    log.trace("{}", (Object)msg);
                }
            }
        });
        interceptor.level(HttpLoggingInterceptor.Level.BODY);
        interceptor.redactHeader("Authorization");
        interceptor.redactHeader("X-API-Key");
        return interceptor;
    }
}

