/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.aries.wallet;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.nessus.aries.AriesClientFactory;
import io.nessus.aries.util.SafeConsumer;
import io.nessus.aries.wallet.NessusWallet;
import io.nessus.aries.wallet.WalletRegistry;
import java.io.IOException;
import java.util.Objects;
import org.hyperledger.aries.AriesClient;
import org.hyperledger.aries.api.connection.ConnectionRecord;
import org.hyperledger.aries.api.discover_features.DiscoverFeatureEvent;
import org.hyperledger.aries.api.endorser.EndorseTransactionRecord;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialExchange;
import org.hyperledger.aries.api.issue_credential_v2.V20CredExRecord;
import org.hyperledger.aries.api.issue_credential_v2.V2IssueIndyCredentialEvent;
import org.hyperledger.aries.api.issue_credential_v2.V2IssueLDCredentialEvent;
import org.hyperledger.aries.api.message.BasicMessage;
import org.hyperledger.aries.api.message.ProblemReport;
import org.hyperledger.aries.api.multitenancy.WalletRecord;
import org.hyperledger.aries.api.present_proof.PresentationExchangeRecord;
import org.hyperledger.aries.api.present_proof_v2.V20PresExRecord;
import org.hyperledger.aries.api.revocation.RevocationEvent;
import org.hyperledger.aries.api.revocation.RevocationNotificationEvent;
import org.hyperledger.aries.api.settings.Settings;
import org.hyperledger.aries.api.trustping.PingEvent;
import org.hyperledger.aries.config.GsonConfig;
import org.hyperledger.aries.webhook.EventParser;
import org.hyperledger.aries.webhook.EventType;
import org.hyperledger.aries.webhook.IEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventHandler
implements IEventHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Gson pretty = GsonConfig.prettyPrinter();
    private final EventParser parser = new EventParser();
    private final WalletRegistry walletRegistry;
    private WalletRecord thisWallet;

    public DefaultEventHandler(WalletRecord thisWallet, WalletRegistry walletRegistry) {
        Objects.nonNull(thisWallet);
        this.walletRegistry = walletRegistry;
        this.thisWallet = thisWallet;
    }

    public WalletRecord getWallet(String walletId) {
        NessusWallet result = null;
        if (this.walletRegistry != null) {
            result = this.walletRegistry.getWallet(walletId);
        }
        return result;
    }

    public String getWalletName(String walletId) {
        WalletRecord wallet = this.getWallet(walletId);
        return wallet != null ? wallet.getSettings().getWalletName() : walletId;
    }

    public String getThisWalletId() {
        return this.thisWallet.getWalletId();
    }

    public String getThisWalletName() {
        return this.thisWallet.getSettings().getWalletName();
    }

    public void handleEvent(String topic, String payload) {
        throw new UnsupportedOperationException();
    }

    public void handleEvent(String theirWalletId, String topic, String payload) {
        try {
            Object value;
            SafeConsumer<WebSocketEvent> consumer = ev -> this.handleGenericEvent((WebSocketEvent)ev);
            if (EventType.CONNECTIONS.topicEquals(topic)) {
                value = this.parser.parseValueSave(payload, ConnectionRecord.class).orElseThrow();
                consumer = ev -> this.handleConnection((WebSocketEvent)ev);
            } else if (EventType.PRESENT_PROOF.topicEquals(topic)) {
                value = this.parser.parseValueSave(payload, PresentationExchangeRecord.class).orElseThrow();
                consumer = ev -> this.handleProof((WebSocketEvent)ev);
            } else if (EventType.PRESENT_PROOF_V2.topicEquals(topic)) {
                value = this.parser.parseValueSave(payload, V20PresExRecord.class).orElseThrow();
            } else if (EventType.ISSUE_CREDENTIAL.topicEquals(topic)) {
                value = this.parser.parseValueSave(payload, V1CredentialExchange.class).orElseThrow();
                consumer = ev -> this.handleCredential((WebSocketEvent)ev);
            } else if (EventType.ISSUE_CREDENTIAL_V2.topicEquals(topic)) {
                value = this.parser.parseValueSave(payload, V20CredExRecord.class).orElseThrow();
            } else if (EventType.ISSUE_CREDENTIAL_V2_INDY.topicEquals(topic)) {
                value = this.parser.parseValueSave(payload, V2IssueIndyCredentialEvent.class).orElseThrow();
            } else if (EventType.ISSUE_CREDENTIAL_V2_LD_PROOF.topicEquals(topic)) {
                value = this.parser.parseValueSave(payload, V2IssueLDCredentialEvent.class).orElseThrow();
            } else if (EventType.BASIC_MESSAGES.topicEquals(topic)) {
                value = this.parser.parseValueSave(payload, BasicMessage.class).orElseThrow();
            } else if (EventType.PING.topicEquals(topic)) {
                value = this.parser.parseValueSave(payload, PingEvent.class).orElseThrow();
            } else if (EventType.ISSUER_CRED_REV.topicEquals(topic)) {
                value = this.parser.parseValueSave(payload, RevocationEvent.class).orElseThrow();
                consumer = ev -> this.handleRevocation((WebSocketEvent)ev);
            } else if (EventType.ENDORSE_TRANSACTION.topicEquals(topic)) {
                value = this.parser.parseValueSave(payload, EndorseTransactionRecord.class).orElseThrow();
            } else if (EventType.PROBLEM_REPORT.topicEquals(topic)) {
                value = this.parser.parseValueSave(payload, ProblemReport.class).orElseThrow();
            } else if (EventType.DISCOVER_FEATURE.topicEquals(topic)) {
                value = this.parser.parseValueSave(payload, DiscoverFeatureEvent.class).orElseThrow();
            } else if (EventType.REVOCATION_NOTIFICATION.topicEquals(topic)) {
                value = this.parser.parseValueSave(payload, RevocationNotificationEvent.class).orElseThrow();
            } else if (EventType.SETTINGS.topicEquals(topic)) {
                value = this.parser.parseValueSave(payload, Settings.class).orElseThrow();
                consumer = ev -> this.handleSettings((WebSocketEvent)ev);
            } else {
                this.log.warn("Unsupported event topic: {}", (Object)topic);
                if (this.log.isDebugEnabled()) {
                    JsonElement json = JsonParser.parseString((String)payload);
                    this.log.debug(GsonConfig.prettyPrinter().toJson(json));
                }
                return;
            }
            consumer.accept(new WebSocketEvent(theirWalletId, topic, value));
            if (this.log.isTraceEnabled()) {
                this.log.trace("RequestBody\n{}", (Object)pretty.toJson(JsonParser.parseString((String)payload)));
            }
        }
        catch (Throwable e) {
            this.log.error("Error in webhook event handler:", e);
        }
    }

    public void handleSettings(WebSocketEvent ev) throws Exception {
        this.log.info("{}: {}", (Object)ev.getThisWalletName(), ev.getPayload());
    }

    public void handleConnection(WebSocketEvent ev) throws Exception {
        ConnectionRecord con = ev.getPayload(ConnectionRecord.class);
        this.log.info("{}: [@{}] {} {} {}", new Object[]{ev.getThisWalletName(), ev.getTheirWalletName(), con.getTheirRole(), con.getState(), con});
    }

    public void handleCredential(WebSocketEvent ev) throws Exception {
        V1CredentialExchange cex = ev.getPayload(V1CredentialExchange.class);
        this.log.info("{}: [@{}] {} {} {}", new Object[]{ev.getThisWalletName(), ev.getTheirWalletName(), cex.getRole(), cex.getState(), cex});
    }

    public void handleGenericEvent(WebSocketEvent ev) throws Exception {
        this.log.info("{}: [@{}] {}", new Object[]{ev.getThisWalletName(), ev.getTheirWalletName(), ev.getPayload()});
    }

    public void handleRevocation(WebSocketEvent ev) throws Exception {
        RevocationEvent revoc = ev.getPayload(RevocationEvent.class);
        this.log.info("{}: [@{}] {} {}", new Object[]{ev.getThisWalletName(), ev.getTheirWalletName(), revoc.getState(), revoc});
    }

    public void handleProof(WebSocketEvent ev) throws Exception {
        PresentationExchangeRecord pex = ev.getPayload(PresentationExchangeRecord.class);
        this.log.info("{}: [@{}] {} {} {} {} {}", new Object[]{ev.getThisWalletName(), ev.getTheirWalletName(), pex.getRole(), pex.getState(), pex});
    }

    public class WebSocketEvent {
        private final String theirWalletId;
        private final String topic;
        private final Object payload;

        WebSocketEvent(String theirWalletId, String topic, Object payload) {
            this.theirWalletId = theirWalletId;
            this.topic = topic;
            this.payload = payload;
        }

        public DefaultEventHandler getEventHandler() {
            return DefaultEventHandler.this;
        }

        public AriesClient createClient() throws IOException {
            return AriesClientFactory.createClient(this.getThisWallet());
        }

        public String getTopic() {
            return this.topic;
        }

        public Class<?> getEventType() {
            return this.payload.getClass();
        }

        public WalletRecord getThisWallet() {
            return DefaultEventHandler.this.thisWallet;
        }

        public String getThisWalletId() {
            return DefaultEventHandler.this.getThisWalletId();
        }

        public String getThisWalletName() {
            return DefaultEventHandler.this.getThisWalletName();
        }

        public String getTheirWalletId() {
            return this.theirWalletId;
        }

        public String getTheirWalletName() {
            return DefaultEventHandler.this.getWalletName(this.theirWalletId);
        }

        public <T> T getPayload(Class<T> type) {
            return (T)this.payload;
        }

        public Object getPayload() {
            return this.payload;
        }
    }
}

