/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.aries.wallet;

import com.google.gson.Gson;
import io.nessus.aries.AgentConfiguration;
import io.nessus.aries.AriesClientFactory;
import io.nessus.aries.util.AssertState;
import io.nessus.aries.util.ThreadUtils;
import io.nessus.aries.wallet.WalletRegistry;
import io.nessus.aries.websocket.WebSocketClient;
import io.nessus.aries.websocket.WebSocketListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.hyperledger.acy_py.generated.model.DID;
import org.hyperledger.aries.AriesClient;
import org.hyperledger.aries.api.multitenancy.RemoveWalletRequest;
import org.hyperledger.aries.api.multitenancy.WalletRecord;
import org.hyperledger.aries.config.GsonConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessusWallet
extends WalletRecord
implements AutoCloseable {
    static final Logger log = LoggerFactory.getLogger(WalletRecord.class);
    static final Gson gson = GsonConfig.defaultConfig();
    private transient WalletRegistry walletRegistry;
    private transient WebSocketClient wsclient;
    private transient AriesClient rpclient;
    private transient DID publicDid;

    public static NessusWallet build(WalletRecord wr) {
        String json = gson.toJson((Object)wr);
        NessusWallet wallet = (NessusWallet)gson.fromJson(json, NessusWallet.class);
        return wallet;
    }

    public NessusWallet withWalletRegistry(WalletRegistry walletRegistry) {
        this.walletRegistry = walletRegistry;
        return this;
    }

    public String getWalletName() {
        return this.getSettings().getWalletName();
    }

    public DID getPublicDid() {
        return this.publicDid;
    }

    public void setPublicDid(DID publicDid) {
        this.publicDid = publicDid;
    }

    public WalletRegistry getWalletRegistry() {
        return this.walletRegistry;
    }

    public AriesClient getClient() {
        return this.rpclient;
    }

    public WebSocketClient getWebSocketClient() {
        return this.wsclient;
    }

    public AriesClient createClient() {
        return this.createClient(AgentConfiguration.defaultConfiguration());
    }

    public AriesClient createClient(AgentConfiguration config) {
        this.rpclient = AriesClientFactory.createClient(config, this);
        return this.rpclient;
    }

    public WebSocketClient createWebSocketClient() {
        return this.createWebSocketClient(AgentConfiguration.defaultConfiguration(), null);
    }

    public WebSocketClient createWebSocketClient(AgentConfiguration config) {
        return this.createWebSocketClient(config, null);
    }

    public WebSocketClient createWebSocketClient(AgentConfiguration config, WebSocketListener wslistener) {
        AssertState.isNull(this.wsclient, "WebSocket client already created");
        if (wslistener == null) {
            List<String> walletIdFilter = Collections.singletonList(this.getWalletId());
            wslistener = new WebSocketListener(this.getWalletName(), this.walletRegistry, walletIdFilter);
        }
        this.wsclient = new WebSocketClient(config, this);
        this.wsclient.openWebSocket(wslistener);
        return this.wsclient;
    }

    @Override
    public void close() throws IOException {
        this.closeWebSocket();
    }

    public synchronized void closeWebSocket() {
        if (this.wsclient != null) {
            this.wsclient.close();
            this.wsclient = null;
        }
    }

    public void closeAndRemove() throws IOException {
        log.info("Remove Wallet: {}", (Object)this.getWalletName());
        if (this.walletRegistry != null) {
            this.walletRegistry.removeWallet(this.getWalletId());
        }
        AriesClient adminClient = AriesClientFactory.adminClient();
        adminClient.multitenancyWalletRemove(this.getWalletId(), RemoveWalletRequest.builder().walletKey(this.getToken()).build());
        ThreadUtils.sleepWell(500L);
        while (!((List)adminClient.multitenancyWallets(this.getWalletName()).get()).isEmpty()) {
            ThreadUtils.sleepWell(500L);
        }
    }
}

