/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.channel.ThreadLocalPooledDirectByteBuf;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class ChannelOutboundBuffer {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelOutboundBuffer.class);
    protected static final int INITIAL_CAPACITY = 32;
    private static final Recycler<ChannelOutboundBuffer> RECYCLER = new Recycler<ChannelOutboundBuffer>(){

        @Override
        protected ChannelOutboundBuffer newObject(Recycler.Handle<ChannelOutboundBuffer> handle) {
            return new ChannelOutboundBuffer(handle);
        }
    };
    private final Recycler.Handle<? extends ChannelOutboundBuffer> handle;
    protected AbstractChannel channel;
    private Entry[] buffer;
    private int flushed;
    private int unflushed;
    private int tail;
    private boolean inFail;
    private static final AtomicLongFieldUpdater<ChannelOutboundBuffer> TOTAL_PENDING_SIZE_UPDATER;
    private volatile long totalPendingSize;
    private static final AtomicIntegerFieldUpdater<ChannelOutboundBuffer> WRITABLE_UPDATER;
    private volatile int writable = 1;

    static ChannelOutboundBuffer newInstance(AbstractChannel channel) {
        ChannelOutboundBuffer buffer = RECYCLER.get();
        buffer.channel = channel;
        return buffer;
    }

    protected ChannelOutboundBuffer(Recycler.Handle<? extends ChannelOutboundBuffer> handle) {
        this.handle = handle;
        this.buffer = new Entry[32];
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = this.newEntry();
        }
    }

    protected final Entry[] entries() {
        return this.buffer;
    }

    public final void addMessage(Object msg, ChannelPromise promise) {
        msg = this.beforeAdd(msg);
        int size = this.channel.estimatorHandle().size(msg);
        if (size < 0) {
            size = 0;
        }
        Entry e = this.buffer[this.tail++];
        e.msg = msg;
        e.pendingSize = size;
        e.promise = promise;
        e.total = ChannelOutboundBuffer.total(msg);
        this.tail &= this.buffer.length - 1;
        if (this.tail == this.flushed) {
            this.addCapacity();
        }
        this.incrementPendingOutboundBytes(size);
    }

    protected Object beforeAdd(Object msg) {
        return msg;
    }

    private void addCapacity() {
        int p = this.flushed;
        int n = this.buffer.length;
        int r = n - p;
        int s = this.size();
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException();
        }
        Entry[] e = new Entry[newCapacity];
        System.arraycopy(this.buffer, p, e, 0, r);
        System.arraycopy(this.buffer, 0, e, r, p);
        for (int i = n; i < e.length; ++i) {
            e[i] = this.newEntry();
        }
        this.buffer = e;
        this.flushed = 0;
        this.unflushed = s;
        this.tail = n;
    }

    public final void addFlush() {
        if (this.unflushed != this.tail) {
            this.unflushed = this.tail;
            int mask = this.buffer.length - 1;
            int i = this.flushed;
            while (i != this.unflushed && this.buffer[i].msg != null) {
                Entry entry = this.buffer[i];
                if (!entry.promise.setUncancellable()) {
                    int pending = entry.cancel();
                    this.decrementPendingOutboundBytes(pending);
                }
                i = i + 1 & mask;
            }
        }
    }

    final void incrementPendingOutboundBytes(int size) {
        AbstractChannel channel = this.channel;
        if (size == 0 || channel == null) {
            return;
        }
        long newWriteBufferSize = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, size);
        if (newWriteBufferSize > (long)channel.config().getWriteBufferHighWaterMark() && WRITABLE_UPDATER.compareAndSet(this, 1, 0)) {
            channel.pipeline().fireChannelWritabilityChanged();
        }
    }

    final void decrementPendingOutboundBytes(int size) {
        AbstractChannel channel = this.channel;
        if (size == 0 || channel == null) {
            return;
        }
        long newWriteBufferSize = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -size);
        if ((newWriteBufferSize == 0L || newWriteBufferSize < (long)channel.config().getWriteBufferLowWaterMark()) && WRITABLE_UPDATER.compareAndSet(this, 0, 1)) {
            channel.pipeline().fireChannelWritabilityChanged();
        }
    }

    private static long total(Object msg) {
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof FileRegion) {
            return ((FileRegion)msg).count();
        }
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        return -1L;
    }

    public final Object current() {
        if (this.isEmpty()) {
            return null;
        }
        Entry entry = this.buffer[this.flushed];
        return entry.msg;
    }

    public final void progress(long amount) {
        Entry e = this.buffer[this.flushed];
        ChannelPromise p = e.promise;
        if (p instanceof ChannelProgressivePromise) {
            long progress;
            e.progress = progress = e.progress + amount;
            ((ChannelProgressivePromise)p).tryProgress(progress, e.total);
        }
    }

    public final boolean remove() {
        if (this.isEmpty()) {
            return false;
        }
        Entry e = this.buffer[this.flushed];
        Object msg = e.msg;
        if (msg == null) {
            return false;
        }
        ChannelPromise promise = e.promise;
        int size = e.pendingSize;
        e.clear();
        this.flushed = this.flushed + 1 & this.buffer.length - 1;
        if (!e.cancelled) {
            ChannelOutboundBuffer.safeRelease(msg);
            ChannelOutboundBuffer.safeSuccess(promise);
            this.decrementPendingOutboundBytes(size);
        }
        return true;
    }

    public final boolean remove(Throwable cause) {
        if (this.isEmpty()) {
            return false;
        }
        Entry e = this.buffer[this.flushed];
        Object msg = e.msg;
        if (msg == null) {
            return false;
        }
        ChannelPromise promise = e.promise;
        int size = e.pendingSize;
        e.clear();
        this.flushed = this.flushed + 1 & this.buffer.length - 1;
        if (!e.cancelled) {
            ChannelOutboundBuffer.safeRelease(msg);
            ChannelOutboundBuffer.safeFail(promise, cause);
            this.decrementPendingOutboundBytes(size);
        }
        return true;
    }

    final boolean getWritable() {
        return this.writable != 0;
    }

    public final int size() {
        return this.unflushed - this.flushed & this.buffer.length - 1;
    }

    public final boolean isEmpty() {
        return this.unflushed == this.flushed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void failFlushed(Throwable cause) {
        if (this.inFail) {
            return;
        }
        try {
            this.inFail = true;
            while (this.remove(cause)) {
            }
        }
        finally {
            this.inFail = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close(final ClosedChannelException cause) {
        if (this.inFail) {
            this.channel.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    ChannelOutboundBuffer.this.close(cause);
                }
            });
            return;
        }
        this.inFail = true;
        if (this.channel.isOpen()) {
            throw new IllegalStateException("close() must be invoked after the channel is closed.");
        }
        if (!this.isEmpty()) {
            throw new IllegalStateException("close() must be invoked after all flushed writes are handled.");
        }
        int unflushedCount = this.tail - this.unflushed & this.buffer.length - 1;
        try {
            for (int i = 0; i < unflushedCount; ++i) {
                Entry e = this.buffer[this.unflushed + i & this.buffer.length - 1];
                int size = e.pendingSize;
                TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -size);
                e.pendingSize = 0;
                if (!e.cancelled) {
                    ChannelOutboundBuffer.safeRelease(e.msg);
                    ChannelOutboundBuffer.safeFail(e.promise, cause);
                }
                e.msg = null;
                e.promise = null;
            }
        }
        finally {
            this.tail = this.unflushed;
            this.inFail = false;
        }
        this.recycle();
    }

    protected static void safeRelease(Object message) {
        try {
            ReferenceCountUtil.release(message);
        }
        catch (Throwable t) {
            logger.warn("Failed to release a message.", t);
        }
    }

    private static void safeSuccess(ChannelPromise promise) {
        if (!(promise instanceof VoidChannelPromise) && !promise.trySuccess()) {
            logger.warn("Failed to mark a promise as success because it is done already: {}", (Object)promise);
        }
    }

    private static void safeFail(ChannelPromise promise, Throwable cause) {
        if (!(promise instanceof VoidChannelPromise) && !promise.tryFailure(cause)) {
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)promise, (Object)cause);
        }
    }

    public void recycle() {
        if (this.buffer.length > 32) {
            Entry[] e = new Entry[32];
            System.arraycopy(this.buffer, 0, e, 0, 32);
            this.buffer = e;
        }
        this.flushed = 0;
        this.unflushed = 0;
        this.tail = 0;
        this.channel = null;
        this.totalPendingSize = 0L;
        this.writable = 1;
        RECYCLER.recycle(this, this.handle);
    }

    public final long totalPendingWriteBytes() {
        return this.totalPendingSize;
    }

    protected Entry newEntry() {
        return new Entry();
    }

    protected final int flushed() {
        return this.flushed;
    }

    protected final int unflushed() {
        return this.unflushed;
    }

    protected ByteBuf copyToDirectByteBuf(ByteBuf buf) {
        int readableBytes = buf.readableBytes();
        ByteBufAllocator alloc = this.channel.alloc();
        if (alloc.isDirectBufferPooled()) {
            ByteBuf directBuf = alloc.directBuffer(readableBytes);
            directBuf.writeBytes(buf, buf.readerIndex(), readableBytes);
            ChannelOutboundBuffer.safeRelease(buf);
            return directBuf;
        }
        if (ThreadLocalPooledDirectByteBuf.threadLocalDirectBufferSize > 0) {
            ByteBuf directBuf = ThreadLocalPooledDirectByteBuf.newInstance();
            directBuf.writeBytes(buf, buf.readerIndex(), readableBytes);
            ChannelOutboundBuffer.safeRelease(buf);
            return directBuf;
        }
        return buf;
    }

    static {
        AtomicIntegerFieldUpdater<Object> writableUpdater = PlatformDependent.newAtomicIntegerFieldUpdater(ChannelOutboundBuffer.class, "writable");
        if (writableUpdater == null) {
            writableUpdater = AtomicIntegerFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "writable");
        }
        WRITABLE_UPDATER = writableUpdater;
        AtomicLongFieldUpdater<Object> pendingSizeUpdater = PlatformDependent.newAtomicLongFieldUpdater(ChannelOutboundBuffer.class, "totalPendingSize");
        if (pendingSizeUpdater == null) {
            pendingSizeUpdater = AtomicLongFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "totalPendingSize");
        }
        TOTAL_PENDING_SIZE_UPDATER = pendingSizeUpdater;
    }

    protected static class Entry {
        Object msg;
        ChannelPromise promise;
        long progress;
        long total;
        int pendingSize;
        int count = -1;
        boolean cancelled;

        protected Entry() {
        }

        public Object msg() {
            return this.msg;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public int cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                int pSize = this.pendingSize;
                ChannelOutboundBuffer.safeRelease(this.msg);
                this.msg = Unpooled.EMPTY_BUFFER;
                this.pendingSize = 0;
                this.total = 0L;
                this.progress = 0L;
                return pSize;
            }
            return 0;
        }

        public void clear() {
            this.msg = null;
            this.promise = null;
            this.progress = 0L;
            this.total = 0L;
            this.pendingSize = 0;
            this.count = -1;
            this.cancelled = false;
        }
    }
}

