/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamRemovalPolicy;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHttp2Connection
implements Http2Connection {
    private final Set<Http2Connection.Listener> listeners = new HashSet<Http2Connection.Listener>(4);
    private final IntObjectMap<Http2Stream> streamMap = new IntObjectHashMap<Http2Stream>();
    private final ConnectionStream connectionStream = new ConnectionStream();
    private final Set<Http2Stream> activeStreams = new LinkedHashSet<Http2Stream>();
    private final DefaultEndpoint<Http2LocalFlowController> localEndpoint;
    private final DefaultEndpoint<Http2RemoteFlowController> remoteEndpoint;
    private final Http2StreamRemovalPolicy removalPolicy;

    public DefaultHttp2Connection(boolean server) {
        this(server, Http2CodecUtil.immediateRemovalPolicy());
    }

    public DefaultHttp2Connection(boolean server, Http2StreamRemovalPolicy removalPolicy) {
        this.removalPolicy = ObjectUtil.checkNotNull(removalPolicy, "removalPolicy");
        this.localEndpoint = new DefaultEndpoint(server);
        this.remoteEndpoint = new DefaultEndpoint(!server);
        removalPolicy.setAction(new Http2StreamRemovalPolicy.Action(){

            @Override
            public void removeStream(Http2Stream stream) {
                DefaultHttp2Connection.this.removeStream((DefaultStream)stream);
            }
        });
        this.streamMap.put(this.connectionStream.id(), this.connectionStream);
    }

    @Override
    public void addListener(Http2Connection.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Http2Connection.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isServer() {
        return this.localEndpoint.isServer();
    }

    @Override
    public Http2Stream connectionStream() {
        return this.connectionStream;
    }

    @Override
    public Http2Stream requireStream(int streamId) throws Http2Exception {
        Http2Stream stream = this.stream(streamId);
        if (stream == null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream does not exist %d", streamId);
        }
        return stream;
    }

    @Override
    public Http2Stream stream(int streamId) {
        return this.streamMap.get(streamId);
    }

    @Override
    public int numActiveStreams() {
        return this.activeStreams.size();
    }

    public Set<Http2Stream> activeStreams() {
        return Collections.unmodifiableSet(this.activeStreams);
    }

    @Override
    public void deactivate(Http2Stream stream) {
        this.deactivateInternal((DefaultStream)stream);
    }

    @Override
    public Http2Connection.Endpoint<Http2LocalFlowController> local() {
        return this.localEndpoint;
    }

    @Override
    public Http2Connection.Endpoint<Http2RemoteFlowController> remote() {
        return this.remoteEndpoint;
    }

    @Override
    public boolean isGoAway() {
        return this.goAwaySent() || this.goAwayReceived();
    }

    @Override
    public Http2Stream createLocalStream(int streamId) throws Http2Exception {
        return this.local().createStream(streamId);
    }

    @Override
    public Http2Stream createRemoteStream(int streamId) throws Http2Exception {
        return this.remote().createStream(streamId);
    }

    @Override
    public boolean goAwayReceived() {
        return ((DefaultEndpoint)this.localEndpoint).lastKnownStream >= 0;
    }

    @Override
    public void goAwayReceived(int lastKnownStream) {
        ((DefaultEndpoint)this.localEndpoint).lastKnownStream(lastKnownStream);
    }

    @Override
    public boolean goAwaySent() {
        return ((DefaultEndpoint)this.remoteEndpoint).lastKnownStream >= 0;
    }

    @Override
    public void goAwaySent(int lastKnownStream) {
        ((DefaultEndpoint)this.remoteEndpoint).lastKnownStream(lastKnownStream);
    }

    private void removeStream(DefaultStream stream) {
        for (Http2Connection.Listener listener : this.listeners) {
            listener.streamRemoved(stream);
        }
        this.streamMap.remove(stream.id());
        stream.parent().removeChild(stream);
    }

    private void activateInternal(DefaultStream stream) {
        if (this.activeStreams.add(stream)) {
            ((DefaultEndpoint)stream.createdBy()).numActiveStreams++;
            for (Http2Connection.Listener listener : this.listeners) {
                listener.streamActive(stream);
            }
        }
    }

    private void deactivateInternal(DefaultStream stream) {
        if (this.activeStreams.remove(stream)) {
            ((DefaultEndpoint)stream.createdBy()).numActiveStreams--;
            for (Http2Connection.Listener listener : this.listeners) {
                listener.streamInactive(stream);
            }
            this.removalPolicy.markForRemoval(stream);
        }
    }

    private static IntObjectMap<DefaultStream> newChildMap() {
        return new IntObjectHashMap<DefaultStream>(4);
    }

    private void notifyParentChanged(List<ParentChangedEvent> events) {
        for (int i = 0; i < events.size(); ++i) {
            ParentChangedEvent event = events.get(i);
            for (Http2Connection.Listener l : this.listeners) {
                event.notifyListener(l);
            }
        }
    }

    private void notifyParentChanging(Http2Stream stream, Http2Stream newParent) {
        for (Http2Connection.Listener l : this.listeners) {
            l.priorityTreeParentChanging(stream, newParent);
        }
    }

    private final class DefaultEndpoint<F extends Http2FlowController>
    implements Http2Connection.Endpoint<F> {
        private final boolean server;
        private int nextStreamId;
        private int lastStreamCreated;
        private int lastKnownStream = -1;
        private boolean pushToAllowed = true;
        private F flowController;
        private int maxStreams;
        private int numActiveStreams;

        DefaultEndpoint(boolean server) {
            this.server = server;
            this.nextStreamId = server ? 2 : 1;
            this.pushToAllowed = !server;
            this.maxStreams = Integer.MAX_VALUE;
        }

        @Override
        public int nextStreamId() {
            return this.nextStreamId > 1 ? this.nextStreamId : this.nextStreamId + 2;
        }

        @Override
        public boolean createdStreamId(int streamId) {
            boolean even = (streamId & 1) == 0;
            return this.server == even;
        }

        @Override
        public boolean acceptingNewStreams() {
            return this.nextStreamId() > 0 && this.numActiveStreams + 1 <= this.maxStreams;
        }

        @Override
        public DefaultStream createStream(int streamId) throws Http2Exception {
            this.checkNewStreamAllowed(streamId);
            DefaultStream stream = new DefaultStream(streamId);
            this.nextStreamId = streamId + 2;
            this.lastStreamCreated = streamId;
            this.addStream(stream);
            return stream;
        }

        @Override
        public boolean isServer() {
            return this.server;
        }

        @Override
        public DefaultStream reservePushStream(int streamId, Http2Stream parent) throws Http2Exception {
            if (parent == null) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Parent stream missing", new Object[0]);
            }
            if (this.isLocal() ? !parent.localSideOpen() : !parent.remoteSideOpen()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d is not open for sending push promise", parent.id());
            }
            if (!this.opposite().allowPushTo()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server push not allowed to opposite endpoint.", new Object[0]);
            }
            this.checkNewStreamAllowed(streamId);
            DefaultStream stream = new DefaultStream(streamId);
            stream.state = this.isLocal() ? Http2Stream.State.RESERVED_LOCAL : Http2Stream.State.RESERVED_REMOTE;
            this.nextStreamId = streamId + 2;
            this.lastStreamCreated = streamId;
            this.addStream(stream);
            return stream;
        }

        private void addStream(DefaultStream stream) {
            DefaultHttp2Connection.this.streamMap.put(stream.id(), stream);
            ArrayList<ParentChangedEvent> events = new ArrayList<ParentChangedEvent>(1);
            DefaultHttp2Connection.this.connectionStream.takeChild(stream, false, events);
            for (Http2Connection.Listener listener : DefaultHttp2Connection.this.listeners) {
                listener.streamAdded(stream);
            }
            DefaultHttp2Connection.this.notifyParentChanged(events);
        }

        @Override
        public void allowPushTo(boolean allow) {
            if (allow && this.server) {
                throw new IllegalArgumentException("Servers do not allow push");
            }
            this.pushToAllowed = allow;
        }

        @Override
        public boolean allowPushTo() {
            return this.pushToAllowed;
        }

        @Override
        public int numActiveStreams() {
            return this.numActiveStreams;
        }

        @Override
        public int maxStreams() {
            return this.maxStreams;
        }

        @Override
        public void maxStreams(int maxStreams) {
            this.maxStreams = maxStreams;
        }

        @Override
        public int lastStreamCreated() {
            return this.lastStreamCreated;
        }

        @Override
        public int lastKnownStream() {
            return this.lastKnownStream >= 0 ? this.lastKnownStream : this.lastStreamCreated;
        }

        private void lastKnownStream(int lastKnownStream) {
            boolean alreadyNotified = DefaultHttp2Connection.this.isGoAway();
            this.lastKnownStream = lastKnownStream;
            if (!alreadyNotified) {
                this.notifyGoingAway();
            }
        }

        private void notifyGoingAway() {
            for (Http2Connection.Listener listener : DefaultHttp2Connection.this.listeners) {
                listener.goingAway();
            }
        }

        @Override
        public F flowController() {
            return this.flowController;
        }

        @Override
        public void flowController(F flowController) {
            this.flowController = (Http2FlowController)ObjectUtil.checkNotNull(flowController, "flowController");
        }

        @Override
        public Http2Connection.Endpoint<? extends Http2FlowController> opposite() {
            return this.isLocal() ? DefaultHttp2Connection.this.remoteEndpoint : DefaultHttp2Connection.this.localEndpoint;
        }

        private void checkNewStreamAllowed(int streamId) throws Http2Exception {
            if (DefaultHttp2Connection.this.isGoAway()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Cannot create a stream since the connection is going away", new Object[0]);
            }
            this.verifyStreamId(streamId);
            if (!this.acceptingNewStreams()) {
                throw Http2Exception.connectionError(Http2Error.REFUSED_STREAM, "Maximum streams exceeded for this endpoint.", new Object[0]);
            }
        }

        private void verifyStreamId(int streamId) throws Http2Exception {
            if (streamId < 0) {
                throw new Http2NoMoreStreamIdsException();
            }
            if (streamId < this.nextStreamId) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Request stream %d is behind the next expected stream %d", streamId, this.nextStreamId);
            }
            if (!this.createdStreamId(streamId)) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Request stream %d is not correct for %s connection", streamId, this.server ? "server" : "client");
            }
        }

        private boolean isLocal() {
            return this == DefaultHttp2Connection.this.localEndpoint;
        }
    }

    private final class ConnectionStream
    extends DefaultStream {
        ConnectionStream() {
            super(0);
        }

        @Override
        public Http2Stream setPriority(int parentStreamId, short weight, boolean exclusive) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Http2Stream open(boolean halfClosed) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Http2Stream close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Http2Stream closeLocalSide() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Http2Stream closeRemoteSide() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ParentChangedEvent {
        private final Http2Stream stream;
        private final Http2Stream oldParent;

        ParentChangedEvent(Http2Stream stream, Http2Stream oldParent) {
            this.stream = stream;
            this.oldParent = oldParent;
        }

        public void notifyListener(Http2Connection.Listener l) {
            l.priorityTreeParentChanged(this.stream, this.oldParent);
        }
    }

    private static final class LazyPropertyMap
    implements PropertyMap {
        private static final int DEFAULT_INITIAL_SIZE = 4;
        private final DefaultStream stream;

        LazyPropertyMap(DefaultStream stream) {
            this.stream = stream;
        }

        @Override
        public Object put(Object key, Object value) {
            this.stream.data = new DefaultProperyMap(4);
            return this.stream.data.put(key, value);
        }

        @Override
        public <V> V get(Object key) {
            this.stream.data = new DefaultProperyMap(4);
            return this.stream.data.get(key);
        }

        @Override
        public <V> V remove(Object key) {
            this.stream.data = new DefaultProperyMap(4);
            return this.stream.data.remove(key);
        }
    }

    private static final class DefaultProperyMap
    implements PropertyMap {
        private final Map<Object, Object> data;

        DefaultProperyMap(int initialSize) {
            this.data = new HashMap<Object, Object>(initialSize);
        }

        @Override
        public Object put(Object key, Object value) {
            return this.data.put(key, value);
        }

        @Override
        public <V> V get(Object key) {
            return (V)this.data.get(key);
        }

        @Override
        public <V> V remove(Object key) {
            return (V)this.data.remove(key);
        }
    }

    private static interface PropertyMap {
        public Object put(Object var1, Object var2);

        public <V> V get(Object var1);

        public <V> V remove(Object var1);
    }

    private class DefaultStream
    implements Http2Stream {
        private final int id;
        private Http2Stream.State state = Http2Stream.State.IDLE;
        private short weight = (short)16;
        private DefaultStream parent;
        private IntObjectMap<DefaultStream> children = DefaultHttp2Connection.access$400();
        private int totalChildWeights;
        private boolean resetSent;
        private PropertyMap data;

        DefaultStream(int id) {
            this.id = id;
            this.data = new LazyPropertyMap(this);
        }

        @Override
        public final int id() {
            return this.id;
        }

        @Override
        public final Http2Stream.State state() {
            return this.state;
        }

        @Override
        public boolean isResetSent() {
            return this.resetSent;
        }

        @Override
        public Http2Stream resetSent() {
            this.resetSent = true;
            return this;
        }

        @Override
        public Object setProperty(Object key, Object value) {
            return this.data.put(key, value);
        }

        @Override
        public <V> V getProperty(Object key) {
            return this.data.get(key);
        }

        @Override
        public <V> V removeProperty(Object key) {
            return this.data.remove(key);
        }

        @Override
        public final boolean isRoot() {
            return this.parent == null;
        }

        @Override
        public final short weight() {
            return this.weight;
        }

        @Override
        public final int totalChildWeights() {
            return this.totalChildWeights;
        }

        @Override
        public final DefaultStream parent() {
            return this.parent;
        }

        @Override
        public final boolean isDescendantOf(Http2Stream stream) {
            for (Http2Stream next = this.parent(); next != null; next = next.parent()) {
                if (next != stream) continue;
                return true;
            }
            return false;
        }

        @Override
        public final boolean isLeaf() {
            return this.numChildren() == 0;
        }

        @Override
        public final int numChildren() {
            return this.children.size();
        }

        @Override
        public final Collection<? extends Http2Stream> children() {
            return this.children.values();
        }

        @Override
        public final boolean hasChild(int streamId) {
            return this.child(streamId) != null;
        }

        @Override
        public final Http2Stream child(int streamId) {
            return this.children.get(streamId);
        }

        @Override
        public Http2Stream setPriority(int parentStreamId, short weight, boolean exclusive) throws Http2Exception {
            if (weight < 1 || weight > 256) {
                throw new IllegalArgumentException(String.format("Invalid weight: %d.  Must be between %d and %d (inclusive).", weight, (short)1, (short)256));
            }
            DefaultStream newParent = (DefaultStream)DefaultHttp2Connection.this.stream(parentStreamId);
            if (newParent == null) {
                newParent = this.createdBy().createStream(parentStreamId);
            } else if (this == newParent) {
                throw new IllegalArgumentException("A stream cannot depend on itself");
            }
            this.weight(weight);
            if (newParent != this.parent() || exclusive) {
                ArrayList<ParentChangedEvent> events;
                if (newParent.isDescendantOf(this)) {
                    events = new ArrayList<ParentChangedEvent>(2 + (exclusive ? newParent.numChildren() : 0));
                    this.parent.takeChild(newParent, false, events);
                } else {
                    events = new ArrayList(1 + (exclusive ? newParent.numChildren() : 0));
                }
                newParent.takeChild(this, exclusive, events);
                DefaultHttp2Connection.this.notifyParentChanged(events);
            }
            return this;
        }

        @Override
        public Http2Stream open(boolean halfClosed) throws Http2Exception {
            switch (this.state) {
                case IDLE: {
                    this.state = halfClosed ? (this.isLocal() ? Http2Stream.State.HALF_CLOSED_LOCAL : Http2Stream.State.HALF_CLOSED_REMOTE) : Http2Stream.State.OPEN;
                    break;
                }
                case RESERVED_LOCAL: {
                    this.state = Http2Stream.State.HALF_CLOSED_REMOTE;
                    break;
                }
                case RESERVED_REMOTE: {
                    this.state = Http2Stream.State.HALF_CLOSED_LOCAL;
                    break;
                }
                default: {
                    throw Http2Exception.streamError(this.id, Http2Error.PROTOCOL_ERROR, "Attempting to open a stream in an invalid state: " + (Object)((Object)this.state), new Object[0]);
                }
            }
            DefaultHttp2Connection.this.activateInternal(this);
            return this;
        }

        @Override
        public Http2Stream close() {
            if (this.state == Http2Stream.State.CLOSED) {
                return this;
            }
            this.state = Http2Stream.State.CLOSED;
            DefaultHttp2Connection.this.deactivateInternal(this);
            return this;
        }

        @Override
        public Http2Stream closeLocalSide() {
            switch (this.state) {
                case OPEN: {
                    this.state = Http2Stream.State.HALF_CLOSED_LOCAL;
                    this.notifyHalfClosed(this);
                    break;
                }
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                default: {
                    this.close();
                }
            }
            return this;
        }

        @Override
        public Http2Stream closeRemoteSide() {
            switch (this.state) {
                case OPEN: {
                    this.state = Http2Stream.State.HALF_CLOSED_REMOTE;
                    this.notifyHalfClosed(this);
                    break;
                }
                case HALF_CLOSED_REMOTE: {
                    break;
                }
                default: {
                    this.close();
                }
            }
            return this;
        }

        private void notifyHalfClosed(Http2Stream stream) {
            for (Http2Connection.Listener listener : DefaultHttp2Connection.this.listeners) {
                listener.streamHalfClosed(stream);
            }
        }

        @Override
        public final boolean remoteSideOpen() {
            return this.state == Http2Stream.State.HALF_CLOSED_LOCAL || this.state == Http2Stream.State.OPEN || this.state == Http2Stream.State.RESERVED_REMOTE;
        }

        @Override
        public final boolean localSideOpen() {
            return this.state == Http2Stream.State.HALF_CLOSED_REMOTE || this.state == Http2Stream.State.OPEN || this.state == Http2Stream.State.RESERVED_LOCAL;
        }

        final DefaultEndpoint<? extends Http2FlowController> createdBy() {
            return DefaultHttp2Connection.this.localEndpoint.createdStreamId(this.id) ? DefaultHttp2Connection.this.localEndpoint : DefaultHttp2Connection.this.remoteEndpoint;
        }

        final boolean isLocal() {
            return DefaultHttp2Connection.this.localEndpoint.createdStreamId(this.id);
        }

        final void weight(short weight) {
            if (weight != this.weight) {
                if (this.parent != null) {
                    int delta = weight - this.weight;
                    this.parent.totalChildWeights += delta;
                }
                short oldWeight = this.weight;
                this.weight = weight;
                for (Http2Connection.Listener l : DefaultHttp2Connection.this.listeners) {
                    l.onWeightChanged(this, oldWeight);
                }
            }
        }

        final IntObjectMap<DefaultStream> removeAllChildren() {
            this.totalChildWeights = 0;
            IntObjectMap<DefaultStream> prevChildren = this.children;
            this.children = DefaultHttp2Connection.newChildMap();
            return prevChildren;
        }

        final void takeChild(DefaultStream child, boolean exclusive, List<ParentChangedEvent> events) {
            DefaultStream oldParent = child.parent();
            events.add(new ParentChangedEvent(child, oldParent));
            DefaultHttp2Connection.this.notifyParentChanging(child, this);
            child.parent = this;
            if (exclusive && !this.children.isEmpty()) {
                for (DefaultStream grandchild : this.removeAllChildren().values()) {
                    child.takeChild(grandchild, false, events);
                }
            }
            if (this.children.put(child.id(), child) == null) {
                this.totalChildWeights += child.weight();
            }
            if (oldParent != null && oldParent.children.remove(child.id()) != null) {
                oldParent.totalChildWeights -= child.weight();
            }
        }

        final void removeChild(DefaultStream child) {
            if (this.children.remove(child.id()) != null) {
                ArrayList<ParentChangedEvent> events = new ArrayList<ParentChangedEvent>(1 + child.children.size());
                events.add(new ParentChangedEvent(child, child.parent()));
                DefaultHttp2Connection.this.notifyParentChanging(child, null);
                child.parent = null;
                this.totalChildWeights -= child.weight();
                for (DefaultStream grandchild : child.children.values()) {
                    this.takeChild(grandchild, false, events);
                }
                DefaultHttp2Connection.this.notifyParentChanged(events);
            }
        }
    }
}

