/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Queue;

public class DefaultHttp2RemoteFlowController
implements Http2RemoteFlowController {
    private static final Comparator<Http2Stream> WEIGHT_ORDER = new Comparator<Http2Stream>(){

        @Override
        public int compare(Http2Stream o1, Http2Stream o2) {
            return o2.weight() - o1.weight();
        }
    };
    private final Http2Connection connection;
    private int initialWindowSize = 65535;
    private ChannelHandlerContext ctx;
    private boolean needFlush;

    public DefaultHttp2RemoteFlowController(Http2Connection connection) {
        this.connection = ObjectUtil.checkNotNull(connection, "connection");
        connection.connectionStream().setProperty(FlowState.class, new FlowState(connection.connectionStream(), this.initialWindowSize));
        connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void streamAdded(Http2Stream stream) {
                stream.setProperty(FlowState.class, new FlowState(stream, 0));
            }

            @Override
            public void streamActive(Http2Stream stream) {
                DefaultHttp2RemoteFlowController.state(stream).window(DefaultHttp2RemoteFlowController.this.initialWindowSize);
            }

            @Override
            public void streamInactive(Http2Stream stream) {
                DefaultHttp2RemoteFlowController.state(stream).clear();
            }

            @Override
            public void priorityTreeParentChanged(Http2Stream stream, Http2Stream oldParent) {
                int delta;
                Http2Stream parent = stream.parent();
                if (parent != null && (delta = DefaultHttp2RemoteFlowController.state(stream).streamableBytesForTree()) != 0) {
                    DefaultHttp2RemoteFlowController.state(parent).incrementStreamableBytesForTree(delta);
                }
            }

            @Override
            public void priorityTreeParentChanging(Http2Stream stream, Http2Stream newParent) {
                int delta;
                Http2Stream parent = stream.parent();
                if (parent != null && (delta = -DefaultHttp2RemoteFlowController.state(stream).streamableBytesForTree()) != 0) {
                    DefaultHttp2RemoteFlowController.state(parent).incrementStreamableBytesForTree(delta);
                }
            }
        });
    }

    @Override
    public void initialWindowSize(int newWindowSize) throws Http2Exception {
        if (newWindowSize < 0) {
            throw new IllegalArgumentException("Invalid initial window size: " + newWindowSize);
        }
        int delta = newWindowSize - this.initialWindowSize;
        this.initialWindowSize = newWindowSize;
        for (Http2Stream stream : this.connection.activeStreams()) {
            DefaultHttp2RemoteFlowController.state(stream).incrementStreamWindow(delta);
        }
        if (delta > 0) {
            this.writePendingBytes();
        }
    }

    @Override
    public int initialWindowSize() {
        return this.initialWindowSize;
    }

    @Override
    public int windowSize(Http2Stream stream) {
        return DefaultHttp2RemoteFlowController.state(stream).window();
    }

    @Override
    public void incrementWindowSize(ChannelHandlerContext ctx, Http2Stream stream, int delta) throws Http2Exception {
        if (stream.id() == 0) {
            this.connectionState().incrementStreamWindow(delta);
            this.writePendingBytes();
        } else {
            FlowState state = DefaultHttp2RemoteFlowController.state(stream);
            state.incrementStreamWindow(delta);
            state.writeBytes(state.writableWindow());
            this.flush();
        }
    }

    @Override
    public void sendFlowControlled(ChannelHandlerContext ctx, Http2Stream stream, Http2RemoteFlowController.FlowControlled payload) {
        ObjectUtil.checkNotNull(ctx, "ctx");
        ObjectUtil.checkNotNull(payload, "payload");
        if (this.ctx != null && this.ctx != ctx) {
            throw new IllegalArgumentException("Writing data from multiple ChannelHandlerContexts is not supported");
        }
        this.ctx = ctx;
        try {
            FlowState state = DefaultHttp2RemoteFlowController.state(stream);
            state.newFrame(payload);
            state.writeBytes(state.writableWindow());
            this.flush();
        }
        catch (Throwable e) {
            payload.error(e);
        }
    }

    int streamableBytesForTree(Http2Stream stream) {
        return DefaultHttp2RemoteFlowController.state(stream).streamableBytesForTree();
    }

    private static FlowState state(Http2Stream stream) {
        ObjectUtil.checkNotNull(stream, "stream");
        return (FlowState)stream.getProperty(FlowState.class);
    }

    private FlowState connectionState() {
        return DefaultHttp2RemoteFlowController.state(this.connection.connectionStream());
    }

    private int connectionWindow() {
        return this.connectionState().window();
    }

    private void flush() {
        if (this.needFlush) {
            this.ctx.flush();
            this.needFlush = false;
        }
    }

    private void writePendingBytes() {
        Http2Stream connectionStream = this.connection.connectionStream();
        int connectionWindow = DefaultHttp2RemoteFlowController.state(connectionStream).window();
        if (connectionWindow > 0) {
            this.writeChildren(connectionStream, connectionWindow);
            for (Http2Stream stream : this.connection.activeStreams()) {
                DefaultHttp2RemoteFlowController.writeChildNode(DefaultHttp2RemoteFlowController.state(stream));
            }
            this.flush();
        }
    }

    private int writeChildren(Http2Stream parent, int connectionWindow) {
        FlowState state = DefaultHttp2RemoteFlowController.state(parent);
        if (state.streamableBytesForTree() <= 0) {
            return 0;
        }
        int bytesAllocated = 0;
        if (state.streamableBytesForTree() <= connectionWindow) {
            for (Http2Stream http2Stream : parent.children()) {
                state = DefaultHttp2RemoteFlowController.state(http2Stream);
                int bytesForChild = state.streamableBytes();
                if (bytesForChild > 0 || state.hasFrame()) {
                    state.allocate(bytesForChild);
                    DefaultHttp2RemoteFlowController.writeChildNode(state);
                    bytesAllocated += bytesForChild;
                    connectionWindow -= bytesForChild;
                }
                int childBytesAllocated = this.writeChildren(http2Stream, connectionWindow);
                bytesAllocated += childBytesAllocated;
                connectionWindow -= childBytesAllocated;
            }
            return bytesAllocated;
        }
        Http2Stream[] children = parent.children().toArray(new Http2Stream[parent.numChildren()]);
        Arrays.sort(children, WEIGHT_ORDER);
        int n = parent.totalChildWeights();
        int tail = children.length;
        while (tail > 0) {
            int n2;
            int nextTail = 0;
            int nextTotalWeight = 0;
            int nextConnectionWindow = connectionWindow;
            for (int head = 0; head < tail && nextConnectionWindow > 0; ++head) {
                Http2Stream child = children[head];
                state = DefaultHttp2RemoteFlowController.state(child);
                short weight = child.weight();
                double weightRatio = (double)weight / (double)n2;
                int bytesForTree = Math.min(nextConnectionWindow, (int)Math.ceil((double)connectionWindow * weightRatio));
                int bytesForChild = Math.min(state.streamableBytes(), bytesForTree);
                if (bytesForChild > 0 || state.hasFrame()) {
                    state.allocate(bytesForChild);
                    bytesAllocated += bytesForChild;
                    nextConnectionWindow -= bytesForChild;
                    bytesForTree -= bytesForChild;
                    if (state.streamableBytesForTree() - bytesForChild > 0) {
                        children[nextTail++] = child;
                        nextTotalWeight += weight;
                    }
                    if (state.streamableBytes() - bytesForChild == 0) {
                        DefaultHttp2RemoteFlowController.writeChildNode(state);
                    }
                }
                if (bytesForTree <= 0) continue;
                int childBytesAllocated = this.writeChildren(child, bytesForTree);
                bytesAllocated += childBytesAllocated;
                nextConnectionWindow -= childBytesAllocated;
            }
            connectionWindow = nextConnectionWindow;
            n2 = nextTotalWeight;
            tail = nextTail;
        }
        return bytesAllocated;
    }

    private static void writeChildNode(FlowState state) {
        state.writeBytes(state.allocated());
        state.resetAllocated();
    }

    final class FlowState {
        private final Queue<Frame> pendingWriteQueue;
        private final Http2Stream stream;
        private int window;
        private int pendingBytes;
        private int streamableBytesForTree;
        private int allocated;

        FlowState(Http2Stream stream, int initialWindowSize) {
            this.stream = stream;
            this.window(initialWindowSize);
            this.pendingWriteQueue = new ArrayDeque<Frame>(2);
        }

        int window() {
            return this.window;
        }

        void window(int initialWindowSize) {
            this.window = initialWindowSize;
        }

        void allocate(int bytes) {
            this.allocated += bytes;
        }

        int allocated() {
            return this.allocated;
        }

        void resetAllocated() {
            this.allocated = 0;
        }

        int incrementStreamWindow(int delta) throws Http2Exception {
            if (delta > 0 && Integer.MAX_VALUE - delta < this.window) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Window size overflow for stream: %d", this.stream.id());
            }
            int previouslyStreamable = this.streamableBytes();
            this.window += delta;
            int streamableDelta = this.streamableBytes() - previouslyStreamable;
            if (streamableDelta != 0) {
                this.incrementStreamableBytesForTree(streamableDelta);
            }
            return this.window;
        }

        int writableWindow() {
            return Math.min(this.window, DefaultHttp2RemoteFlowController.this.connectionWindow());
        }

        int streamableBytes() {
            return Math.max(0, Math.min(this.pendingBytes, this.window));
        }

        int streamableBytesForTree() {
            return this.streamableBytesForTree;
        }

        Frame newFrame(Http2RemoteFlowController.FlowControlled payload) {
            Frame frame = new Frame(payload);
            this.pendingWriteQueue.offer(frame);
            return frame;
        }

        boolean hasFrame() {
            return !this.pendingWriteQueue.isEmpty();
        }

        Frame peek() {
            return this.pendingWriteQueue.peek();
        }

        void clear() {
            Frame frame;
            while ((frame = this.pendingWriteQueue.poll()) != null) {
                frame.writeError(Http2Exception.streamError(this.stream.id(), Http2Error.INTERNAL_ERROR, "Stream closed before write could take place", new Object[0]));
            }
        }

        int writeBytes(int bytes) {
            int bytesAttempted = 0;
            while (this.hasFrame()) {
                int maxBytes = Math.min(bytes - bytesAttempted, this.writableWindow());
                if (bytes - (bytesAttempted += this.peek().write(maxBytes)) > 0) continue;
                break;
            }
            return bytesAttempted;
        }

        void incrementStreamableBytesForTree(int numBytes) {
            this.streamableBytesForTree += numBytes;
            if (!this.stream.isRoot()) {
                DefaultHttp2RemoteFlowController.state(this.stream.parent()).incrementStreamableBytesForTree(numBytes);
            }
        }

        private final class Frame {
            final Http2RemoteFlowController.FlowControlled payload;

            Frame(Http2RemoteFlowController.FlowControlled payload) {
                this.payload = payload;
                this.incrementPendingBytes(payload.size());
            }

            private void incrementPendingBytes(int numBytes) {
                int previouslyStreamable = FlowState.this.streamableBytes();
                FlowState.this.pendingBytes += numBytes;
                int delta = FlowState.this.streamableBytes() - previouslyStreamable;
                if (delta != 0) {
                    FlowState.this.incrementStreamableBytesForTree(delta);
                }
            }

            int write(int allowedBytes) {
                int before = this.payload.size();
                DefaultHttp2RemoteFlowController.this.needFlush = (byte)(DefaultHttp2RemoteFlowController.this.needFlush | (this.payload.write(Math.max(0, allowedBytes)) ? 1 : 0));
                int writtenBytes = before - this.payload.size();
                try {
                    DefaultHttp2RemoteFlowController.this.connectionState().incrementStreamWindow(-writtenBytes);
                    FlowState.this.incrementStreamWindow(-writtenBytes);
                }
                catch (Http2Exception e) {
                    throw new RuntimeException("Invalid window state when writing frame: " + e.getMessage(), e);
                }
                this.decrementPendingBytes(writtenBytes);
                if (this.payload.size() == 0) {
                    FlowState.this.pendingWriteQueue.remove();
                }
                return writtenBytes;
            }

            void writeError(Http2Exception cause) {
                this.decrementPendingBytes(this.payload.size());
                this.payload.error(cause);
            }

            void decrementPendingBytes(int bytes) {
                this.incrementPendingBytes(-bytes);
            }
        }
    }
}

