/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AtomicDouble;
import io.opencensus.common.Clock;
import io.opencensus.common.Timestamp;
import io.opencensus.implcore.internal.Utils;
import io.opencensus.implcore.metrics.Meter;
import io.opencensus.metrics.DoubleGauge;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.export.Metric;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.metrics.export.Point;
import io.opencensus.metrics.export.TimeSeries;
import io.opencensus.metrics.export.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class DoubleGaugeImpl
extends DoubleGauge
implements Meter {
    @VisibleForTesting
    static final LabelValue UNSET_VALUE = LabelValue.create(null);
    private final MetricDescriptor metricDescriptor;
    private volatile Map<List<LabelValue>, PointImpl> registeredPoints = Collections.emptyMap();
    private final int labelKeysSize;
    private final List<LabelValue> defaultLabelValues;

    DoubleGaugeImpl(String name, String description, String unit, List<LabelKey> labelKeys) {
        this.labelKeysSize = labelKeys.size();
        this.metricDescriptor = MetricDescriptor.create((String)name, (String)description, (String)unit, (MetricDescriptor.Type)MetricDescriptor.Type.GAUGE_DOUBLE, labelKeys);
        this.defaultLabelValues = new ArrayList<LabelValue>(this.labelKeysSize);
        for (int i = 0; i < this.labelKeysSize; ++i) {
            this.defaultLabelValues.add(UNSET_VALUE);
        }
    }

    public DoubleGauge.DoublePoint getOrCreateTimeSeries(List<LabelValue> labelValues) {
        PointImpl existingPoint = this.registeredPoints.get(labelValues);
        if (existingPoint != null) {
            return existingPoint;
        }
        List<LabelValue> labelValuesCopy = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(labelValues, (Object)"labelValues")));
        return this.registerTimeSeries(labelValuesCopy);
    }

    public DoubleGauge.DoublePoint getDefaultTimeSeries() {
        PointImpl existingPoint = this.registeredPoints.get(this.defaultLabelValues);
        if (existingPoint != null) {
            return existingPoint;
        }
        return this.registerTimeSeries(Collections.unmodifiableList(this.defaultLabelValues));
    }

    public synchronized void removeTimeSeries(List<LabelValue> labelValues) {
        Preconditions.checkNotNull(labelValues, (Object)"labelValues");
        LinkedHashMap<List<LabelValue>, PointImpl> registeredPointsCopy = new LinkedHashMap<List<LabelValue>, PointImpl>(this.registeredPoints);
        if (registeredPointsCopy.remove(labelValues) == null) {
            return;
        }
        this.registeredPoints = Collections.unmodifiableMap(registeredPointsCopy);
    }

    public synchronized void clear() {
        this.registeredPoints = Collections.emptyMap();
    }

    private synchronized DoubleGauge.DoublePoint registerTimeSeries(List<LabelValue> labelValues) {
        PointImpl existingPoint = this.registeredPoints.get(labelValues);
        if (existingPoint != null) {
            return existingPoint;
        }
        Preconditions.checkArgument((this.labelKeysSize == labelValues.size() ? 1 : 0) != 0, (Object)"Label Keys and Label Values don't have same size.");
        Utils.checkListElementNotNull(labelValues, "labelValue");
        PointImpl newPoint = new PointImpl(labelValues);
        LinkedHashMap<List<LabelValue>, PointImpl> registeredPointsCopy = new LinkedHashMap<List<LabelValue>, PointImpl>(this.registeredPoints);
        registeredPointsCopy.put(labelValues, newPoint);
        this.registeredPoints = Collections.unmodifiableMap(registeredPointsCopy);
        return newPoint;
    }

    @Override
    @Nullable
    public Metric getMetric(Clock clock) {
        Map<List<LabelValue>, PointImpl> currentRegisteredPoints = this.registeredPoints;
        if (currentRegisteredPoints.isEmpty()) {
            return null;
        }
        if (currentRegisteredPoints.size() == 1) {
            PointImpl point = currentRegisteredPoints.values().iterator().next();
            return Metric.createWithOneTimeSeries((MetricDescriptor)this.metricDescriptor, (TimeSeries)point.getTimeSeries(clock));
        }
        ArrayList<TimeSeries> timeSeriesList = new ArrayList<TimeSeries>(currentRegisteredPoints.size());
        for (Map.Entry<List<LabelValue>, PointImpl> entry : currentRegisteredPoints.entrySet()) {
            timeSeriesList.add(entry.getValue().getTimeSeries(clock));
        }
        return Metric.create((MetricDescriptor)this.metricDescriptor, timeSeriesList);
    }

    public static final class PointImpl
    extends DoubleGauge.DoublePoint {
        private final AtomicDouble value = new AtomicDouble(0.0);
        private final TimeSeries defaultTimeSeries;

        PointImpl(List<LabelValue> labelValues) {
            this.defaultTimeSeries = TimeSeries.create(labelValues);
        }

        public void add(double amt) {
            this.value.addAndGet(amt);
        }

        public void set(double val) {
            this.value.set(val);
        }

        private TimeSeries getTimeSeries(Clock clock) {
            return this.defaultTimeSeries.setPoint(Point.create((Value)Value.doubleValue((double)this.value.get()), (Timestamp)clock.now()));
        }
    }
}

