/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.FeatureManagerTask;
import io.openliberty.tools.ant.InstallFeatureTask;
import io.openliberty.tools.common.plugins.util.InstallFeatureUtil;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import io.openliberty.tools.maven.BasicSupport;
import io.openliberty.tools.maven.server.types.Features;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="install-feature")
public class InstallFeatureMojo
extends BasicSupport {
    @Parameter
    private Features features;
    private boolean noFeaturesSection;

    protected void doExecute() throws Exception {
        if (this.skip) {
            return;
        }
        if (this.features == null) {
            this.noFeaturesSection = true;
            this.features = new Features();
        }
        this.checkServerHomeExists();
        this.installFeatures();
    }

    private void installFeatures() throws PluginExecutionException {
        InstallFeatureMojoUtil util;
        Set<String> pluginListedFeatures = this.getPluginListedFeatures(false);
        Set<String> pluginListedEsas = this.getPluginListedFeatures(true);
        try {
            util = new InstallFeatureMojoUtil(pluginListedEsas);
        }
        catch (PluginScenarioException e) {
            this.log.debug((CharSequence)e.getMessage());
            if (this.noFeaturesSection) {
                this.log.debug((CharSequence)"Skipping feature installation with installUtility because the features configuration element with an acceptLicense parameter was not specified for the install-feature goal.");
            } else {
                this.log.debug((CharSequence)"Installing features from installUtility.");
                this.installFeaturesFromAnt(this.features.getFeatures());
            }
            return;
        }
        Set<String> dependencyFeatures = this.getDependencyFeatures();
        Set serverFeatures = this.serverDirectory.exists() ? util.getServerFeatures(this.serverDirectory) : null;
        Set featuresToInstall = InstallFeatureUtil.combineToSet((Collection[])new Collection[]{pluginListedFeatures, dependencyFeatures, serverFeatures});
        util.installFeatures(this.features.isAcceptLicense(), new ArrayList(featuresToInstall));
    }

    private Set<String> getPluginListedFeatures(boolean findEsaFiles) {
        HashSet<String> result = new HashSet<String>();
        for (FeatureManagerTask.Feature feature : this.features.getFeatures()) {
            if ((!findEsaFiles || !feature.getFeature().endsWith(".esa")) && (findEsaFiles || feature.getFeature().endsWith(".esa"))) continue;
            result.add(feature.getFeature());
            this.log.debug((CharSequence)("Plugin listed " + (findEsaFiles ? "ESA" : "feature") + ": " + feature.getFeature()));
        }
        return result;
    }

    private Set<String> getDependencyFeatures() {
        HashSet<String> result = new HashSet<String>();
        List dependencyArtifacts = this.project.getDependencies();
        for (Dependency dependencyArtifact : dependencyArtifacts) {
            if (!"esa".equals(dependencyArtifact.getType())) continue;
            result.add(dependencyArtifact.getArtifactId());
            this.log.debug((CharSequence)("Dependency feature: " + dependencyArtifact.getArtifactId()));
        }
        return result;
    }

    private void installFeaturesFromAnt(List<FeatureManagerTask.Feature> installFeatures) {
        InstallFeatureTask installFeatureTask;
        if (this.defaultOutputDirSet) {
            this.outputDirectory = new File(this.project.getBuild().getDirectory(), "liberty-alt-output-dir");
        }
        if ((installFeatureTask = (InstallFeatureTask)this.ant.createTask("antlib:io/openliberty/tools/ant:install-feature")) == null) {
            throw new IllegalStateException(MessageFormat.format(messages.getString("error.dependencies.not.found"), "install-feature"));
        }
        installFeatureTask.setInstallDir(this.installDirectory);
        installFeatureTask.setServerName(this.serverName);
        installFeatureTask.setUserDir(this.userDirectory);
        installFeatureTask.setOutputDir(this.outputDirectory);
        installFeatureTask.setAcceptLicense(this.features.isAcceptLicense());
        installFeatureTask.setTo(this.features.getTo());
        installFeatureTask.setWhenFileExists(this.features.getWhenFileExists());
        installFeatureTask.setFeatures(installFeatures);
        installFeatureTask.setFrom(this.features.getFrom());
        installFeatureTask.execute();
    }

    private class InstallFeatureMojoUtil
    extends InstallFeatureUtil {
        public InstallFeatureMojoUtil(Set<String> pluginListedEsas) throws PluginScenarioException, PluginExecutionException {
            super(InstallFeatureMojo.this.installDirectory, InstallFeatureMojo.this.features.getFrom(), InstallFeatureMojo.this.features.getTo(), pluginListedEsas);
        }

        public void debug(String msg) {
            InstallFeatureMojo.this.log.debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable e) {
            InstallFeatureMojo.this.log.debug((CharSequence)msg, e);
        }

        public void debug(Throwable e) {
            InstallFeatureMojo.this.log.debug(e);
        }

        public void warn(String msg) {
            InstallFeatureMojo.this.log.warn((CharSequence)msg);
        }

        public void info(String msg) {
            InstallFeatureMojo.this.log.info((CharSequence)msg);
        }

        public boolean isDebugEnabled() {
            return InstallFeatureMojo.this.log.isDebugEnabled();
        }

        public File downloadArtifact(String groupId, String artifactId, String type, String version) throws PluginExecutionException {
            try {
                return InstallFeatureMojo.this.getArtifact(groupId, artifactId, type, version).getFile();
            }
            catch (MojoExecutionException e) {
                throw new PluginExecutionException((Throwable)e);
            }
        }
    }
}

