/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.maven.server.StartDebugMojoSupport;
import java.text.MessageFormat;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="java-dump")
public class JavaDumpServerMojo
extends StartDebugMojoSupport {
    @Parameter(property="heapDump")
    private boolean heapDump;
    @Parameter(property="systemDump")
    private boolean systemDump;

    protected void doExecute() throws Exception {
        if (this.skip) {
            return;
        }
        if (this.isInstall) {
            this.installServerAssembly();
        } else {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.type.preexisting"), ""));
            this.checkServerHomeExists();
            this.checkServerDirectoryExists();
        }
        ServerTask serverTask = this.initializeJava();
        this.copyConfigFiles();
        serverTask.setOperation("javadump");
        serverTask.setInclude(this.generateInclude());
        serverTask.execute();
    }

    private String generateInclude() {
        StringBuilder builder = new StringBuilder();
        if (this.heapDump) {
            builder.append("heap");
        }
        if (this.systemDump) {
            if (builder.length() != 0) {
                builder.append(",");
            }
            builder.append("system");
        }
        return builder.length() == 0 ? null : builder.toString();
    }
}

