/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.common.plugins.util.DevUtil;
import io.openliberty.tools.common.plugins.util.JavaCompilerOptions;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import io.openliberty.tools.common.plugins.util.ProjectModule;
import io.openliberty.tools.common.plugins.util.ServerFeatureUtil;
import io.openliberty.tools.common.plugins.util.ServerStatusUtil;
import io.openliberty.tools.maven.BasicSupport;
import io.openliberty.tools.maven.applications.DeployMojoSupport;
import io.openliberty.tools.maven.server.StartDebugMojoSupport;
import io.openliberty.tools.maven.utils.ExecuteMojoUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="dev", requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class DevMojo
extends StartDebugMojoSupport {
    private static final String TEST_RUN_ID_PROPERTY_NAME = "liberty.dev.test.run.id";
    private static final String LIBERTY_HOSTNAME = "liberty.hostname";
    private static final String LIBERTY_HTTP_PORT = "liberty.http.port";
    private static final String LIBERTY_HTTPS_PORT = "liberty.https.port";
    private static final String MICROSHED_HOSTNAME = "microshed_hostname";
    private static final String MICROSHED_HTTP_PORT = "microshed_http_port";
    private static final String MICROSHED_HTTPS_PORT = "microshed_https_port";
    private static final String WLP_USER_DIR_PROPERTY_NAME = "wlp.user.dir";
    DevMojoUtil util = null;
    @Parameter(property="hotTests", defaultValue="false")
    private boolean hotTests;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="skipUTs", defaultValue="false")
    private boolean skipUTs;
    @Parameter(property="skipITs", defaultValue="false")
    private boolean skipITs;
    @Parameter(property="debug", defaultValue="true")
    private boolean libertyDebug;
    @Parameter(property="debugPort", defaultValue="7777")
    private int libertyDebugPort;
    @Parameter(property="container", defaultValue="false")
    private boolean container;
    @Parameter(property="recompileDependencies")
    private String recompileDependencies;
    @Parameter(property="compileWait", defaultValue="0.5")
    private double compileWait;
    private int runId = 0;
    private ServerTask serverTask = null;
    private Plugin boostPlugin = null;
    @Component
    protected ProjectBuilder mavenProjectBuilder;
    @Parameter(property="verifyTimeout", defaultValue="30")
    private int verifyTimeout;
    @Parameter(property="serverStartTimeout", defaultValue="90")
    private int serverStartTimeout;
    @Parameter(property="applications")
    private String applications;
    @Parameter(property="clean", defaultValue="false")
    protected boolean clean;
    @Parameter(property="pollingTest", defaultValue="false")
    protected boolean pollingTest;
    @Parameter(property="dockerfile")
    private File dockerfile;
    @Parameter(property="dockerBuildContext")
    private File dockerBuildContext;
    @Parameter(readonly=true, required=true, defaultValue=" ${project.build.sourceDirectory}")
    private String sourceDirectoryString;
    private File sourceDirectory;
    @Parameter(readonly=true, required=true, defaultValue=" ${project.build.testSourceDirectory}")
    private String testSourceDirectoryString;
    private File testSourceDirectory;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.testOutputDirectory}")
    private File testOutputDirectory;
    @Parameter(property="dockerRunOpts")
    private String dockerRunOpts;
    @Parameter(property="dockerBuildTimeout", defaultValue="600")
    private int dockerBuildTimeout;
    @Parameter(property="skipDefaultPorts", defaultValue="false")
    private boolean skipDefaultPorts;
    @Parameter(property="keepTempDockerfile", defaultValue="false")
    private boolean keepTempDockerfile;
    private static ServerFeature serverFeatureUtil;

    protected void setContainer(boolean container) {
        this.container = container;
        this.project.getProperties().setProperty("container", Boolean.toString(container));
    }

    protected List<File> getResourceDirectories(MavenProject project, File outputDir) {
        ArrayList<File> resourceDirs = new ArrayList<File>();
        if (outputDir.exists()) {
            List resources = project.getResources();
            for (Resource resource : resources) {
                File resourceFile = new File(resource.getDirectory());
                if (!resourceFile.exists()) continue;
                resourceDirs.add(resourceFile);
            }
        }
        if (resourceDirs.isEmpty()) {
            File defaultResourceDir = new File(project.getBasedir(), "src/main/resources");
            this.log.debug((CharSequence)("No resource directory detected, using default directory: " + defaultResourceDir));
            resourceDirs.add(defaultResourceDir);
        }
        return resourceDirs;
    }

    private boolean isUsingBoost() {
        return this.boostPlugin != null;
    }

    protected void doExecute() throws Exception {
        boolean recompileDeps;
        if (this.skip) {
            this.getLog().info((CharSequence)"\nSkipping dev goal.\n");
            return;
        }
        boolean isEar = false;
        if (this.project.getPackaging().equals("ear")) {
            isEar = true;
        }
        ArrayList<MavenProject> upstreamMavenProjects = new ArrayList<MavenProject>();
        ProjectDependencyGraph graph = this.session.getProjectDependencyGraph();
        if (graph != null) {
            this.checkMultiModuleConflicts(graph);
            List downstreamProjects = graph.getDownstreamProjects(this.project, true);
            if (!downstreamProjects.isEmpty()) {
                this.log.debug((CharSequence)("Downstream projects: " + downstreamProjects));
                if (isEar) {
                    this.runMojo("org.apache.maven.plugins", "maven-ear-plugin", "generate-application-xml");
                    this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
                    this.installEmptyEarIfNotFound(this.project);
                } else if (this.project.getPackaging().equals("pom")) {
                    this.log.debug((CharSequence)"Skipping compile/resources on module with pom packaging type");
                } else {
                    this.purgeLocalRepositoryArtifact();
                    this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
                    this.runCompileMojoLogWarning();
                }
                return;
            }
            upstreamMavenProjects.addAll(graph.getUpstreamProjects(this.project, true));
            if (this.containsPreviousLibertyModule(graph)) {
                return;
            }
        }
        HashMap<String, List<String>> parentPoms = new HashMap<String, List<String>>();
        for (MavenProject proj : graph.getAllProjects()) {
            this.updateParentPoms(parentPoms, proj);
        }
        if (this.recompileDependencies == null) {
            if (upstreamMavenProjects.isEmpty()) {
                this.log.debug((CharSequence)"The recompileDependencies parameter was not explicitly set. The default value -DrecompileDependencies=false will be used.");
                this.recompileDependencies = "false";
            } else {
                this.log.debug((CharSequence)"The recompileDependencies parameter was not explicitly set. The default value for multi module projects -DrecompileDependencies=true will be used.");
                this.recompileDependencies = "true";
            }
        }
        if (recompileDeps = Boolean.parseBoolean(this.recompileDependencies)) {
            if (!upstreamMavenProjects.isEmpty()) {
                this.log.info((CharSequence)"The recompileDependencies parameter is set to \"true\". On a file change all dependent modules will be recompiled.");
            } else {
                this.log.info((CharSequence)"The recompileDependencies parameter is set to \"true\". On a file change the entire project will be recompiled.");
            }
        } else {
            this.log.info((CharSequence)"The recompileDependencies parameter is set to \"false\". On a file change only the affected classes will be recompiled.");
        }
        this.boostPlugin = this.project.getPlugin("org.microshed.boost:boost-maven-plugin");
        this.processContainerParams();
        if (!this.container && this.serverDirectory.exists() && ServerStatusUtil.isServerRunning((File)this.installDirectory, (File)((StartDebugMojoSupport)this).outputDirectory, (String)this.serverName)) {
            throw new MojoExecutionException("The server " + this.serverName + " is already running. Terminate all instances of the server before starting dev mode. You can stop a server instance with the command 'mvn liberty:stop'.");
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1, true));
        if (isEar) {
            this.runMojo("org.apache.maven.plugins", "maven-ear-plugin", "generate-application-xml");
            this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
        } else if (this.project.getPackaging().equals("pom")) {
            this.log.debug((CharSequence)"Skipping compile/resources on module with pom packaging type");
        } else {
            this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
            this.runCompileMojoLogWarning();
            this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "testResources");
            this.runTestCompileMojoLogWarning();
        }
        this.sourceDirectory = new File(this.sourceDirectoryString.trim());
        this.testSourceDirectory = new File(this.testSourceDirectoryString.trim());
        ArrayList<File> javaFiles = new ArrayList<File>();
        this.listFiles(this.sourceDirectory, javaFiles, ".java");
        ArrayList<File> javaTestFiles = new ArrayList<File>();
        this.listFiles(this.testSourceDirectory, javaTestFiles, ".java");
        this.log.debug((CharSequence)("Source directory: " + this.sourceDirectory));
        this.log.debug((CharSequence)("Output directory: " + this.outputDirectory));
        this.log.debug((CharSequence)("Test Source directory: " + this.testSourceDirectory));
        this.log.debug((CharSequence)("Test Output directory: " + this.testOutputDirectory));
        if (this.isUsingBoost()) {
            this.log.info((CharSequence)"Running boost:package");
            this.runBoostMojo("package");
        } else {
            this.runLibertyMojoCreate();
            if (!this.container) {
                this.runLibertyMojoInstallFeature(null, null);
            }
            this.runLibertyMojoDeploy();
        }
        List<File> resourceDirs = this.getResourceDirectories(this.project, this.outputDirectory);
        JavaCompilerOptions compilerOptions = this.getMavenCompilerOptions(this.project);
        ArrayList<ProjectModule> upstreamProjects = new ArrayList<ProjectModule>();
        if (!upstreamMavenProjects.isEmpty()) {
            for (MavenProject p : upstreamMavenProjects) {
                JavaCompilerOptions upstreamCompilerOptions = this.getMavenCompilerOptions(p);
                HashSet compileArtifacts = new HashSet();
                HashSet testArtifacts = new HashSet();
                Build build = p.getBuild();
                File upstreamSourceDir = new File(build.getSourceDirectory());
                File upstreamOutputDir = new File(build.getOutputDirectory());
                File upstreamTestSourceDir = new File(build.getTestSourceDirectory());
                File upstreamTestOutputDir = new File(build.getTestOutputDirectory());
                List<File> upstreamResourceDirs = this.getResourceDirectories(p, upstreamOutputDir);
                Properties props = p.getProperties();
                Properties userProps = this.session.getUserProperties();
                Plugin libertyPlugin = this.getLibertyPluginForProject(p);
                Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(libertyPlugin, "dev", this.log);
                boolean upstreamSkipTests = DevMojo.getBooleanFlag(config, userProps, props, "skipTests");
                boolean upstreamSkipITs = DevMojo.getBooleanFlag(config, userProps, props, "skipITs");
                boolean upstreamSkipUTs = DevMojo.getBooleanFlag(config, userProps, props, "skipUTs");
                if (p.getPackaging().equals("ear")) {
                    upstreamSkipUTs = true;
                }
                List dependentProjects = graph.getDownstreamProjects(p, true);
                ArrayList<File> dependentModules = new ArrayList<File>();
                for (MavenProject depProj : dependentProjects) {
                    dependentModules.add(depProj.getFile());
                }
                ProjectModule upstreamProject = new ProjectModule(p.getFile(), p.getArtifactId(), p.getPackaging(), compileArtifacts, testArtifacts, upstreamSourceDir, upstreamOutputDir, upstreamTestSourceDir, upstreamTestOutputDir, upstreamResourceDirs, upstreamSkipTests, upstreamSkipUTs, upstreamSkipITs, upstreamCompilerOptions, dependentModules);
                upstreamProjects.add(upstreamProject);
            }
        }
        if (isEar) {
            this.skipUTs = true;
        }
        File pom = this.project.getFile();
        this.util = new DevMojoUtil(this.installDirectory, this.userDirectory, this.serverDirectory, this.sourceDirectory, this.testSourceDirectory, this.configDirectory, this.project.getBasedir(), this.multiModuleProjectDirectory, resourceDirs, compilerOptions, this.settings.getLocalRepository(), upstreamProjects, upstreamMavenProjects, recompileDeps, pom, parentPoms);
        this.util.addShutdownHook(executor);
        this.util.startServer();
        HashSet compileArtifactPaths = new HashSet(this.project.getCompileClasspathElements());
        HashSet testArtifactPaths = new HashSet(this.project.getTestClasspathElements());
        this.util.runHotkeyReaderThread(executor);
        try {
            if (!upstreamProjects.isEmpty()) {
                this.util.watchFiles(this.outputDirectory, this.testOutputDirectory, executor, compileArtifactPaths, testArtifactPaths, this.serverXmlFile, this.bootstrapPropertiesFile, this.jvmOptionsFile);
            } else {
                this.util.watchFiles(this.outputDirectory, this.testOutputDirectory, executor, compileArtifactPaths, testArtifactPaths, this.serverXmlFile, this.bootstrapPropertiesFile, this.jvmOptionsFile);
            }
        }
        catch (PluginScenarioException e) {
            if (e.getMessage() != null) {
                this.log.info((CharSequence)e.getMessage());
            }
            return;
        }
    }

    public static boolean getBooleanFlag(Xpp3Dom config, Properties userProps, Properties props, String param) {
        Boolean pluginConfig = DevMojo.parseBooleanIfDefined(DevMojo.getConfigValue(config, param));
        Boolean userProp = DevMojo.parseBooleanIfDefined(userProps.getProperty(param));
        Boolean prop = DevMojo.parseBooleanIfDefined(props.getProperty(param));
        return DevMojo.getFirstNonNullValue(pluginConfig, userProp, prop);
    }

    private static String getConfigValue(Xpp3Dom config, String attribute) {
        return config.getChild(attribute) == null ? null : config.getChild(attribute).getValue();
    }

    private static Boolean parseBooleanIfDefined(String value) {
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    public static boolean getFirstNonNullValue(Boolean ... booleans) {
        for (Boolean b : booleans) {
            if (b == null) continue;
            return b;
        }
        return false;
    }

    private void updateParentPoms(Map<String, List<String>> parentPoms, MavenProject proj) {
        MavenProject parentProject = proj.getParent();
        try {
            if (parentProject != null && parentProject.getFile() != null) {
                List<String> childPoms = parentPoms.get(parentProject.getFile().getCanonicalPath());
                if (childPoms == null) {
                    childPoms = new ArrayList<String>();
                    childPoms.add(proj.getFile().getCanonicalPath());
                    parentPoms.put(parentProject.getFile().getCanonicalPath(), childPoms);
                } else if (!childPoms.contains(proj.getFile().getCanonicalPath())) {
                    childPoms.add(proj.getFile().getCanonicalPath());
                }
                if (parentProject.getParent() != null) {
                    this.updateParentPoms(parentPoms, parentProject);
                }
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)("An unexpected error occurred when trying to resolve " + proj.getFile() + ": " + e.getMessage()));
            this.log.debug((Throwable)e);
        }
    }

    private JavaCompilerOptions getMavenCompilerOptions(MavenProject currentProject) {
        String release;
        String target;
        String source;
        Plugin plugin = this.getPluginForProject("org.apache.maven.plugins", "maven-compiler-plugin", currentProject);
        Xpp3Dom configuration = ExecuteMojoUtil.getPluginGoalConfig(plugin, "compile", this.log);
        JavaCompilerOptions compilerOptions = new JavaCompilerOptions();
        String showWarnings = this.getCompilerOption(configuration, "showWarnings", "maven.compiler.showWarnings", currentProject);
        if (showWarnings != null) {
            boolean showWarningsBoolean = Boolean.parseBoolean(showWarnings);
            this.log.debug((CharSequence)("Setting showWarnings to " + showWarningsBoolean));
            compilerOptions.setShowWarnings(showWarningsBoolean);
        }
        if ((source = this.getCompilerOption(configuration, "source", "maven.compiler.source", currentProject)) != null) {
            this.log.debug((CharSequence)("Setting compiler source to " + source));
            compilerOptions.setSource(source);
        }
        if ((target = this.getCompilerOption(configuration, "target", "maven.compiler.target", currentProject)) != null) {
            this.log.debug((CharSequence)("Setting compiler target to " + target));
            compilerOptions.setTarget(target);
        }
        if ((release = this.getCompilerOption(configuration, "release", "maven.compiler.release", currentProject)) != null) {
            this.log.debug((CharSequence)("Setting compiler release to " + release));
            compilerOptions.setRelease(release);
        }
        return compilerOptions;
    }

    private String getCompilerOption(Xpp3Dom configuration, String mavenParameterName, String projectPropertyName, MavenProject currentProject) {
        Xpp3Dom child;
        String option = null;
        option = this.session.getUserProperties().getProperty(projectPropertyName);
        if (option == null && configuration != null && (child = configuration.getChild(mavenParameterName)) != null) {
            option = child.getValue();
        }
        if (option == null) {
            option = currentProject.getProperties().getProperty(projectPropertyName);
        }
        return option;
    }

    private void processContainerParams() throws MojoExecutionException {
        if (this.container) {
            this.setContainer(true);
        }
    }

    private MavenProject resolveMavenProject(File buildFile) {
        MavenProject currentProject = this.project;
        try {
            ProjectBuildingResult build;
            if (buildFile != null && !this.project.getFile().getCanonicalPath().equals(buildFile.getCanonicalPath()) && (build = this.mavenProjectBuilder.build(buildFile, this.session.getProjectBuildingRequest().setResolveDependencies(true))).getProject() != null) {
                currentProject = build.getProject();
            }
        }
        catch (IOException | ProjectBuildingException e) {
            this.log.error((CharSequence)("An unexpected error occurred when trying to run integration tests for " + buildFile.getAbsolutePath() + ": " + e.getMessage()));
            this.log.debug(e);
        }
        return currentProject;
    }

    private void runTestMojo(String groupId, String artifactId, String goal, MavenProject project) throws MojoExecutionException {
        Plugin plugin = this.getPluginForProject(groupId, artifactId, project);
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(plugin, goal, this.log);
        if (this.util.isMultiModuleProject()) {
            try {
                ProjectModule projectModule = this.util.getProjectModule(project.getFile());
                Set testArtifacts = projectModule != null ? projectModule.getTestArtifacts() : this.util.getTestArtifacts();
                if (goal.equals("test") || goal.equals("integration-test")) {
                    this.injectClasspathElements(config, testArtifacts, project.getTestClasspathElements());
                }
            }
            catch (IOException | DependencyResolutionRequiredException e) {
                this.log.error((CharSequence)("Unable to resolve test artifact paths for " + project.getFile() + ". Restart dev mode to ensure classpaths are properly resolved."));
                this.log.debug(e);
            }
        }
        if (goal.equals("test")) {
            this.injectTestId(config);
        } else if (goal.equals("integration-test")) {
            this.injectTestId(config);
            this.injectLibertyProperties(config);
            File summaryFile = null;
            Xpp3Dom summaryFileElement = config.getChild("summaryFile");
            summaryFile = summaryFileElement != null && summaryFileElement.getValue() != null ? new File(summaryFileElement.getValue()) : new File(project.getBuild().getDirectory(), "failsafe-reports/failsafe-summary.xml");
            try {
                this.log.debug((CharSequence)("Looking for summary file at " + summaryFile.getCanonicalPath()));
            }
            catch (IOException e) {
                this.log.debug((CharSequence)("Unable to resolve summary file " + e.getMessage()));
            }
            if (summaryFile.exists()) {
                boolean deleteResult = summaryFile.delete();
                this.log.debug((CharSequence)("Summary file deleted? " + deleteResult));
            } else {
                this.log.debug((CharSequence)"Summary file doesn't exist");
            }
        } else if (goal.equals("failsafe-report-only")) {
            Plugin failsafePlugin = this.getPluginForProject("org.apache.maven.plugins", "maven-failsafe-plugin", project);
            Xpp3Dom failsafeConfig = ExecuteMojoUtil.getPluginGoalConfig(failsafePlugin, "integration-test", this.log);
            Xpp3Dom linkXRef = new Xpp3Dom("linkXRef");
            if (failsafeConfig != null) {
                Xpp3Dom reportsDirectoryElement = failsafeConfig.getChild("reportsDirectory");
                if (reportsDirectoryElement != null) {
                    Xpp3Dom reportDirectories = new Xpp3Dom("reportsDirectories");
                    reportDirectories.addChild(reportsDirectoryElement);
                    config.addChild(reportDirectories);
                }
                if ((linkXRef = failsafeConfig.getChild("linkXRef")) == null) {
                    linkXRef = new Xpp3Dom("linkXRef");
                }
            }
            linkXRef.setValue("false");
            config.addChild(linkXRef);
        } else if (goal.equals("report-only")) {
            Plugin surefirePlugin = this.getPluginForProject("org.apache.maven.plugins", "maven-surefire-plugin", project);
            Xpp3Dom surefireConfig = ExecuteMojoUtil.getPluginGoalConfig(surefirePlugin, "test", this.log);
            Xpp3Dom linkXRef = new Xpp3Dom("linkXRef");
            if (surefireConfig != null) {
                Xpp3Dom reportsDirectoryElement = surefireConfig.getChild("reportsDirectory");
                if (reportsDirectoryElement != null) {
                    Xpp3Dom reportDirectories = new Xpp3Dom("reportsDirectories");
                    reportDirectories.addChild(reportsDirectoryElement);
                    config.addChild(reportDirectories);
                }
                if ((linkXRef = surefireConfig.getChild("linkXRef")) == null) {
                    linkXRef = new Xpp3Dom("linkXRef");
                }
            }
            linkXRef.setValue("false");
            config.addChild(linkXRef);
        }
        this.log.debug((CharSequence)("POM file: " + project.getFile() + "\n" + groupId + ":" + artifactId + " " + goal + " configuration:\n" + config));
        MavenSession tempSession = this.session.clone();
        tempSession.setCurrentProject(project);
        MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)project, (MavenSession)tempSession, (BuildPluginManager)this.pluginManager));
    }

    private void injectClasspathElements(Xpp3Dom config, Set<String> testArtifacts, List<String> testClasspathElements) {
        if (testArtifacts.size() > testClasspathElements.size()) {
            ArrayList<String> additionalClassPathElements = new ArrayList<String>();
            additionalClassPathElements.addAll(testArtifacts);
            additionalClassPathElements.removeAll(testClasspathElements);
            Xpp3Dom classpathElement = config.getChild("additionalClasspathElements");
            if (classpathElement == null) {
                classpathElement = new Xpp3Dom("additionalClasspathElements");
            }
            for (String element : additionalClassPathElements) {
                Xpp3Dom childElem = new Xpp3Dom("additionalClasspathElement");
                childElem.setValue(element);
                classpathElement.addChild(childElem);
            }
            config.addChild(classpathElement);
        }
    }

    private void injectTestId(Xpp3Dom config) {
        Xpp3Dom properties = config.getChild("properties");
        if (properties == null || properties.getChild(TEST_RUN_ID_PROPERTY_NAME) == null) {
            MojoExecutor.Element e = MojoExecutor.element((String)MojoExecutor.name((String)"properties"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)TEST_RUN_ID_PROPERTY_NAME), (String)String.valueOf(this.runId++))});
            config.addChild(e.toDom());
        } else {
            properties.getChild(TEST_RUN_ID_PROPERTY_NAME).setValue(String.valueOf(this.runId++));
        }
    }

    private void injectLibertyProperties(Xpp3Dom config) throws MojoExecutionException {
        Xpp3Dom sysProps = config.getChild("systemPropertyVariables");
        if (sysProps == null) {
            MojoExecutor.Element e = MojoExecutor.element((String)MojoExecutor.name((String)"systemPropertyVariables"), (MojoExecutor.Element[])new MojoExecutor.Element[0]);
            sysProps = e.toDom();
            config.addChild(sysProps);
        }
        this.addDomPropertyIfNotFound(sysProps, LIBERTY_HOSTNAME, this.util.getHostName());
        this.addDomPropertyIfNotFound(sysProps, LIBERTY_HTTP_PORT, this.util.getHttpPort());
        this.addDomPropertyIfNotFound(sysProps, LIBERTY_HTTPS_PORT, this.util.getHttpsPort());
        this.addDomPropertyIfNotFound(sysProps, MICROSHED_HOSTNAME, this.util.getHostName());
        this.addDomPropertyIfNotFound(sysProps, MICROSHED_HTTP_PORT, this.util.getHttpPort());
        this.addDomPropertyIfNotFound(sysProps, MICROSHED_HTTPS_PORT, this.util.getHttpsPort());
        try {
            this.addDomPropertyIfNotFound(sysProps, WLP_USER_DIR_PROPERTY_NAME, this.userDirectory.getCanonicalPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not resolve canonical path of userDirectory parameter: " + this.userDirectory.getAbsolutePath(), (Exception)e);
        }
    }

    private void addDomPropertyIfNotFound(Xpp3Dom sysProps, String key, String value) {
        if (sysProps.getChild(key) == null && value != null) {
            sysProps.addChild(MojoExecutor.element((String)MojoExecutor.name((String)key), (String)value).toDom());
        }
    }

    private void runBoostMojo(String goal) throws MojoExecutionException, ProjectBuildingException {
        MavenProject boostProject = this.project;
        MavenSession boostSession = this.session;
        this.log.debug((CharSequence)("plugin version: " + this.boostPlugin.getVersion()));
        MojoExecutor.executeMojo((Plugin)this.boostPlugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)boostProject, (MavenSession)boostSession, (BuildPluginManager)this.pluginManager));
    }

    private void listFiles(File directory, List<File> files, String suffix) {
        File[] fList;
        if (directory != null && (fList = directory.listFiles()) != null) {
            for (File file : fList) {
                if (file.isFile() && (suffix == null || file.getName().toLowerCase().endsWith("." + suffix))) {
                    files.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.listFiles(file, files, suffix);
            }
        }
    }

    private ServerFeature getServerFeatureUtil() {
        if (serverFeatureUtil == null) {
            serverFeatureUtil = new ServerFeature();
        }
        return serverFeatureUtil;
    }

    private void runCompileMojo(String goal, MavenProject mavenProject) throws MojoExecutionException {
        Plugin plugin = this.getPluginForProject("org.apache.maven.plugins", "maven-compiler-plugin", mavenProject);
        MavenSession tempSession = this.session.clone();
        tempSession.setCurrentProject(mavenProject);
        MavenProject tempProject = mavenProject;
        Xpp3Dom config = ExecuteMojoUtil.getPluginGoalConfig(plugin, goal, this.log);
        config = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"failOnError"), (String)"false")}), (Xpp3Dom)config);
        this.log.info((CharSequence)("Running maven-compiler-plugin:" + goal + " on " + tempProject.getFile()));
        this.log.debug((CharSequence)("configuration:\n" + config));
        MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)config, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)tempProject, (MavenSession)tempSession, (BuildPluginManager)this.pluginManager));
    }

    private void runCompileMojoLogWarning() throws MojoExecutionException {
        this.runCompileMojo("compile", this.project);
    }

    private void runCompileMojoLogWarning(MavenProject mavenProject) throws MojoExecutionException {
        this.runCompileMojo("compile", mavenProject);
    }

    private void runTestCompileMojoLogWarning() throws MojoExecutionException {
        this.runCompileMojo("testCompile", this.project);
    }

    private void runTestCompileMojoLogWarning(MavenProject mavenProject) throws MojoExecutionException {
        this.runCompileMojo("testCompile", mavenProject);
    }

    @Override
    protected void runLibertyMojoInstallFeature(MojoExecutor.Element features, String containerName) throws MojoExecutionException {
        super.runLibertyMojoInstallFeature(features, containerName);
    }

    @Override
    protected void runLibertyMojoCreate() throws MojoExecutionException {
        if (this.container) {
            this.log.debug((CharSequence)"runLibertyMojoCreate check for installDirectory and serverDirectory");
            if (!this.installDirectory.isDirectory()) {
                this.installDirectory.mkdirs();
            }
            if (!this.serverDirectory.isDirectory()) {
                this.serverDirectory.mkdirs();
            }
        } else {
            super.runLibertyMojoCreate();
        }
    }

    private class ServerFeature
    extends ServerFeatureUtil {
        private ServerFeature() {
        }

        public void debug(String msg) {
            DevMojo.this.log.debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable e) {
            DevMojo.this.log.debug((CharSequence)msg, e);
        }

        public void debug(Throwable e) {
            DevMojo.this.log.debug(e);
        }

        public void warn(String msg) {
            DevMojo.this.log.warn((CharSequence)msg);
        }

        public void info(String msg) {
            DevMojo.this.log.info((CharSequence)msg);
        }

        public void error(String msg, Throwable e) {
            DevMojo.this.log.error((CharSequence)msg, e);
        }
    }

    private class DevMojoUtil
    extends DevUtil {
        Set<String> existingFeatures;
        Map<String, File> libertyDirPropertyFiles;
        List<MavenProject> upstreamMavenProjects;
        private static final String LIBERTY_BOOTSTRAP_PROP = "liberty.bootstrap.";
        private static final String LIBERTY_JVM_PROP = "liberty.jvm.";
        private static final String LIBERTY_ENV_PROP = "liberty.env.";
        private static final String LIBERTY_VAR_PROP = "liberty.var.";
        private static final String LIBERTY_DEFAULT_VAR_PROP = "liberty.defaultVar.";

        public DevMojoUtil(File installDir, File userDir, File serverDirectory, File sourceDirectory, File testSourceDirectory, File configDirectory, File projectDirectory, File multiModuleProjectDirectory, List<File> resourceDirs, JavaCompilerOptions compilerOptions, String mavenCacheLocation, List<ProjectModule> upstreamProjects, List<MavenProject> upstreamMavenProjects, boolean recompileDeps, File pom, Map<String, List<String>> parentPoms) throws IOException {
            super(new File(DevMojo.this.project.getBuild().getDirectory()), serverDirectory, sourceDirectory, testSourceDirectory, configDirectory, projectDirectory, multiModuleProjectDirectory, resourceDirs, DevMojo.this.hotTests, DevMojo.this.skipTests, DevMojo.this.skipUTs, DevMojo.this.skipITs, DevMojo.this.project.getArtifactId(), (long)DevMojo.this.serverStartTimeout, DevMojo.this.verifyTimeout, DevMojo.this.verifyTimeout, (long)(DevMojo.this.compileWait * 1000.0), DevMojo.this.libertyDebug, false, false, DevMojo.this.pollingTest, DevMojo.this.container, DevMojo.this.dockerfile, DevMojo.this.dockerBuildContext, DevMojo.this.dockerRunOpts, DevMojo.this.dockerBuildTimeout, DevMojo.this.skipDefaultPorts, compilerOptions, DevMojo.this.keepTempDockerfile, mavenCacheLocation, upstreamProjects, recompileDeps, DevMojo.this.project.getPackaging(), pom, parentPoms);
            this.libertyDirPropertyFiles = new HashMap<String, File>();
            ServerFeature servUtil = DevMojo.this.getServerFeatureUtil();
            this.libertyDirPropertyFiles = BasicSupport.getLibertyDirectoryPropertyFiles(installDir, userDir, serverDirectory);
            this.existingFeatures = servUtil.getServerFeatures(serverDirectory, this.libertyDirPropertyFiles);
            this.upstreamMavenProjects = upstreamMavenProjects;
        }

        public void debug(String msg) {
            DevMojo.this.log.debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable e) {
            DevMojo.this.log.debug((CharSequence)msg, e);
        }

        public void debug(Throwable e) {
            DevMojo.this.log.debug(e);
        }

        public void warn(String msg) {
            DevMojo.this.log.warn((CharSequence)msg);
        }

        public void info(String msg) {
            DevMojo.this.log.info((CharSequence)msg);
        }

        public void error(String msg) {
            DevMojo.this.log.error((CharSequence)msg);
        }

        public void error(String msg, Throwable e) {
            DevMojo.this.log.error((CharSequence)msg, e);
        }

        public boolean isDebugEnabled() {
            return DevMojo.this.log.isDebugEnabled();
        }

        public String getServerStartTimeoutExample() {
            return "'mvn liberty:dev -DserverStartTimeout=120'";
        }

        public String getProjectName() {
            return DevMojo.this.project.getArtifactId();
        }

        public void libertyCreate() throws PluginExecutionException {
            try {
                if (DevMojo.this.isUsingBoost()) {
                    DevMojo.this.log.info((CharSequence)"Running boost:package");
                    DevMojo.this.runBoostMojo("package");
                } else {
                    DevMojo.this.runLibertyMojoCreate();
                }
            }
            catch (MojoExecutionException | ProjectBuildingException e) {
                throw new PluginExecutionException(e);
            }
        }

        public void libertyInstallFeature() throws PluginExecutionException {
            try {
                DevMojo.this.runLibertyMojoInstallFeature(null, DevMojo.this.container ? super.getContainerName() : null);
            }
            catch (MojoExecutionException e) {
                throw new PluginExecutionException((Throwable)e);
            }
        }

        public void libertyDeploy() throws PluginExecutionException {
            try {
                DevMojo.this.runLibertyMojoDeploy();
            }
            catch (MojoExecutionException e) {
                throw new PluginExecutionException((Throwable)e);
            }
        }

        public void stopServer() {
            this.serverFullyStarted.set(false);
            if (DevMojo.this.container) {
                return;
            }
            try {
                ServerTask serverTask = DevMojo.this.initializeJava();
                serverTask.setOperation("stop");
                serverTask.execute();
            }
            catch (Exception e) {
                DevMojo.this.log.warn((CharSequence)MessageFormat.format(messages.getString("warn.server.stopped"), DevMojo.this.serverName));
            }
        }

        public ServerTask getServerTask() throws Exception {
            if (DevMojo.this.serverTask != null) {
                return DevMojo.this.serverTask;
            }
            DevMojo.this.serverTask = DevMojo.this.initializeJava();
            DevMojo.this.copyConfigFiles();
            DevMojo.this.serverTask.setClean(DevMojo.this.clean);
            if (DevMojo.this.libertyDebug) {
                this.setLibertyDebugPort(DevMojo.this.libertyDebugPort);
                DevMojo.this.serverTask.setOperation("debug");
                DevMojo.this.serverTask.setEnvironmentVariables(this.getDebugEnvironmentVariables());
            } else {
                DevMojo.this.serverTask.setOperation("run");
            }
            return DevMojo.this.serverTask;
        }

        private Properties getPropertiesWithKeyPrefix(Properties p, String prefix) {
            Properties result = new Properties();
            if (p != null) {
                Enumeration<?> e = p.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!key.startsWith(prefix)) continue;
                    result.put(key, p.get(key));
                }
            }
            return result;
        }

        private List<Dependency> getEsaDependency(List<Dependency> dependencies) {
            ArrayList<Dependency> deps = new ArrayList<Dependency>();
            if (dependencies != null) {
                for (Dependency d : dependencies) {
                    if (!"esa".equals(d.getType())) continue;
                    deps.add(d);
                }
            }
            return deps;
        }

        private List<Dependency> getCompileDependency(List<Dependency> dependencies) {
            ArrayList<Dependency> deps = new ArrayList<Dependency>();
            if (dependencies != null) {
                for (Dependency d : dependencies) {
                    if (!"compile".equals(d.getScope())) continue;
                    deps.add(d);
                }
            }
            return deps;
        }

        private boolean hasServerPropertyChanged(MavenProject project, MavenProject backupProject) {
            Properties projProp = project.getProperties();
            Properties backupProjProp = backupProject.getProperties();
            if (!Objects.equals(this.getPropertiesWithKeyPrefix(projProp, LIBERTY_BOOTSTRAP_PROP), this.getPropertiesWithKeyPrefix(backupProjProp, LIBERTY_BOOTSTRAP_PROP))) {
                return true;
            }
            if (!Objects.equals(this.getPropertiesWithKeyPrefix(projProp, LIBERTY_JVM_PROP), this.getPropertiesWithKeyPrefix(backupProjProp, LIBERTY_JVM_PROP))) {
                return true;
            }
            return !Objects.equals(this.getPropertiesWithKeyPrefix(projProp, LIBERTY_ENV_PROP), this.getPropertiesWithKeyPrefix(backupProjProp, LIBERTY_ENV_PROP));
        }

        private boolean hasServerVariableChanged(MavenProject project, MavenProject backupProject) {
            Properties projProp = project.getProperties();
            Properties backupProjProp = backupProject.getProperties();
            if (!Objects.equals(this.getPropertiesWithKeyPrefix(projProp, LIBERTY_VAR_PROP), this.getPropertiesWithKeyPrefix(backupProjProp, LIBERTY_VAR_PROP))) {
                return true;
            }
            return !Objects.equals(this.getPropertiesWithKeyPrefix(projProp, LIBERTY_DEFAULT_VAR_PROP), this.getPropertiesWithKeyPrefix(backupProjProp, LIBERTY_DEFAULT_VAR_PROP));
        }

        private boolean restartForLibertyMojoConfigChanged(Xpp3Dom config, Xpp3Dom oldConfig) {
            if (!Objects.equals(config.getChild("bootstrapProperties"), oldConfig.getChild("bootstrapProperties"))) {
                return true;
            }
            if (!Objects.equals(config.getChild("bootstrapPropertiesFile"), oldConfig.getChild("bootstrapPropertiesFile"))) {
                return true;
            }
            if (!Objects.equals(config.getChild("jvmOptions"), oldConfig.getChild("jvmOptions"))) {
                return true;
            }
            if (!Objects.equals(config.getChild("jvmOptionsFile"), oldConfig.getChild("jvmOptionsFile"))) {
                return true;
            }
            if (!Objects.equals(config.getChild("serverEnv"), oldConfig.getChild("serverEnv"))) {
                return true;
            }
            if (!Objects.equals(config.getChild("serverEnvFile"), oldConfig.getChild("serverEnvFile"))) {
                return true;
            }
            return !Objects.equals(config.getChild("configDirectory"), oldConfig.getChild("configDirectory"));
        }

        public boolean updateArtifactPaths(ProjectModule projectModule, boolean redeployCheck, ThreadPoolExecutor executor) throws PluginExecutionException {
            try {
                MavenProject upstreamProject;
                MavenProject backupUpstreamProject = upstreamProject = this.getMavenProject(projectModule.getBuildFile());
                for (MavenProject p : this.upstreamMavenProjects) {
                    if (this.buildFile == null || !p.getFile().getCanonicalPath().equals(this.buildFile.getCanonicalPath())) continue;
                    backupUpstreamProject = p;
                }
                JavaCompilerOptions oldCompilerOptions = DevMojo.this.getMavenCompilerOptions(backupUpstreamProject);
                JavaCompilerOptions compilerOptions = DevMojo.this.getMavenCompilerOptions(upstreamProject);
                if (!oldCompilerOptions.getOptions().equals(compilerOptions.getOptions())) {
                    DevMojo.this.log.debug((CharSequence)("Maven compiler options have been modified: " + compilerOptions.getOptions()));
                    DevMojo.this.util.getProjectModule(this.buildFile).setCompilerOptions(compilerOptions);
                }
                Set testArtifactPaths = projectModule.getTestArtifacts();
                Set compileArtifactPaths = projectModule.getCompileArtifacts();
                if (this.parentBuildFiles.isEmpty()) {
                    compileArtifactPaths.clear();
                    testArtifactPaths.clear();
                } else {
                    testArtifactPaths.removeAll(backupUpstreamProject.getTestClasspathElements());
                    compileArtifactPaths.removeAll(backupUpstreamProject.getCompileClasspathElements());
                }
                testArtifactPaths.addAll(upstreamProject.getTestClasspathElements());
                compileArtifactPaths.addAll(upstreamProject.getCompileClasspathElements());
                if (!this.parentBuildFiles.isEmpty() && this.parentBuildFiles.containsKey(projectModule.getBuildFile().getCanonicalPath())) {
                    this.updateArtifactPaths(projectModule.getBuildFile());
                }
                if (redeployCheck) {
                    int index = this.upstreamMavenProjects.indexOf(backupUpstreamProject);
                    this.upstreamMavenProjects.set(index, upstreamProject);
                    List deps = upstreamProject.getDependencies();
                    List oldDeps = backupUpstreamProject.getDependencies();
                    if (!deps.equals(oldDeps) && !this.getCompileDependency(deps).equals(this.getCompileDependency(oldDeps))) {
                        DevMojo.this.runLibertyMojoDeploy();
                    }
                }
            }
            catch (IOException | DependencyResolutionRequiredException | MojoExecutionException | ProjectBuildingException e) {
                DevMojo.this.log.error((CharSequence)("An unexpected error occurred while processing changes in " + this.buildFile.getAbsolutePath() + ": " + e.getMessage()));
                DevMojo.this.log.debug(e);
                return false;
            }
            return true;
        }

        public boolean updateArtifactPaths(File buildFile) {
            try {
                MavenProject parentProject = this.getMavenProject(buildFile);
                this.updateChildProjectArtifactPaths(buildFile, parentProject.getCompileClasspathElements(), parentProject.getTestClasspathElements());
            }
            catch (IOException | DependencyResolutionRequiredException | ProjectBuildingException e) {
                DevMojo.this.log.error((CharSequence)("An unexpected error occurred while processing changes in " + buildFile.getAbsolutePath() + ": " + e.getMessage()));
                DevMojo.this.log.debug(e);
                return false;
            }
            return true;
        }

        private void updateChildProjectArtifactPaths(File parentBuildFile, List<String> compileClasspathElements, List<String> testClasspathElements) throws IOException, ProjectBuildingException, DependencyResolutionRequiredException {
            List childBuildFiles = (List)this.parentBuildFiles.get(parentBuildFile.getCanonicalPath());
            if (childBuildFiles != null) {
                for (String childBuildPath : childBuildFiles) {
                    if (this.parentBuildFiles.containsKey(childBuildPath)) {
                        MavenProject project = this.getMavenProject(new File(childBuildPath));
                        if (project != null) {
                            compileClasspathElements.addAll(project.getCompileClasspathElements());
                            testClasspathElements.addAll(project.getTestClasspathElements());
                        }
                        this.updateChildProjectArtifactPaths(new File(childBuildPath), compileClasspathElements, testClasspathElements);
                        continue;
                    }
                    Set compileArtifacts = null;
                    Set testArtifacts = null;
                    MavenProject project = null;
                    if (childBuildPath.equals(this.buildFile.getCanonicalPath())) {
                        compileArtifacts = DevMojo.this.util.getCompileArtifacts();
                        testArtifacts = DevMojo.this.util.getTestArtifacts();
                        project = this.getMavenProject(this.buildFile);
                    } else if (this.getProjectModule(new File(childBuildPath)) != null) {
                        ProjectModule projectModule = this.getProjectModule(new File(childBuildPath));
                        compileArtifacts = projectModule.getCompileArtifacts();
                        testArtifacts = projectModule.getTestArtifacts();
                        project = this.getMavenProject(projectModule.getBuildFile());
                    }
                    if (compileArtifacts == null || testArtifacts == null || project == null) continue;
                    compileArtifacts.clear();
                    testArtifacts.clear();
                    compileClasspathElements.addAll(project.getCompileClasspathElements());
                    testClasspathElements.addAll(project.getTestClasspathElements());
                    compileArtifacts.addAll(compileClasspathElements);
                    testArtifacts.addAll(testClasspathElements);
                }
            }
        }

        private MavenProject getMavenProject(File buildFile) throws ProjectBuildingException {
            ProjectBuildingResult build = DevMojo.this.mavenProjectBuilder.build(buildFile, DevMojo.this.session.getProjectBuildingRequest().setResolveDependencies(true));
            return build.getProject();
        }

        public boolean recompileBuildFile(File buildFile, Set<String> compileArtifactPaths, Set<String> testArtifactPaths, ThreadPoolExecutor executor) throws PluginExecutionException {
            ProjectBuildingResult build;
            boolean restartServer = false;
            boolean createServer = false;
            boolean installFeature = false;
            boolean redeployApp = false;
            boolean runBoostPackage = false;
            try {
                build = DevMojo.this.mavenProjectBuilder.build(buildFile, DevMojo.this.session.getProjectBuildingRequest().setResolveDependencies(true));
            }
            catch (ProjectBuildingException e) {
                DevMojo.this.log.error((CharSequence)("Could not parse pom.xml. " + e.getMessage()));
                DevMojo.this.log.debug((Throwable)e);
                return false;
            }
            Plugin backupLibertyPlugin = DevMojo.this.getLibertyPlugin();
            MavenProject backupProject = DevMojo.this.project;
            DevMojo.this.project = build.getProject();
            DevMojo.this.session.setCurrentProject(DevMojo.this.project);
            Plugin libertyPlugin = DevMojo.this.getLibertyPlugin();
            try {
                List oldDeps;
                List deps;
                Xpp3Dom oldConfig;
                Xpp3Dom config;
                JavaCompilerOptions oldCompilerOptions = DevMojo.this.getMavenCompilerOptions(backupProject);
                JavaCompilerOptions compilerOptions = DevMojo.this.getMavenCompilerOptions(DevMojo.this.project);
                if (!oldCompilerOptions.getOptions().equals(compilerOptions.getOptions())) {
                    DevMojo.this.log.debug((CharSequence)("Maven compiler options have been modified: " + compilerOptions.getOptions()));
                    DevMojo.this.util.updateJavaCompilerOptions(compilerOptions);
                }
                if (this.hasServerPropertyChanged(DevMojo.this.project, backupProject)) {
                    restartServer = true;
                }
                if (!restartServer && this.hasServerVariableChanged(DevMojo.this.project, backupProject)) {
                    createServer = true;
                }
                if (!restartServer && !Objects.equals(config = ExecuteMojoUtil.getPluginGoalConfig(libertyPlugin, "create", DevMojo.this.log), oldConfig = ExecuteMojoUtil.getPluginGoalConfig(backupLibertyPlugin, "create", DevMojo.this.log))) {
                    createServer = true;
                    if (this.restartForLibertyMojoConfigChanged(config, oldConfig)) {
                        restartServer = true;
                    }
                }
                if (!Objects.equals(config = ExecuteMojoUtil.getPluginGoalConfig(libertyPlugin, "install-feature", DevMojo.this.log), oldConfig = ExecuteMojoUtil.getPluginGoalConfig(backupLibertyPlugin, "install-feature", DevMojo.this.log))) {
                    installFeature = true;
                }
                if (!Objects.equals(config = ExecuteMojoUtil.getPluginGoalConfig(libertyPlugin, "deploy", DevMojo.this.log), oldConfig = ExecuteMojoUtil.getPluginGoalConfig(backupLibertyPlugin, "deploy", DevMojo.this.log))) {
                    redeployApp = true;
                }
                if (!(deps = DevMojo.this.project.getDependencies()).equals(oldDeps = backupProject.getDependencies())) {
                    runBoostPackage = true;
                    if (!this.getEsaDependency(deps).equals(this.getEsaDependency(oldDeps))) {
                        installFeature = true;
                    }
                    if (!this.getCompileDependency(deps).equals(this.getCompileDependency(oldDeps))) {
                        redeployApp = true;
                    }
                }
                if (this.parentBuildFiles.isEmpty()) {
                    compileArtifactPaths.clear();
                    testArtifactPaths.clear();
                } else {
                    testArtifactPaths.removeAll(backupProject.getTestClasspathElements());
                    compileArtifactPaths.removeAll(backupProject.getCompileClasspathElements());
                }
                compileArtifactPaths.addAll(DevMojo.this.project.getCompileClasspathElements());
                testArtifactPaths.addAll(DevMojo.this.project.getTestClasspathElements());
                if (restartServer) {
                    DevMojo.this.util.restartServer();
                    return true;
                }
                if (DevMojo.this.isUsingBoost() && (createServer || runBoostPackage)) {
                    DevMojo.this.log.info((CharSequence)"Running boost:package");
                    DevMojo.this.runBoostMojo("package");
                } else if (createServer) {
                    DevMojo.this.runLibertyMojoCreate();
                } else if (redeployApp) {
                    DevMojo.this.runLibertyMojoDeploy();
                }
                if (installFeature) {
                    DevMojo.this.runLibertyMojoInstallFeature(null, super.getContainerName());
                }
                if (!(restartServer || createServer || redeployApp || installFeature || runBoostPackage)) {
                    DevMojo.this.log.debug((CharSequence)"changes in the pom.xml are not monitored by dev mode");
                    return true;
                }
            }
            catch (DependencyResolutionRequiredException | MojoExecutionException | ProjectBuildingException e) {
                DevMojo.this.log.error((CharSequence)("An unexpected error occurred while processing changes in pom.xml. " + e.getMessage()));
                DevMojo.this.log.debug(e);
                DevMojo.this.project = backupProject;
                DevMojo.this.session.setCurrentProject(backupProject);
                return false;
            }
            return true;
        }

        public void checkConfigFile(File configFile, File serverDir) {
            try {
                ServerFeature servUtil = DevMojo.this.getServerFeatureUtil();
                Set features = servUtil.getServerFeatures(serverDir, this.libertyDirPropertyFiles);
                if (features != null) {
                    features.removeAll(this.existingFeatures);
                    if (!features.isEmpty()) {
                        DevMojo.this.log.info((CharSequence)"Configuration features have been added");
                        MojoExecutor.Element[] featureElems = new MojoExecutor.Element[features.size() + 1];
                        featureElems[0] = MojoExecutor.element((String)MojoExecutor.name((String)"acceptLicense"), (String)"true");
                        String[] values = features.toArray(new String[features.size()]);
                        for (int i = 0; i < features.size(); ++i) {
                            featureElems[i + 1] = MojoExecutor.element((String)MojoExecutor.name((String)"feature"), (String)values[i]);
                        }
                        DevMojo.this.runLibertyMojoInstallFeature(MojoExecutor.element((String)MojoExecutor.name((String)"features"), (MojoExecutor.Element[])featureElems), super.getContainerName());
                        this.existingFeatures.addAll(features);
                    }
                }
            }
            catch (MojoExecutionException e) {
                DevMojo.this.log.error((CharSequence)"Failed to install features from configuration file", (Throwable)e);
            }
        }

        public boolean compile(File dir) {
            try {
                if (dir.equals(DevMojo.this.sourceDirectory)) {
                    DevMojo.this.runCompileMojoLogWarning();
                    DevMojo.this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "resources");
                }
                if (dir.equals(DevMojo.this.testSourceDirectory)) {
                    DevMojo.this.runTestCompileMojoLogWarning();
                    DevMojo.this.runMojo("org.apache.maven.plugins", "maven-resources-plugin", "testResources");
                }
                return true;
            }
            catch (MojoExecutionException e) {
                DevMojo.this.log.error((CharSequence)"Unable to compile", (Throwable)e);
                return false;
            }
        }

        public boolean compile(File dir, ProjectModule project) {
            MavenProject mavenProject = DevMojo.this.resolveMavenProject(project.getBuildFile());
            try {
                if (dir.equals(project.getSourceDirectory())) {
                    DevMojo.this.runCompileMojoLogWarning(mavenProject);
                    DevMojo.this.runMojoForProject("org.apache.maven.plugins", "maven-resources-plugin", "resources", mavenProject);
                }
                if (dir.equals(project.getTestSourceDirectory())) {
                    DevMojo.this.runTestCompileMojoLogWarning(mavenProject);
                    DevMojo.this.runMojoForProject("org.apache.maven.plugins", "maven-resources-plugin", "testResources", mavenProject);
                }
                return true;
            }
            catch (MojoExecutionException e) {
                DevMojo.this.log.error((CharSequence)"Unable to compile", (Throwable)e);
                return false;
            }
        }

        public void runUnitTests(File buildFile) throws PluginExecutionException, PluginScenarioException {
            MavenProject currentProject = DevMojo.this.resolveMavenProject(buildFile);
            try {
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-surefire-plugin", "test", currentProject);
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-surefire-report-plugin", "report-only", currentProject);
            }
            catch (MojoExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof MojoFailureException) {
                    throw new PluginScenarioException("Unit tests failed: " + cause.getLocalizedMessage(), (Throwable)e);
                }
                throw new PluginExecutionException("Failed to run unit tests", (Throwable)e);
            }
        }

        public void runIntegrationTests(File buildFile) throws PluginExecutionException, PluginScenarioException {
            MavenProject currentProject = DevMojo.this.resolveMavenProject(buildFile);
            try {
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-failsafe-plugin", "integration-test", currentProject);
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-surefire-report-plugin", "failsafe-report-only", currentProject);
                DevMojo.this.runTestMojo("org.apache.maven.plugins", "maven-failsafe-plugin", "verify", currentProject);
            }
            catch (MojoExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof MojoFailureException) {
                    throw new PluginScenarioException("Integration tests failed: " + cause.getLocalizedMessage(), (Throwable)e);
                }
                throw new PluginExecutionException("Failed to run integration tests", (Throwable)e);
            }
        }

        public void redeployApp() throws PluginExecutionException {
            try {
                DevMojo.this.runLibertyMojoDeploy();
            }
            catch (MojoExecutionException e) {
                throw new PluginExecutionException("liberty:deploy goal failed:" + e.getMessage());
            }
        }

        public boolean isLooseApplication() {
            return DeployMojoSupport.isSupportedLooseAppType(DevMojo.this.project.getPackaging());
        }
    }
}

