/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.maven.server.StartDebugMojoSupport;
import java.io.File;
import java.text.MessageFormat;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="dump", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DumpServerMojo
extends StartDebugMojoSupport {
    @Parameter(property="archive")
    private File archive;
    @Parameter(property="heapDump")
    private boolean heapDump;
    @Parameter(property="systemDump")
    private boolean systemDump;
    @Parameter(property="threadDump")
    private boolean threadDump;

    protected void doExecute() throws Exception {
        if (this.skip) {
            this.getLog().info((CharSequence)"\nSkipping dump goal.\n");
            return;
        }
        if (this.isInstall) {
            this.installServerAssembly();
        } else {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.type.preexisting"), ""));
            this.checkServerHomeExists();
            this.checkServerDirectoryExists();
        }
        ServerTask serverTask = this.initializeJava();
        this.copyConfigFiles();
        serverTask.setOperation("dump");
        serverTask.setArchive(this.archive);
        serverTask.setInclude(this.generateInclude());
        serverTask.execute();
    }

    private String generateInclude() {
        StringBuilder builder = new StringBuilder();
        if (this.heapDump) {
            builder.append("heap");
        }
        if (this.systemDump) {
            if (builder.length() != 0) {
                builder.append(",");
            }
            builder.append("system");
        }
        if (this.threadDump) {
            if (builder.length() != 0) {
                builder.append(",");
            }
            builder.append("thread");
        }
        return builder.length() == 0 ? null : builder.toString();
    }
}

