/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc;

import io.opentracing.ActiveSpan;
import io.opentracing.BaseSpan;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;

class JdbcTracingUtils {
    static final String COMPONENT_NAME = "java-jdbc";

    JdbcTracingUtils() {
    }

    static ActiveSpan buildSpan(String operationName, String sql, String dbType, String dbUser) {
        Tracer.SpanBuilder spanBuilder = GlobalTracer.get().buildSpan(operationName).withTag(Tags.SPAN_KIND.getKey(), "client");
        ActiveSpan span = spanBuilder.startActive();
        JdbcTracingUtils.decorate(span, sql, dbType, dbUser);
        return span;
    }

    private static void decorate(ActiveSpan span, String sql, String dbType, String dbUser) {
        Tags.COMPONENT.set((BaseSpan)span, COMPONENT_NAME);
        Tags.DB_STATEMENT.set((BaseSpan)span, sql);
        Tags.DB_TYPE.set((BaseSpan)span, dbType);
        if (dbUser != null) {
            Tags.DB_USER.set((BaseSpan)span, dbUser);
        }
    }
}

