/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc;

import io.opentracing.contrib.jdbc.TracingConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class TracingDriver
implements Driver {
    private static final Driver INSTANCE = new TracingDriver();

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null) {
            throw new SQLException("url is required");
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        String realUrl = this.extractRealUrl(url);
        String dbType = this.extractDbType(realUrl);
        String dbUser = info.getProperty("user");
        Driver wrappedDriver = this.findDriver(realUrl);
        Connection connection = wrappedDriver.connect(realUrl, info);
        return new TracingConnection(connection, dbType, dbUser);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url != null && url.startsWith("jdbc:tracing:");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.findDriver(url).getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    private Driver findDriver(String realUrl) throws SQLException {
        Driver wrappedDriver = null;
        for (Driver driver : this.registeredDrivers()) {
            try {
                if (!driver.acceptsURL(realUrl)) continue;
                wrappedDriver = driver;
                break;
            }
            catch (SQLException sQLException) {
            }
        }
        if (wrappedDriver == null) {
            throw new SQLException("Unable to find a driver that accepts " + realUrl);
        }
        return wrappedDriver;
    }

    private List<Driver> registeredDrivers() {
        ArrayList<Driver> result = new ArrayList<Driver>();
        Enumeration<Driver> driverEnumeration = DriverManager.getDrivers();
        while (driverEnumeration.hasMoreElements()) {
            result.add(driverEnumeration.nextElement());
        }
        return result;
    }

    private String extractRealUrl(String url) {
        return url.startsWith("jdbc:tracing:") ? url.replace("tracing:", "") : url;
    }

    private String extractDbType(String realUrl) {
        return realUrl.split(":")[1];
    }

    static {
        try {
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not register TracingDriver with DriverManager", e);
        }
    }
}

