/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc;

import io.opentracing.ActiveSpan;
import io.opentracing.contrib.jdbc.JdbcTracingUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class TracingStatement
implements Statement {
    private final Statement statement;
    private final ArrayList<String> batchCommands = new ArrayList();
    private final String dbType;
    private final String dbUser;

    TracingStatement(Statement statement, String dbType, String dbUser) {
        this.statement = statement;
        this.dbType = dbType;
        this.dbUser = dbUser;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try (ActiveSpan ignored = JdbcTracingUtils.buildSpan("Query", sql, this.dbType, this.dbUser);){
            ResultSet resultSet = this.statement.executeQuery(sql);
            return resultSet;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try (ActiveSpan ignored = JdbcTracingUtils.buildSpan("Update", sql, this.dbType, this.dbUser);){
            int n = this.statement.executeUpdate(sql);
            return n;
        }
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.statement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.statement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.statement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.statement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.statement.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try (ActiveSpan ignored = JdbcTracingUtils.buildSpan("Execute", sql, this.dbType, this.dbUser);){
            boolean bl = this.statement.execute(sql);
            return bl;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.statement.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.statement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.statement.addBatch(sql);
        this.batchCommands.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
        this.batchCommands.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try (ActiveSpan ignored = this.buildSpanForBatch(this.batchCommands, this.dbType, this.dbUser);){
            int[] nArray = this.statement.executeBatch();
            return nArray;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.statement.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.statement.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try (ActiveSpan ignored = JdbcTracingUtils.buildSpan("Update", sql, this.dbType, this.dbUser);){
            int n = this.statement.executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try (ActiveSpan ignored = JdbcTracingUtils.buildSpan("Update", sql, this.dbType, this.dbUser);){
            int n = this.statement.executeUpdate(sql, columnIndexes);
            return n;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try (ActiveSpan ignored = JdbcTracingUtils.buildSpan("Update", sql, this.dbType, this.dbUser);){
            int n = this.statement.executeUpdate(sql, columnNames);
            return n;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try (ActiveSpan ignored = JdbcTracingUtils.buildSpan("Execute", sql, this.dbType, this.dbUser);){
            boolean bl = this.statement.execute(sql, autoGeneratedKeys);
            return bl;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try (ActiveSpan ignored = JdbcTracingUtils.buildSpan("Execute", sql, this.dbType, this.dbUser);){
            boolean bl = this.statement.execute(sql, columnIndexes);
            return bl;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try (ActiveSpan ignored = JdbcTracingUtils.buildSpan("Execute", sql, this.dbType, this.dbUser);){
            boolean bl = this.statement.execute(sql, columnNames);
            return bl;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.statement.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.statement.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.statement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.statement.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.statement.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.statement.isWrapperFor(iface);
    }

    private ActiveSpan buildSpanForBatch(List<String> batchCommands, String dbType, String dbUser) {
        StringBuilder sql = new StringBuilder();
        for (String batchCommand : batchCommands) {
            sql.append(batchCommand);
        }
        return JdbcTracingUtils.buildSpan("Batch", sql.toString(), dbType, dbUser);
    }
}

