/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.tokenParser;

import com.mitchellbosecke.pebble.error.ParserException;
import com.mitchellbosecke.pebble.lexer.Token;
import com.mitchellbosecke.pebble.lexer.TokenStream;
import com.mitchellbosecke.pebble.node.BlockNode;
import com.mitchellbosecke.pebble.node.BodyNode;
import com.mitchellbosecke.pebble.node.RenderableNode;
import com.mitchellbosecke.pebble.parser.Parser;
import com.mitchellbosecke.pebble.parser.StoppingCondition;
import com.mitchellbosecke.pebble.tokenParser.AbstractTokenParser;

public class BlockTokenParser
extends AbstractTokenParser {
    @Override
    public RenderableNode parse(Token token, Parser parser) {
        TokenStream stream = parser.getStream();
        int lineNumber = token.getLineNumber();
        Token blockName = stream.next();
        if (!blockName.test(Token.Type.NAME) && !blockName.test(Token.Type.STRING)) {
            stream.expect(Token.Type.NAME);
        }
        String name = blockName.getValue();
        stream.next();
        stream.expect(Token.Type.EXECUTE_END);
        parser.pushBlockStack(name);
        BodyNode blockBody = parser.subparse(new StoppingCondition(){

            @Override
            public boolean evaluate(Token token) {
                return token.test(Token.Type.NAME, "endblock");
            }
        });
        parser.popBlockStack();
        Token endblock = stream.current();
        if (!endblock.test(Token.Type.NAME, "endblock")) {
            throw new ParserException(null, "endblock tag should be present with block tag starting line number ", token.getLineNumber(), stream.getFilename());
        }
        stream.next();
        Token current = stream.current();
        if (current.test(Token.Type.NAME, name) || current.test(Token.Type.STRING, name)) {
            stream.next();
        }
        stream.expect(Token.Type.EXECUTE_END);
        return new BlockNode(lineNumber, name, blockBody);
    }

    @Override
    public String getTag() {
        return "block";
    }
}

