/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.extension;

import com.mitchellbosecke.pebble.attributes.AttributeResolver;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.extension.NodeVisitorFactory;
import com.mitchellbosecke.pebble.extension.Test;
import com.mitchellbosecke.pebble.operator.BinaryOperator;
import com.mitchellbosecke.pebble.operator.UnaryOperator;
import com.mitchellbosecke.pebble.tokenParser.TokenParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtensionRegistry {
    private final Map<String, UnaryOperator> unaryOperators = new HashMap<String, UnaryOperator>();
    private final Map<String, BinaryOperator> binaryOperators = new HashMap<String, BinaryOperator>();
    private final Map<String, TokenParser> tokenParsers = new HashMap<String, TokenParser>();
    private final List<NodeVisitorFactory> nodeVisitors = new ArrayList<NodeVisitorFactory>();
    private final Map<String, Filter> filters = new HashMap<String, Filter>();
    private final Map<String, Test> tests = new HashMap<String, Test>();
    private final Map<String, Function> functions = new HashMap<String, Function>();
    private final Map<String, Object> globalVariables = new HashMap<String, Object>();
    private final List<AttributeResolver> attributeResolver = new ArrayList<AttributeResolver>();

    public ExtensionRegistry(Collection<? extends Extension> extensions) {
        for (Extension extension : extensions) {
            List<AttributeResolver> attributeResolvers;
            List<NodeVisitorFactory> nodeVisitors;
            Map<String, Object> globalVariables;
            Map<String, Function> functions;
            Map<String, Test> tests;
            Map<String, Filter> filters;
            List<UnaryOperator> list;
            List<BinaryOperator> binaryOperators;
            List<TokenParser> tokenParsers = extension.getTokenParsers();
            if (tokenParsers != null) {
                for (TokenParser tokenParser : tokenParsers) {
                    this.tokenParsers.put(tokenParser.getTag(), tokenParser);
                }
            }
            if ((binaryOperators = extension.getBinaryOperators()) != null) {
                for (Object operator : binaryOperators) {
                    if (this.binaryOperators.containsKey(operator.getSymbol())) continue;
                    this.binaryOperators.put(operator.getSymbol(), (BinaryOperator)operator);
                }
            }
            if ((list = extension.getUnaryOperators()) != null) {
                Object operator;
                operator = list.iterator();
                while (operator.hasNext()) {
                    UnaryOperator operator2 = (UnaryOperator)operator.next();
                    if (this.unaryOperators.containsKey(operator2.getSymbol())) continue;
                    this.unaryOperators.put(operator2.getSymbol(), operator2);
                }
            }
            if ((filters = extension.getFilters()) != null) {
                this.filters.putAll(filters);
            }
            if ((tests = extension.getTests()) != null) {
                this.tests.putAll(tests);
            }
            if ((functions = extension.getFunctions()) != null) {
                this.functions.putAll(functions);
            }
            if ((globalVariables = extension.getGlobalVariables()) != null) {
                this.globalVariables.putAll(globalVariables);
            }
            if ((nodeVisitors = extension.getNodeVisitors()) != null) {
                this.nodeVisitors.addAll(nodeVisitors);
            }
            if ((attributeResolvers = extension.getAttributeResolver()) == null) continue;
            this.attributeResolver.addAll(attributeResolvers);
        }
    }

    public Filter getFilter(String name) {
        return this.filters.get(name);
    }

    public Test getTest(String name) {
        return this.tests.get(name);
    }

    public Function getFunction(String name) {
        return this.functions.get(name);
    }

    public Map<String, BinaryOperator> getBinaryOperators() {
        return this.binaryOperators;
    }

    public Map<String, UnaryOperator> getUnaryOperators() {
        return this.unaryOperators;
    }

    public List<NodeVisitorFactory> getNodeVisitors() {
        return this.nodeVisitors;
    }

    public Map<String, Object> getGlobalVariables() {
        return this.globalVariables;
    }

    public Map<String, TokenParser> getTokenParsers() {
        return this.tokenParsers;
    }

    public List<AttributeResolver> getAttributeResolver() {
        return this.attributeResolver;
    }
}

