/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.retry;

import io.qameta.allure.Aggregator;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.retry.RetryItem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class RetryPlugin
implements Aggregator {
    public static final String RETRY_BLOCK_NAME = "retries";

    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, Path outputDirectory) {
        Map<String, List> byHistory = launchesResults.stream().flatMap(results -> results.getAllResults().stream()).filter(result -> Objects.nonNull(result.getHistoryId())).collect(Collectors.toMap(TestResult::getHistoryId, xva$0 -> Arrays.asList(xva$0), this::merge));
        byHistory.forEach((historyId, results) -> this.findLatest((List<TestResult>)results).ifPresent(this.addRetries((List<TestResult>)results)));
    }

    private Consumer<TestResult> addRetries(List<TestResult> results) {
        return latest -> {
            List retries = results.stream().sorted(TestResult.comparingByTime()).filter(result -> !latest.equals(result)).map(this::prepareRetry).map(this::createRetryItem).collect(Collectors.toList());
            latest.addExtraBlock(RETRY_BLOCK_NAME, retries);
            Set statuses = retries.stream().map(RetryItem::getStatus).filter(status -> !status.equals((Object)latest.getStatus())).collect(Collectors.toSet());
            latest.setRetriesStatusChange(!statuses.isEmpty());
            latest.setRetriesCount(retries.size());
        };
    }

    private TestResult prepareRetry(TestResult result) {
        result.setHidden(true);
        result.setRetry(true);
        return result;
    }

    private RetryItem createRetryItem(TestResult result) {
        return new RetryItem().setStatus(result.getStatus()).setStatusDetails(result.getStatusMessage()).setTime(result.getTime()).setUid(result.getUid());
    }

    private Optional<TestResult> findLatest(List<TestResult> results) {
        return results.stream().filter(result -> !result.isHidden()).min(TestResult.comparingByTime());
    }

    private List<TestResult> merge(List<TestResult> first, List<TestResult> second) {
        ArrayList<TestResult> merged = new ArrayList<TestResult>();
        merged.addAll(first);
        merged.addAll(second);
        return merged;
    }
}

