/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import io.qameta.allure.Aggregator;
import io.qameta.allure.Aggregator2;
import io.qameta.allure.DefaultResultsVisitor;
import io.qameta.allure.Reader;
import io.qameta.allure.ReportStorage;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.FileSystemReportStorage;
import io.qameta.allure.core.InMemoryReportStorage;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.core.ReportWebGenerator;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.util.DeleteVisitor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportGenerator.class);
    private final Configuration configuration;

    public ReportGenerator(Configuration configuration) {
        this.configuration = configuration;
    }

    private LaunchResults readResults(Path resultsDirectory) {
        DefaultResultsVisitor visitor = new DefaultResultsVisitor(this.configuration);
        this.configuration.getExtensions(Reader.class).forEach(reader -> reader.readResults(this.configuration, (ResultsVisitor)visitor, resultsDirectory));
        return visitor.getLaunchResults();
    }

    private void aggregate(List<LaunchResults> results, ReportStorage storage) {
        this.processOldAggregators(results, storage);
        for (Aggregator2 aggregator : this.configuration.getExtensions(Aggregator2.class)) {
            aggregator.aggregate(this.configuration, results, storage);
        }
    }

    private void processOldAggregators(List<LaunchResults> results, final ReportStorage storage) {
        Path tempDir = null;
        try {
            tempDir = Files.createTempDirectory("allure-", new FileAttribute[0]);
            for (Aggregator aggregator : this.configuration.getExtensions(Aggregator.class)) {
                aggregator.aggregate(this.configuration, results, tempDir);
            }
            final Path finalTempDir = tempDir;
            Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String fileId = file.relativize(finalTempDir).toString();
                    storage.addDataFile(fileId, file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (Objects.nonNull(tempDir)) {
                try {
                    Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new DeleteVisitor());
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void generate(Path outputDirectory, List<Path> resultsDirectories) {
        this.generate(new FileSystemReportStorage(outputDirectory), outputDirectory, resultsDirectories);
    }

    public void generate(Path outputDirectory, Path ... resultsDirectories) {
        this.generate(outputDirectory, Arrays.asList(resultsDirectories));
    }

    private void generate(ReportStorage storage, Path outputDirectory, List<Path> resultsDirectories) {
        List<LaunchResults> results = resultsDirectories.stream().filter(this::isValidResultsDirectory).map(this::readResults).collect(Collectors.toList());
        this.aggregate(results, storage);
        new ReportWebGenerator().generate(this.configuration, storage, outputDirectory);
    }

    public void generateSingleFile(Path outputDirectory, List<Path> resultsDirectories) {
        InMemoryReportStorage storage = new InMemoryReportStorage();
        this.generate(storage, outputDirectory, resultsDirectories);
    }

    private boolean isValidResultsDirectory(Path resultsDirectory) {
        if (Files.notExists(resultsDirectory, new LinkOption[0])) {
            LOGGER.warn("{} does not exist", (Object)resultsDirectory);
            return false;
        }
        if (!Files.isDirectory(resultsDirectory, new LinkOption[0])) {
            LOGGER.warn("{} is not a directory", (Object)resultsDirectory);
            return false;
        }
        return true;
    }
}

