/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.category;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.qameta.allure.Aggregator2;
import io.qameta.allure.CommonJsonAggregator2;
import io.qameta.allure.category.CategoriesTrendItem;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.executor.ExecutorPlugin;
import io.qameta.allure.trend.AbstractTrendPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CategoriesTrendPlugin
extends AbstractTrendPlugin<CategoriesTrendItem> {
    private static final String JSON_FILE_NAME = "categories-trend.json";
    public static final String CATEGORIES_TREND_BLOCK_NAME = "categories-trend";

    public CategoriesTrendPlugin() {
        super(Arrays.asList(new Aggregator2[]{new JsonAggregator(), new WidgetAggregator()}), JSON_FILE_NAME, CATEGORIES_TREND_BLOCK_NAME);
    }

    @Override
    protected Optional<CategoriesTrendItem> parseItem(ObjectMapper mapper, JsonNode child) throws JsonProcessingException {
        return Optional.ofNullable((CategoriesTrendItem)mapper.treeToValue((TreeNode)child, CategoriesTrendItem.class));
    }

    protected static List<CategoriesTrendItem> getData(List<LaunchResults> launchesResults) {
        CategoriesTrendItem item = CategoriesTrendPlugin.createCurrent(launchesResults);
        List<CategoriesTrendItem> data = CategoriesTrendPlugin.getHistoryItems(launchesResults);
        return Stream.concat(Stream.of(item), data.stream()).limit(20L).collect(Collectors.toList());
    }

    private static List<CategoriesTrendItem> getHistoryItems(List<LaunchResults> launchesResults) {
        return launchesResults.stream().map(CategoriesTrendPlugin::getPreviousTrendData).reduce(new ArrayList(), (first, second) -> {
            first.addAll(second);
            return first;
        });
    }

    private static List<CategoriesTrendItem> getPreviousTrendData(LaunchResults results) {
        return (List)results.getExtra(CATEGORIES_TREND_BLOCK_NAME, ArrayList::new);
    }

    private static CategoriesTrendItem createCurrent(List<LaunchResults> launchesResults) {
        CategoriesTrendItem item = new CategoriesTrendItem();
        ExecutorPlugin.getLatestExecutor(launchesResults).ifPresent(info -> {
            item.setBuildOrder(info.getBuildOrder());
            item.setReportName(info.getReportName());
            item.setReportUrl(info.getReportUrl());
        });
        launchesResults.stream().flatMap(launch -> launch.getAllResults().stream()).forEach(item::increaseCategories);
        return item;
    }

    private static class JsonAggregator
    extends CommonJsonAggregator2 {
        JsonAggregator() {
            super("history", CategoriesTrendPlugin.JSON_FILE_NAME);
        }

        protected List<CategoriesTrendItem> getData(List<LaunchResults> launches) {
            return CategoriesTrendPlugin.getData(launches);
        }
    }

    private static class WidgetAggregator
    extends CommonJsonAggregator2 {
        WidgetAggregator() {
            super("widgets", CategoriesTrendPlugin.JSON_FILE_NAME);
        }

        public List<CategoriesTrendItem> getData(List<LaunchResults> launches) {
            return CategoriesTrendPlugin.getData(launches);
        }
    }
}

