/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.mail;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.qameta.allure.Aggregator2;
import io.qameta.allure.Constants;
import io.qameta.allure.ReportStorage;
import io.qameta.allure.context.FreemarkerContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailPlugin
implements Aggregator2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailPlugin.class);

    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, ReportStorage storage) {
        FreemarkerContext context = (FreemarkerContext)configuration.requireContext(FreemarkerContext.class);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);){
            Template template = context.getValue().getTemplate("mail.html.ftl");
            template.process(new HashMap(), (Writer)writer);
            storage.addDataBinary(Constants.exportPath((String[])new String[]{"mail.html"}), bos.toByteArray());
        }
        catch (TemplateException e) {
            LOGGER.error("Couldn't write mail file", (Throwable)e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

