/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.internal.shadowed.jackson.databind.ser.std;

import io.qameta.allure.internal.shadowed.jackson.core.JsonGenerator;
import io.qameta.allure.internal.shadowed.jackson.core.JsonToken;
import io.qameta.allure.internal.shadowed.jackson.core.type.WritableTypeId;
import io.qameta.allure.internal.shadowed.jackson.databind.JavaType;
import io.qameta.allure.internal.shadowed.jackson.databind.JsonMappingException;
import io.qameta.allure.internal.shadowed.jackson.databind.JsonNode;
import io.qameta.allure.internal.shadowed.jackson.databind.SerializerProvider;
import io.qameta.allure.internal.shadowed.jackson.databind.annotation.JacksonStdImpl;
import io.qameta.allure.internal.shadowed.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import io.qameta.allure.internal.shadowed.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import io.qameta.allure.internal.shadowed.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.qameta.allure.internal.shadowed.jackson.databind.jsontype.TypeSerializer;
import io.qameta.allure.internal.shadowed.jackson.databind.node.ObjectNode;
import io.qameta.allure.internal.shadowed.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, byte[] value) {
        return value.length == 0;
    }

    @Override
    public void serialize(byte[] value, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
    }

    @Override
    public void serializeWithType(byte[] value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("byte");
        return o.set("items", itemSchema);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

