/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.junit4;

import io.qameta.allure.Allure;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.Epic;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Link;
import io.qameta.allure.Owner;
import io.qameta.allure.Severity;
import io.qameta.allure.Story;
import io.qameta.allure.TmsLink;
import io.qameta.allure.junit4.DisplayName;
import io.qameta.allure.junit4.Tag;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import io.qameta.allure.util.ResultsUtils;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

@RunListener.ThreadSafe
public class AllureJunit4
extends RunListener {
    public static final String MD_5 = "md5";
    private final ThreadLocal<String> testCases = InheritableThreadLocal.withInitial(() -> UUID.randomUUID().toString());
    private final AllureLifecycle lifecycle;

    public AllureJunit4() {
        this(Allure.getLifecycle());
    }

    public AllureJunit4(AllureLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public AllureLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void testRunStarted(Description description) throws Exception {
    }

    public void testRunFinished(Result result) throws Exception {
    }

    public void testStarted(Description description) throws Exception {
        String uuid = this.testCases.get();
        TestResult result = this.createTestResult(uuid, description);
        this.getLifecycle().scheduleTestCase(result);
        this.getLifecycle().startTestCase(uuid);
    }

    public void testFinished(Description description) throws Exception {
        String uuid = this.testCases.get();
        this.testCases.remove();
        this.getLifecycle().updateTestCase(uuid, testResult -> {
            if (Objects.isNull(testResult.getStatus())) {
                testResult.setStatus(Status.PASSED);
            }
        });
        this.getLifecycle().stopTestCase(uuid);
        this.getLifecycle().writeTestCase(uuid);
    }

    public void testFailure(Failure failure) throws Exception {
        String uuid = this.testCases.get();
        this.getLifecycle().updateTestCase(uuid, testResult -> testResult.withStatus((Status)ResultsUtils.getStatus((Throwable)failure.getException()).orElse(null)).withStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)failure.getException()).orElse(null)));
    }

    public void testAssumptionFailure(Failure failure) {
        String uuid = this.testCases.get();
        this.getLifecycle().updateTestCase(uuid, testResult -> testResult.withStatus(Status.SKIPPED).withStatusDetails((StatusDetails)ResultsUtils.getStatusDetails((Throwable)failure.getException()).orElse(null)));
    }

    public void testIgnored(Description description) throws Exception {
        String uuid = this.testCases.get();
        this.testCases.remove();
        TestResult result = this.createTestResult(uuid, description);
        result.setStatus(Status.SKIPPED);
        result.setStatusDetails(this.getIgnoredMessage(description));
        result.setStart(Long.valueOf(System.currentTimeMillis()));
        this.getLifecycle().scheduleTestCase(result);
        this.getLifecycle().stopTestCase(uuid);
        this.getLifecycle().writeTestCase(uuid);
    }

    private Optional<String> getDisplayName(Description result) {
        return Optional.ofNullable(result.getAnnotation(DisplayName.class)).map(DisplayName::value);
    }

    private List<io.qameta.allure.model.Link> getLinks(Description result) {
        return Stream.of(this.getAnnotationsOnClass(result, Link.class).stream().map(ResultsUtils::createLink), this.getAnnotationsOnMethod(result, Link.class).stream().map(ResultsUtils::createLink), this.getAnnotationsOnClass(result, Issue.class).stream().map(ResultsUtils::createLink), this.getAnnotationsOnMethod(result, Issue.class).stream().map(ResultsUtils::createLink), this.getAnnotationsOnClass(result, TmsLink.class).stream().map(ResultsUtils::createLink), this.getAnnotationsOnMethod(result, TmsLink.class).stream().map(ResultsUtils::createLink)).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
    }

    private List<Label> getLabels(Description result) {
        return Stream.of(this.getLabels(result, Epic.class, ResultsUtils::createLabel), this.getLabels(result, Feature.class, ResultsUtils::createLabel), this.getLabels(result, Story.class, ResultsUtils::createLabel), this.getLabels(result, Severity.class, ResultsUtils::createLabel), this.getLabels(result, Owner.class, ResultsUtils::createLabel), this.getLabels(result, Tag.class, this::createLabel)).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
    }

    private <T extends Annotation> Stream<Label> getLabels(Description result, Class<T> labelAnnotation, Function<T, Label> extractor) {
        List labels = this.getAnnotationsOnMethod(result, labelAnnotation).stream().map(extractor).collect(Collectors.toList());
        if (labelAnnotation.isAnnotationPresent(Repeatable.class) || labels.isEmpty()) {
            Stream<Label> onClassLabels = this.getAnnotationsOnClass(result, labelAnnotation).stream().map(extractor);
            labels.addAll(onClassLabels.collect(Collectors.toList()));
        }
        return labels.stream();
    }

    private Label createLabel(Tag tag) {
        return new Label().withName("tag").withValue(tag.value());
    }

    private <T extends Annotation> List<T> getAnnotationsOnMethod(Description result, Class<T> clazz) {
        Annotation annotation = result.getAnnotation(clazz);
        return Stream.concat(this.extractRepeatable(result, clazz).stream(), Objects.isNull(annotation) ? Stream.empty() : Stream.of(annotation)).collect(Collectors.toList());
    }

    private <T extends Annotation> List<T> extractRepeatable(Description result, Class<T> clazz) {
        Repeatable repeatable;
        Class<? extends Annotation> wrapper;
        Annotation annotation;
        if (clazz.isAnnotationPresent(Repeatable.class) && Objects.nonNull(annotation = result.getAnnotation(wrapper = (repeatable = clazz.getAnnotation(Repeatable.class)).value()))) {
            try {
                Method value = annotation.getClass().getMethod("value", new Class[0]);
                Object annotations = value.invoke((Object)annotation, new Object[0]);
                return Arrays.asList((Annotation[])annotations);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return Collections.emptyList();
    }

    private <T extends Annotation> List<T> getAnnotationsOnClass(Description result, Class<T> clazz) {
        return Stream.of(result).map(Description::getTestClass).map(testClass -> testClass.getAnnotationsByType(clazz)).flatMap(Stream::of).collect(Collectors.toList());
    }

    private String getHistoryId(Description description) {
        return this.md5(description.getClassName() + description.getMethodName());
    }

    private String md5(String source) {
        byte[] bytes = this.getMessageDigest().digest(source.getBytes(StandardCharsets.UTF_8));
        return new BigInteger(1, bytes).toString(16);
    }

    private MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(MD_5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not find md5 hashing algorithm", e);
        }
    }

    private String getPackage(Class<?> testClass) {
        return Optional.of(testClass).map(Class::getPackage).map(Package::getName).orElse("");
    }

    private StatusDetails getIgnoredMessage(Description description) {
        Ignore ignore = (Ignore)description.getAnnotation(Ignore.class);
        String message = Objects.nonNull(ignore) && !ignore.value().isEmpty() ? ignore.value() : "Test ignored (without reason)!";
        return new StatusDetails().withMessage(message);
    }

    private TestResult createTestResult(String uuid, Description description) {
        String className = description.getClassName();
        String methodName = description.getMethodName();
        String name = Objects.nonNull(methodName) ? methodName : className;
        String fullName = Objects.nonNull(methodName) ? String.format("%s.%s", className, methodName) : className;
        TestResult testResult = new TestResult().withUuid(uuid).withHistoryId(this.getHistoryId(description)).withName(name).withFullName(fullName).withLinks(this.getLinks(description)).withLabels(new Label[]{new Label().withName("package").withValue(this.getPackage(description.getTestClass())), new Label().withName("testClass").withValue(className), new Label().withName("testMethod").withValue(name), new Label().withName("suite").withValue(className), new Label().withName("host").withValue(ResultsUtils.getHostName()), new Label().withName("thread").withValue(ResultsUtils.getThreadName())});
        testResult.getLabels().addAll(this.getLabels(description));
        this.getDisplayName(description).ifPresent(arg_0 -> ((TestResult)testResult).setName(arg_0));
        return testResult;
    }
}

