/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.qameta.allure.maven.AllureBaseMojo;
import io.qameta.allure.maven.AllureCommandline;
import io.qameta.allure.maven.ProxyUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;

public abstract class AllureGenerateMojo
extends AllureBaseMojo {
    public static final String ALLURE_OLD_PROPERTIES = "allure.properties";
    public static final String ALLURE_NEW_PROPERTIES = "report.properties";
    public static final String CATEGORIES_FILE_NAME = "categories.json";
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    protected String buildDirectory;
    @Parameter(defaultValue="${project.reporting.outputDirectory}", readonly=true)
    protected String reportingOutputDirectory;
    @Parameter(property="allure.results.directory", defaultValue="allure-results/")
    protected String resultsDirectory;
    @Parameter(property="report.version")
    protected String reportVersion;
    @Parameter(property="allure.report.directory", defaultValue="${project.reporting.outputDirectory}/allure-maven-plugin")
    protected String reportDirectory;
    @Parameter(property="allure.report.timeout", defaultValue="60")
    protected int reportTimeout;
    @Parameter
    protected final Map<String, String> executorInfo = new HashMap<String, String>();
    @Parameter(defaultValue="report.properties")
    protected String propertiesFilePath;
    @Parameter(property="allure.install.directory", defaultValue="${project.basedir}/.allure")
    protected String installDirectory;
    @Parameter(property="allure.download.url")
    protected String allureDownloadUrl;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Component(role=SettingsDecrypter.class)
    protected SettingsDecrypter decrypter;
    @Component
    protected DependencyResolver dependencyResolver;
    @Parameter
    protected Map<String, String> properties = new HashMap<String, String>();
    @Parameter
    protected Boolean singleFile;

    protected String getOutputDirectory() {
        return this.getReportDirectory();
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        try {
            this.installAllure();
            this.getLog().info((CharSequence)String.format("Generate Allure report (%s) with version %s", this.getMojoName(), this.reportVersion != null ? this.reportVersion : "2.30.0"));
            this.getLog().info((CharSequence)("Generate Allure report to " + this.getReportDirectory()));
            List<Path> inputDirectories = this.getInputDirectories();
            if (inputDirectories.isEmpty()) {
                this.getLog().warn((CharSequence)"Allure report was skipped because there is no results directories found.");
                return;
            }
            this.loadProperties(inputDirectories);
            this.loadCategories(inputDirectories);
            this.copyExecutorInfo(inputDirectories);
            this.generateReport(inputDirectories);
            this.render(this.getSink(), this.getName(locale));
        }
        catch (Exception e) {
            throw new MavenReportException("Could not generate the report", e);
        }
    }

    private void copyExecutorInfo(List<Path> inputDirectories) throws IOException {
        this.addPropertyIfAbsent("name", "Maven");
        this.addPropertyIfAbsent("type", "maven");
        this.addPropertyIfAbsent("buildName", this.getProject() == null ? "N/A" : this.getProject().getName());
        ObjectMapper mapper = new ObjectMapper();
        for (Path dir : inputDirectories) {
            Path executorInfoFile = dir.resolve("executor.json");
            mapper.writeValue(executorInfoFile.toFile(), this.executorInfo);
        }
    }

    private void addPropertyIfAbsent(String key, String value) {
        if (!this.executorInfo.containsKey(key)) {
            this.executorInfo.put(key, value);
        }
    }

    private void loadCategories(List<Path> inputDirectories) throws URISyntaxException, IOException, DependencyResolutionRequiredException {
        URL categoriesUrl = this.createProjectClassLoader().getResource(CATEGORIES_FILE_NAME);
        if (categoriesUrl == null) {
            this.getLog().info((CharSequence)"Can't find information about categories");
            return;
        }
        for (Path dir : inputDirectories) {
            Path categories = Paths.get(categoriesUrl.toURI());
            Files.copy(categories, dir.resolve(CATEGORIES_FILE_NAME), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void loadProperties(List<Path> inputDirectories) throws IOException, DependencyResolutionRequiredException {
        Properties properties = new Properties();
        this.readPropertiesFile(properties);
        this.readPropertiesFileFromClasspath(ALLURE_OLD_PROPERTIES, properties);
        this.readPropertiesFileFromClasspath(ALLURE_NEW_PROPERTIES, properties);
        this.readPropertiesFromMap(properties);
        this.prepareProperties(properties);
        for (Path dir : inputDirectories) {
            try {
                OutputStream os = Files.newOutputStream(dir.resolve(ALLURE_OLD_PROPERTIES), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    properties.store(os, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (os == null) continue;
                    if (throwable != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    os.close();
                }
            }
            catch (IOException e) {
                this.getLog().info((CharSequence)String.format("Can't store properties in directory %s", dir.toString()), (Throwable)e);
            }
        }
    }

    private void installAllure() throws MavenReportException {
        try {
            AllureCommandline commandline = new AllureCommandline(Paths.get(this.installDirectory, new String[0]), this.reportVersion);
            this.getLog().info((CharSequence)String.format("Allure installation directory %s", this.installDirectory));
            this.getLog().info((CharSequence)String.format("Try to finding out allure %s", commandline.getVersion()));
            if (commandline.allureNotExists()) {
                if (StringUtils.isNotBlank((CharSequence)this.allureDownloadUrl)) {
                    this.getLog().info((CharSequence)("Downloading allure commandline from " + this.allureDownloadUrl));
                    commandline.download(this.allureDownloadUrl, ProxyUtils.getProxy(this.session, this.decrypter));
                    this.getLog().info((CharSequence)"Downloading allure commandline complete");
                } else {
                    commandline.downloadWithMaven(this.session, this.dependencyResolver);
                }
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Installation error", (Throwable)e);
            throw new MavenReportException("Can't install allure", (Exception)e);
        }
    }

    protected void generateReport(List<Path> resultsPaths) throws MavenReportException {
        try {
            Path reportPath = Paths.get(this.getReportDirectory(), new String[0]);
            AllureCommandline commandline = new AllureCommandline(Paths.get(this.getInstallDirectory(), new String[0]), this.reportVersion, this.reportTimeout);
            this.getLog().info((CharSequence)("Generate report to " + reportPath));
            commandline.generateReport(resultsPaths, reportPath, Boolean.TRUE.equals(this.singleFile));
            this.getLog().info((CharSequence)"Report generated successfully.");
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Generation error", (Throwable)e);
            throw new MavenReportException("Can't generate allure report data", e);
        }
    }

    protected void readPropertiesFile(Properties properties) throws IOException {
        Path path = Paths.get(this.propertiesFilePath, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                properties.load(is);
            }
        }
    }

    protected void readPropertiesFileFromClasspath(String propertiesFileName, Properties properties) throws IOException, DependencyResolutionRequiredException {
        try (InputStream is = this.createProjectClassLoader().getResourceAsStream(propertiesFileName);){
            if (is != null) {
                properties.load(is);
            }
        }
    }

    protected void readPropertiesFromMap(Properties properties) {
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            if (property.getKey() == null || property.getValue() == null) continue;
            properties.setProperty(property.getKey(), property.getValue());
        }
    }

    protected void prepareProperties(Properties properties) {
        Properties allProperties = new Properties();
        allProperties.putAll((Map<?, ?>)properties);
        allProperties.putAll((Map<?, ?>)(this.getProject() == null ? Collections.emptyMap() : this.getProject().getProperties()));
        allProperties.putAll((Map<?, ?>)System.getProperties());
        for (String name : properties.stringPropertyNames()) {
            properties.setProperty(name, StringSubstitutor.replace((Object)properties.getProperty(name), (Properties)allProperties));
        }
    }

    protected void render(Sink sink, String title) {
        sink.head();
        sink.title();
        sink.text(title);
        sink.title_();
        sink.head_();
        sink.body();
        sink.lineBreak();
        Path indexHtmlFile = Paths.get(this.getReportDirectory(), "index.html");
        String relativePath = Paths.get(this.reportingOutputDirectory, new String[0]).relativize(indexHtmlFile).toString();
        sink.rawText(String.format("<meta http-equiv=\"refresh\" content=\"0;url=%s\" />", relativePath));
        sink.link(relativePath);
        sink.body_();
        sink.flush();
        sink.close();
    }

    protected ClassLoader createProjectClassLoader() throws MalformedURLException, DependencyResolutionRequiredException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (String element : this.project.getTestClasspathElements()) {
            if (element == null) continue;
            URL url = Paths.get(element, new String[0]).toUri().toURL();
            result.add(url);
        }
        return new URLClassLoader(result.toArray(new URL[0]));
    }

    public boolean canGenerateReport() {
        return !this.isAggregate() || this.project.isExecutionRoot();
    }

    protected boolean isAggregate() {
        return false;
    }

    protected boolean isDirectoryExists(Path path) {
        return Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
    }

    protected abstract List<Path> getInputDirectories();

    protected abstract String getMojoName();

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    public String getInstallDirectory() {
        return this.installDirectory;
    }
}

