/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.maven;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProxyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyUtils.class);

    private ProxyUtils() {
        throw new IllegalStateException();
    }

    static Proxy getProxy(MavenSession mavenSession, SettingsDecrypter decrypter) {
        if (mavenSession == null || mavenSession.getSettings() == null || mavenSession.getSettings().getProxies() == null || mavenSession.getSettings().getProxies().isEmpty()) {
            LOGGER.info("Proxy is not specified.");
            return null;
        }
        List mavenProxies = mavenSession.getSettings().getProxies();
        for (Proxy proxy : mavenProxies) {
            block8: {
                if (!proxy.isActive()) continue;
                proxy = ProxyUtils.decryptProxy(proxy, decrypter);
                try {
                    Socket socket = new Socket(proxy.getHost(), proxy.getPort());
                    Throwable throwable = null;
                    if (socket == null) break block8;
                    if (throwable != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        socket.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.info(String.format("Proxy: %s:%s is not available", proxy.getHost(), proxy.getPort()));
                    continue;
                }
            }
            LOGGER.info(String.format("Found proxy: %s:%s", proxy.getHost(), proxy.getPort()));
            return proxy;
        }
        LOGGER.info("No active proxies found.");
        return null;
    }

    private static Proxy decryptProxy(Proxy proxy, SettingsDecrypter decrypter) {
        DefaultSettingsDecryptionRequest decryptionRequest = new DefaultSettingsDecryptionRequest(proxy);
        SettingsDecryptionResult decryptedResult = decrypter.decrypt((SettingsDecryptionRequest)decryptionRequest);
        return decryptedResult.getProxy();
    }
}

