/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.qameta.allure.maven.AllureBaseMojo;
import io.qameta.allure.maven.AllureCommandline;
import io.qameta.allure.maven.ProxyUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.crypto.SettingsDecrypter;

public abstract class AllureGenerateMojo
extends AllureBaseMojo {
    public static final String ALLURE_OLD_PROPERTIES = "allure.properties";
    public static final String ALLURE_NEW_PROPERTIES = "report.properties";
    public static final String CATEGORIES_FILE_NAME = "categories.json";
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    protected String buildDirectory;
    @Parameter(defaultValue="${project.reporting.outputDirectory}", readonly=true)
    protected String reportingOutputDirectory;
    @Parameter(property="allure.results.directory", defaultValue="allure-results/")
    protected String resultsDirectory;
    @Parameter(property="report.version")
    protected String reportVersion;
    @Parameter(property="allure.report.directory", defaultValue="${project.reporting.outputDirectory}/allure-maven-plugin")
    private String reportDirectory;
    @Parameter(property="allure.serve.timeout")
    protected String serveTimeout;
    @Parameter(defaultValue="report.properties")
    protected String propertiesFilePath;
    @Parameter(property="allure.install.directory", defaultValue="${project.basedir}/.allure")
    private String installDirectory;
    @Parameter(property="allure.download.url", defaultValue="https://dl.bintray.com/qameta/generic/io/qameta/allure/allure/%s/allure-%s.zip")
    private String allureDownloadUrl;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;
    @Parameter
    protected Map<String, String> properties = new HashMap<String, String>();

    protected String getOutputDirectory() {
        return this.getReportDirectory();
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        try {
            this.installAllure();
            this.getLog().info((CharSequence)String.format("Generate Allure report (%s) with version %s", this.getMojoName(), this.reportVersion != null ? this.reportVersion : "2.0.1"));
            this.getLog().info((CharSequence)("Generate Allure report to " + this.getReportDirectory()));
            List<Path> inputDirectories = this.getInputDirectories();
            if (inputDirectories.isEmpty()) {
                this.getLog().warn((CharSequence)"Allure report was skipped because there is no results directories found.");
                return;
            }
            this.loadProperties(inputDirectories);
            this.loadCategories(inputDirectories);
            this.copyExecutorInfo(inputDirectories);
            this.generateReport(inputDirectories);
            this.render(this.getSink(), this.getName(locale));
        }
        catch (Exception e) {
            throw new MavenReportException("Could not generate the report", e);
        }
    }

    private void copyExecutorInfo(List<Path> inputDirectories) throws IOException, DependencyResolutionRequiredException {
        HashMap<String, String> executorInfo = new HashMap<String, String>();
        executorInfo.put("name", "Maven");
        executorInfo.put("type", "maven");
        executorInfo.put("buildName", this.getProject().getName());
        for (Path dir : inputDirectories) {
            Path executorInfoFile = dir.resolve("executor.json");
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(executorInfoFile.toFile(), executorInfo);
        }
    }

    private void loadCategories(List<Path> inputDirectories) throws URISyntaxException, IOException, DependencyResolutionRequiredException {
        URL categoriesUrl = this.createProjectClassLoader().getResource(CATEGORIES_FILE_NAME);
        if (categoriesUrl == null) {
            this.getLog().info((CharSequence)String.format("Can't find information about categories.", new Object[0]));
            return;
        }
        for (Path dir : inputDirectories) {
            Path categories = Paths.get(categoriesUrl.toURI());
            Files.copy(categories, dir.resolve(CATEGORIES_FILE_NAME), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void loadProperties(List<Path> inputDirectories) throws IOException, DependencyResolutionRequiredException {
        Properties properties = new Properties();
        this.readPropertiesFile(properties);
        this.readPropertiesFileFromClasspath(ALLURE_OLD_PROPERTIES, properties);
        this.readPropertiesFileFromClasspath(ALLURE_NEW_PROPERTIES, properties);
        this.readPropertiesFromMap(properties);
        this.prepareProperties(properties);
        for (Path dir : inputDirectories) {
            try {
                FileOutputStream outputStream = new FileOutputStream(dir.resolve(ALLURE_OLD_PROPERTIES).toString());
                Throwable throwable = null;
                try {
                    properties.store(outputStream, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((OutputStream)outputStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((OutputStream)outputStream).close();
                }
            }
            catch (IOException e) {
                this.getLog().info((CharSequence)String.format("Can't store properties in directory %s", dir.toString()), (Throwable)e);
            }
        }
    }

    private void installAllure() throws MavenReportException {
        try {
            this.getLog().info((CharSequence)String.format("Allure installation directory %s", this.getInstallDirectory()));
            this.getLog().info((CharSequence)String.format("Try to finding out allure %s", this.reportVersion != null ? this.reportVersion : "2.0.1"));
            AllureCommandline commandline = new AllureCommandline(Paths.get(this.getInstallDirectory(), new String[0]), this.reportVersion);
            if (commandline.allureNotExists()) {
                this.getLog().info((CharSequence)"Downloading allure commandline...");
                commandline.download(this.allureDownloadUrl, ProxyUtils.getProxy(this.session, this.decrypter));
                this.getLog().info((CharSequence)"Downloading allure commandline complete");
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Can't install allure", (Throwable)e);
            throw new MavenReportException("Can't install allure", e);
        }
    }

    protected void generateReport(List<Path> resultsPaths) throws MavenReportException {
        try {
            Path reportPath = Paths.get(this.getReportDirectory(), new String[0]);
            AllureCommandline commandline = new AllureCommandline(Paths.get(this.getInstallDirectory(), new String[0]), this.reportVersion);
            this.getLog().info((CharSequence)("Generate report to " + reportPath));
            commandline.generateReport(resultsPaths, reportPath);
            this.getLog().info((CharSequence)"Report generated successfully.");
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Can't generate allure report data", (Throwable)e);
            throw new MavenReportException("Can't generate allure report data", e);
        }
    }

    protected void readPropertiesFile(Properties properties) throws IOException {
        Path path = Paths.get(this.propertiesFilePath, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                properties.load(is);
            }
        }
    }

    protected void readPropertiesFileFromClasspath(String propertiesFileName, Properties properties) throws IOException, DependencyResolutionRequiredException {
        try (InputStream is = this.createProjectClassLoader().getResourceAsStream(propertiesFileName);){
            if (is != null) {
                properties.load(is);
            }
        }
    }

    protected void readPropertiesFromMap(Properties properties) {
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            if (property.getKey() == null || property.getValue() == null) continue;
            properties.setProperty(property.getKey(), property.getValue());
        }
    }

    protected void prepareProperties(Properties properties) {
        Properties allProperties = new Properties();
        allProperties.putAll((Map<?, ?>)properties);
        allProperties.putAll((Map<?, ?>)this.getProject().getProperties());
        allProperties.putAll((Map<?, ?>)System.getProperties());
        for (String name : properties.stringPropertyNames()) {
            properties.setProperty(name, StrSubstitutor.replace((Object)properties.getProperty(name), (Properties)allProperties));
        }
    }

    protected void render(Sink sink, String title) {
        sink.head();
        sink.title();
        sink.text(title);
        sink.title_();
        sink.head_();
        sink.body();
        sink.lineBreak();
        Path indexHtmlFile = Paths.get(this.getReportDirectory(), "index.html");
        String relativePath = Paths.get(this.reportingOutputDirectory, new String[0]).relativize(indexHtmlFile).toString();
        sink.rawText(String.format("<meta http-equiv=\"refresh\" content=\"0;url=%s\" />", relativePath));
        sink.link(relativePath);
        sink.body_();
        sink.flush();
        sink.close();
    }

    protected ClassLoader createProjectClassLoader() throws MalformedURLException, DependencyResolutionRequiredException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Object element : this.project.getTestClasspathElements()) {
            if (element == null || !(element instanceof String)) continue;
            URL url = Paths.get((String)element, new String[0]).toUri().toURL();
            result.add(url);
        }
        return new URLClassLoader(result.toArray(new URL[result.size()]));
    }

    public boolean canGenerateReport() {
        return !this.isAggregate() || this.project.isExecutionRoot();
    }

    protected boolean isAggregate() {
        return false;
    }

    protected boolean isDirectoryExists(Path path) {
        return Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
    }

    protected abstract List<Path> getInputDirectories();

    protected abstract String getMojoName();

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    public String getInstallDirectory() {
        return this.installDirectory;
    }
}

