/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.jms.runtime;

import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfig;
import io.quarkus.runtime.annotations.Recorder;
import java.util.function.Supplier;
import javax.jms.ConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSConnectionFactory;

@Recorder
public class ArtemisJmsRecorder {
    final ArtemisRuntimeConfig config;

    public ArtemisJmsRecorder(ArtemisRuntimeConfig config) {
        this.config = config;
    }

    public Supplier<ConnectionFactory> getConnectionFactorySupplier() {
        return new Supplier<ConnectionFactory>(){

            @Override
            public ConnectionFactory get() {
                return new ActiveMQJMSConnectionFactory(ArtemisJmsRecorder.this.config.url, (String)ArtemisJmsRecorder.this.config.username.orElse(null), (String)ArtemisJmsRecorder.this.config.password.orElse(null));
            }
        };
    }
}

