/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.CacheInvalidateAll;
import io.quarkus.cache.runtime.AbstractCache;
import io.quarkus.cache.runtime.CacheInterceptionContext;
import io.quarkus.cache.runtime.CacheInterceptor;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.logging.Logger;

@CacheInvalidateAll(cacheName="")
@Interceptor
@Priority(value=0)
public class CacheInvalidateAllInterceptor
extends CacheInterceptor {
    private static final Logger LOGGER = Logger.getLogger(CacheInvalidateAllInterceptor.class);
    private static final String INTERCEPTOR_BINDINGS_ERROR_MSG = "The Quarkus cache extension is not working properly (CacheInvalidateAll interceptor bindings retrieval failed), please create a GitHub issue in the Quarkus repository to help the maintainers fix this bug";

    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Exception {
        CacheInterceptionContext<CacheInvalidateAll> interceptionContext = this.getInterceptionContext(invocationContext, CacheInvalidateAll.class, false);
        if (interceptionContext.getInterceptorBindings().isEmpty()) {
            LOGGER.warn((Object)INTERCEPTOR_BINDINGS_ERROR_MSG);
        } else {
            for (CacheInvalidateAll binding : interceptionContext.getInterceptorBindings()) {
                AbstractCache cache = (AbstractCache)this.cacheManager.getCache(binding.cacheName()).get();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Invalidating all entries from cache [%s]", (Object)binding.cacheName());
                }
                cache.invalidateAll();
            }
        }
        return invocationContext.proceed();
    }
}

