/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.arc.runtime.InterceptorBindings;
import io.quarkus.cache.runtime.CacheKeyBuilder;
import io.quarkus.cache.runtime.CacheRepository;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;

public abstract class CacheInterceptor {
    public static final int BASE_PRIORITY = 0;
    @Inject
    CacheRepository cacheRepository;

    protected <T> List<T> getInterceptorBindings(InvocationContext context, Class<T> bindingClass) {
        ArrayList<Annotation> bindings = new ArrayList<Annotation>();
        for (Annotation binding : InterceptorBindings.getInterceptorBindings((InvocationContext)context)) {
            if (!bindingClass.isInstance(binding)) continue;
            bindings.add(binding);
        }
        return bindings;
    }

    protected <T> T getInterceptorBinding(InvocationContext context, Class<T> bindingClass) {
        return this.getInterceptorBindings(context, bindingClass).get(0);
    }

    protected Object buildCacheKey(String cacheName, short[] cacheKeyParameterPositions, Object[] methodParameterValues) {
        if (methodParameterValues.length == 0) {
            return CacheKeyBuilder.buildDefault(cacheName);
        }
        ArrayList<Object> keyElements = new ArrayList<Object>();
        if (cacheKeyParameterPositions.length > 0) {
            for (int i = 0; i < cacheKeyParameterPositions.length; ++i) {
                keyElements.add(methodParameterValues[i]);
            }
        } else {
            keyElements.addAll(Arrays.asList(methodParameterValues));
        }
        return CacheKeyBuilder.build(keyElements);
    }
}

